/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.external.biz.util;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.metric.calculator.AggregateOperation;
import com.wily.introscope.agent.metric.calculator.Calculator;
import com.wily.introscope.agent.metric.calculator.CalculatorService;
import com.wily.introscope.agent.metric.calculator.CalculatorSet;
import com.wily.introscope.agent.metric.calculator.MetricValue;
import com.wily.introscope.agent.metric.calculator.Operation;
import com.wily.introscope.agent.service.IDynamicService;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import java.util.Map;

public class BizDefCalculatorService
implements IDynamicService {
    private IAgent fAgent;
    private static final Module kModule = new Module("BizDefCalculatorService");
    private IModuleFeedbackChannel fFeedback;
    private CalculatorService calculatorService;
    private CalculatorSet calculatorSet;

    public int IAgentService_getServiceVersion() {
        return 2;
    }

    public void IAgentService_startService(IAgent agent, Map params) throws Exception {
        this.fAgent = agent;
        this.fFeedback = agent.IAgent_getModuleFeedback();
        this.fFeedback.info(kModule, "BizDef Calculator Service starting");
        this.createBtAggregateCalculators(agent);
    }

    public void IAgentService_stopService(IAgent agent) throws Exception {
        this.calculatorService.removeCalculatorSet(this.calculatorSet);
        this.fFeedback.info(kModule, "BizDef Calculator Servicee has stopped.");
    }

    private void createBtAggregateCalculators(IAgent agent) {
        this.calculatorService = (CalculatorService)agent.IAgent_getAgentCalculatorService();
        if (this.calculatorService == null) {
            this.fFeedback.info(kModule, "Cannot find agent calculator service!");
            return;
        }
        MetricValue metric = new MetricValue("Frontends|Apps|{0}|URLs|{1}|Business Segment|{2}|{3}|Health:{4}");
        Operation op1 = new AggregateOperation((Operation)metric).setResultMetric("Business Segment|{2}|{3}|Health:{4}");
        Calculator calculator = new Calculator().setMetricPattern("Frontends|Apps|{0}|URLs|{1}|Business Segment|{2}|{3}|Health:{4}").addOperation(op1);
        MetricValue metric2 = new MetricValue("Frontends|Apps|{0}|URLs|{1}|Business Segment Continued|{2}|{3}|Health:{4}");
        Operation op2 = new AggregateOperation((Operation)metric2).setResultMetric("Business Segment Continued|{2}|{3}|Health:{4}");
        Calculator calculator2 = new Calculator().setMetricPattern("Frontends|Apps|{0}|URLs|{1}|Business Segment Continued|{2}|{3}|Health:{4}").addOperation(op2);
        this.calculatorSet = new CalculatorSet("bizdef", new Calculator[]{calculator, calculator2});
        this.calculatorService.addCalculatorSet(this.calculatorSet);
    }
}

