/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.agent.jaxrs;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.IInvocationDataParameterCallback;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.hc2.BlamePointTracer;
import com.wily.powerpack.webservices.KConstants;
import com.wily.util.StringUtils;
import com.wily.util.properties.AttributeListing;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class JaxrsTracer
extends BlamePointTracer
implements IInvocationDataParameterCallback {
    final IAgent fAgent;
    public static final String PATH_ANNOTATION = "@javax.ws.rs.Path";
    public static HashMap<String, String> methodAnnotationToNameMap = new HashMap();
    public static final String NAMESPACE_PARAM_KEY = "namespace";
    public static final String OPERATIONNAME_PARAM_KEY = "operationname";
    public static final String HTTPMETHOD_PARAM_KEY = "HTTP RESTful Method";
    public String namespace = "";
    public String method = "";
    public String httpRESTfulMethod = "";

    public JaxrsTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        this.fAgent = agent;
        this.namespace = StringUtils.replaceIllegalChars((String)this.getPath(sampleTracedObject, probe), (char[])KConstants.kIllegalResourceChars, (char)'_');
        this.method = probe.getProbeMethodName();
    }

    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        data.put("com.wily.powerpack.webservices.trace.NamespaceKey", (Object)this.namespace);
        data.put("com.wily.powerpack.webservices.trace.OperationNameKey", (Object)this.method);
        if (!data.isParameterCallbackInitialized()) {
            data.setParameterCallback((IInvocationDataParameterCallback)this);
        }
        super.ITracer_startTrace(tracerIndex, data);
    }

    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        super.ITracer_finishTrace(tracerIndex, data);
    }

    public void IInvocationDataParameterCallback_addParameters(InvocationData data, Map parameters) {
        parameters.put(NAMESPACE_PARAM_KEY, this.namespace);
        parameters.put(OPERATIONNAME_PARAM_KEY, this.method);
        parameters.put(HTTPMETHOD_PARAM_KEY, this.httpRESTfulMethod);
    }

    public String getPath(Object invocationObject, ProbeIdentification probe) {
        Method[] methods;
        String methodName = probe.getProbeMethodName();
        String methodDescriptor = probe.getProbeMethodDescriptor();
        StringBuilder path = new StringBuilder();
        path = this.buildPathAndMethod(path, invocationObject.getClass().getAnnotations());
        for (Method method : methods = invocationObject.getClass().getMethods()) {
            String thisMethodName = method.getName();
            String thisMethodDescriptor = JaxrsTracer.getMethodDescriptor(method);
            if (!thisMethodName.equals(methodName) || !thisMethodDescriptor.equals(methodDescriptor)) continue;
            this.buildPathAndMethod(path, method.getAnnotations());
            break;
        }
        return path.toString();
    }

    public StringBuilder buildPathAndMethod(StringBuilder urlPath, Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            String stringRep = annotation.toString();
            if (stringRep.startsWith(PATH_ANNOTATION)) {
                StringBuffer rep = new StringBuffer(stringRep);
                int equal = rep.indexOf("=");
                int end = rep.lastIndexOf(")");
                if (equal <= 0 || end <= equal) continue;
                urlPath.append(rep.substring(equal + 1, end));
                continue;
            }
            if (!methodAnnotationToNameMap.containsKey(stringRep)) continue;
            this.httpRESTfulMethod = methodAnnotationToNameMap.get(stringRep);
        }
        return urlPath;
    }

    public static String getMethodDescriptor(Method method) {
        StringBuilder s = new StringBuilder();
        s.append("(");
        for (Class<?> c : method.getParameterTypes()) {
            s.append(JaxrsTracer.getDescriptorForClass(c));
        }
        s.append(")");
        return s.append(JaxrsTracer.getDescriptorForClass(method.getReturnType())).toString();
    }

    public static String getDescriptorForClass(Class c) {
        if (c.isPrimitive()) {
            if (c == Byte.TYPE) {
                return "B";
            }
            if (c == Character.TYPE) {
                return "C";
            }
            if (c == Double.TYPE) {
                return "D";
            }
            if (c == Float.TYPE) {
                return "F";
            }
            if (c == Integer.TYPE) {
                return "I";
            }
            if (c == Long.TYPE) {
                return "J";
            }
            if (c == Short.TYPE) {
                return "S";
            }
            if (c == Boolean.TYPE) {
                return "Z";
            }
            if (c == Void.TYPE) {
                return "V";
            }
        }
        if (c.isArray()) {
            return c.getName().replace('.', '/');
        }
        return ('L' + c.getName() + ';').replace('.', '/');
    }

    static {
        methodAnnotationToNameMap.put("@javax.ws.rs.GET()", "GET");
        methodAnnotationToNameMap.put("@javax.ws.rs.POST()", "POST");
        methodAnnotationToNameMap.put("@javax.ws.rs.PUT()", "PUT");
        methodAnnotationToNameMap.put("@javax.ws.rs.DELETE()", "DELETE");
        methodAnnotationToNameMap.put("@javax.ws.rs.HEAD()", "HEAD");
    }
}

