/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices.exceptionanalysis;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.sustainability.SustainabilityService;
import com.wily.powerpack.webservices.SoapHeaderInsertionPropertyConfiguration;
import com.wily.powerpack.webservices.exceptionanalysis.SOAPExceptionAnalyzerExceptionChainingBoundPropertyConfiguration;
import com.wily.powerpack.webservices.exceptionanalysis.SOAPExceptionAnalyzerExceptionQueueBoundPropertyConfiguration;
import com.wily.powerpack.webservices.exceptionanalysis.SOAPExceptionAnalyzerPropertyConfiguration;
import com.wily.powerpack.webservices.exceptionanalysis.SOAPExceptionAnalyzerSamplingRatePropertyConfiguration;
import com.wily.powerpack.webservices.exceptionanalysis.SOAPExceptionAnalyzerWorkerThreadRatePropertyConfiguration;
import com.wily.util.extension.ISafetyNetServiceCallback;
import com.wily.util.extension.SafetyNetServiceBroker;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class SOAPExceptionAnalyzer {
    private static IAgent fAgent;
    private static IModuleFeedbackChannel fLogger;
    private static ISafetyNetServiceCallback fSafetyNetCallback;
    public static volatile boolean isBroken;
    public static volatile boolean isInitialized;
    private static ScheduledExecutorService fExecutor;
    private static ConcurrentBoundedThrowableQueue fQueue;
    private static SOAPExceptionCheckMessageTask fTask;
    private static ScheduledFuture<?> fTaskFuture;
    private static final int kWorkerThreadCorePoolSize = 1;
    static String kCorrHeaderKey;
    private static String SOAP_ANALYZER_UP_MESSAGE;

    public static void init(IAgent agent) {
        if (!isInitialized) {
            fAgent = agent;
            fLogger = fAgent.IAgent_getModuleFeedback();
            isInitialized = true;
            SOAPExceptionAnalyzerPropertyConfiguration.init(agent);
            SOAPExceptionAnalyzerExceptionQueueBoundPropertyConfiguration.init(agent);
            SOAPExceptionAnalyzerExceptionChainingBoundPropertyConfiguration.init(agent);
            SOAPExceptionAnalyzerSamplingRatePropertyConfiguration.init(agent);
            SOAPExceptionAnalyzerWorkerThreadRatePropertyConfiguration.init(agent);
            if (!SoapHeaderInsertionPropertyConfiguration.isInitialized) {
                SoapHeaderInsertionPropertyConfiguration.init(agent);
            }
            fSafetyNetCallback = SafetyNetServiceBroker.getCallback();
        }
    }

    public static void analyzeThrowable(Throwable ex) {
        if (!SOAPExceptionAnalyzer.shouldRun(ex) || fQueue == null) {
            return;
        }
        fQueue.enqueue(ex);
    }

    private static boolean shouldRun(Throwable ex) {
        return ex != null && !isBroken && SOAPExceptionAnalyzerPropertyConfiguration.isSOAPExceptionAnalyzerEnabledHot();
    }

    public static void setupWorkerThread() {
        if (fQueue == null && SOAPExceptionAnalyzerPropertyConfiguration.isSOAPExceptionAnalyzerEnabledHot() && SoapHeaderInsertionPropertyConfiguration.isCorrelationSoapInsertionEnabledHot()) {
            fQueue = new ConcurrentBoundedThrowableQueue();
            fExecutor = Executors.newScheduledThreadPool(1, new ThreadFactory(){

                @Override
                public Thread newThread(Runnable runnable) {
                    Thread thread = new Thread(runnable);
                    thread.setName("SOAP Exception Periodic Analyzer");
                    thread.setDaemon(true);
                    return thread;
                }
            });
            fTask = new SOAPExceptionCheckMessageTask(fQueue);
            fTaskFuture = fExecutor.scheduleAtFixedRate(fTask, 0L, SOAPExceptionAnalyzerWorkerThreadRatePropertyConfiguration.getRate(), TimeUnit.SECONDS);
        }
    }

    public static void resetWorkerThreadTask() {
        if (fTaskFuture == null) {
            return;
        }
        fTaskFuture.cancel(true);
        fTask = new SOAPExceptionCheckMessageTask(fQueue);
        ScheduledFuture<?> taskFutureUpdated = fExecutor.scheduleAtFixedRate(fTask, 0L, SOAPExceptionAnalyzerWorkerThreadRatePropertyConfiguration.getRate(), TimeUnit.SECONDS);
        fTaskFuture = taskFutureUpdated;
    }

    public static void cancelWorkerThread() {
        if (fQueue != null && fTaskFuture != null) {
            fTaskFuture.cancel(true);
            fQueue = null;
            fExecutor.shutdownNow();
        }
    }

    static {
        isBroken = false;
        isInitialized = false;
        fExecutor = null;
        fQueue = null;
        fTask = null;
        fTaskFuture = null;
        kCorrHeaderKey = "WSCorIDSOAPHeader";
        SOAP_ANALYZER_UP_MESSAGE = "SOAP Exception Periodic Analyzer is activated.";
    }

    protected static class SOAPExceptionCheckMessageTask
    implements Runnable {
        private ConcurrentBoundedThrowableQueue fExceptions;

        public SOAPExceptionCheckMessageTask(ConcurrentBoundedThrowableQueue exceptions) {
            this.fExceptions = exceptions;
        }

        @Override
        public void run() {
            if (fLogger.isDebugEnabled()) {
                fLogger.debug(SOAP_ANALYZER_UP_MESSAGE);
            }
            int exceptionsCount = 0;
            while (!this.fExceptions.isEmpty()) {
                Throwable ex = this.fExceptions.dequeue();
                ++exceptionsCount;
                boolean isHeaderKeyPresentInExceptionMessage = this.analyze(ex);
                if (!isHeaderKeyPresentInExceptionMessage) continue;
                this.react();
                isBroken = true;
                break;
            }
            this.updateSustainabilityMetrics(exceptionsCount);
            this.fExceptions.resetLogUpperBoundReachedMessage();
        }

        private boolean analyze(Throwable ex) {
            return this.analyzeChainedExceptions(ex);
        }

        private void react() {
            fLogger.warn("SOAP Header insertion for correlation will be stopped, since " + kCorrHeaderKey + " was detected in a SOAP Fault (Exception message).");
            SoapHeaderInsertionPropertyConfiguration.setCorrelationSoapInsertionEnabledHot(false);
            if (fSafetyNetCallback == null) {
                fSafetyNetCallback = SafetyNetServiceBroker.getCallback();
            }
            if (fSafetyNetCallback != null) {
                fSafetyNetCallback.writeToBundlePropertiesFile("com.wily.introscope.agent.soapheaderinsertion.enabled", String.valueOf(false));
            }
            this.fExceptions.reset();
            SOAPExceptionAnalyzer.cancelWorkerThread();
        }

        protected boolean analyzeChainedExceptions(Throwable ex) {
            Throwable cause = null;
            Throwable result = ex;
            for (int exceptionChainingsDepth = SOAPExceptionAnalyzerExceptionChainingBoundPropertyConfiguration.getCount(); result != null && exceptionChainingsDepth > 0; --exceptionChainingsDepth) {
                if (this.checkHeaderInExceptionMessage(result.getMessage())) {
                    isBroken = true;
                    return true;
                }
                cause = result.getCause();
                if (cause == null || result == cause) break;
                result = cause;
            }
            return false;
        }

        private boolean checkHeaderInExceptionMessage(String message) {
            return message != null && message.contains(kCorrHeaderKey);
        }

        private void updateSustainabilityMetrics(int exceptionsCount) {
            SustainabilityService sustainabilityService = SustainabilityService.getSustainabilityServiceInstance();
            if (sustainabilityService != null && sustainabilityService.isSustainabilityMetricsEnabled()) {
                sustainabilityService.reportSOAPExceptionsAnalyzedCount((long)exceptionsCount);
            }
        }
    }

    public static class ConcurrentBoundedThrowableQueue {
        private ConcurrentLinkedQueue<Throwable> fBackingQueue = null;
        private AtomicInteger fBackingQueueSize = null;
        private long fLastEnqueueTimestamp = System.currentTimeMillis();
        private boolean shouldLogUpperBoundReachedMessage = true;

        public ConcurrentBoundedThrowableQueue() {
            this.fBackingQueue = new ConcurrentLinkedQueue();
            this.fBackingQueueSize = new AtomicInteger(0);
        }

        public void enqueue(Throwable ex) {
            if (!this.isUpperBoundReached() && this.validateEnqueueRate()) {
                this.fLastEnqueueTimestamp = System.currentTimeMillis();
                this.fBackingQueue.add(ex);
                this.fBackingQueueSize.incrementAndGet();
            }
        }

        public Throwable dequeue() {
            Throwable ex = this.fBackingQueue.poll();
            this.fBackingQueueSize.decrementAndGet();
            return ex;
        }

        public void reset() {
            this.fBackingQueue.clear();
            this.fBackingQueueSize.set(0);
            this.resetLogUpperBoundReachedMessage();
        }

        public void resetLogUpperBoundReachedMessage() {
            this.shouldLogUpperBoundReachedMessage = true;
        }

        public boolean isEmpty() {
            return this.fBackingQueueSize.get() <= 0;
        }

        private boolean isUpperBoundReached() {
            if (this.fBackingQueueSize.get() >= SOAPExceptionAnalyzerExceptionQueueBoundPropertyConfiguration.getSize()) {
                if (fLogger.isDebugEnabled() && this.shouldLogUpperBoundReachedMessage) {
                    fLogger.debug("The upper limit (" + SOAPExceptionAnalyzerExceptionQueueBoundPropertyConfiguration.getSize() + ") of queued SOAP Exceptions analysis is reached. Rejecting the current Throwable.");
                    this.shouldLogUpperBoundReachedMessage = false;
                }
                return true;
            }
            return false;
        }

        private boolean validateEnqueueRate() {
            double expectedRate;
            double currentRate = (double)(System.currentTimeMillis() - this.fLastEnqueueTimestamp) * 1.0;
            return currentRate >= (expectedRate = SOAPExceptionAnalyzerSamplingRatePropertyConfiguration.getRate());
        }
    }
}

