/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices.extension.agent.trace;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.powerpack.webservices.WSMUtils;
import com.wily.powerpack.webservices.extension.agent.trace.AWSTracer;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.properties.AttributeListing;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

public class SAPDeploymentTracer
extends AWSTracer {
    private IAgent agent = null;
    private IModuleFeedbackChannel logger = null;
    private String agentHome = null;

    public SAPDeploymentTracer(IAgent agent, AttributeListing attributeListing, ProbeIdentification probeIdentification, Object sample) {
        super(agent, attributeListing, probeIdentification, sample);
        this.agent = agent;
        this.logger = agent.IAgent_getModuleFeedback();
        this.agentHome = WSMUtils.getAbsoluteAgentPath();
    }

    public void ITracer_startTrace(int index, InvocationData invocationData) {
        ClassLoader parent = null;
        if (this.logger != null && this.logger.isDebugEnabled()) {
            this.logger.debug("Start In SAPDeploymentTracer:ITracer_startTrace");
            this.logger.debug("agentHome:" + this.agentHome);
        }
        try {
            Object wsContainer = invocationData.getInvocationObject();
            if (wsContainer != null) {
                parent = invocationData.getInvocationObject().getClass().getClassLoader();
                if (this.logger != null && this.logger.isDebugEnabled()) {
                    this.logger.debug("The classloader of WebserviceRuntime:" + parent);
                }
                Class<?> resourceClass = Class.forName("com.sap.engine.frame.core.load.res.Resource", true, invocationData.getInvocationObject().getClass().getClassLoader());
                Class<?> jarResourceClass = Class.forName("com.sap.engine.frame.core.load.res.JarResource", true, invocationData.getInvocationObject().getClass().getClassLoader());
                Constructor<?> jarResourceConstr = jarResourceClass.getDeclaredConstructor(String.class);
                Method method = invocationData.getInvocationObject().getClass().getClassLoader().getClass().getSuperclass().getDeclaredMethod("addResource", resourceClass);
                method.invoke((Object)parent, jarResourceConstr.newInstance(this.agentHome + File.separator + WSMUtils.getExtensionDirectory() + File.separator + "WebServicesAgent.jar"));
                if (this.logger != null && this.logger.isDebugEnabled()) {
                    this.logger.debug("Added JarResource to the classloader of WebserviceRuntime ");
                }
            }
        }
        catch (Throwable t) {
            this.logger.error("Unable to add the JarResource: " + t);
        }
        if (this.logger != null && this.logger.isDebugEnabled()) {
            this.logger.debug("End In SAPDeploymentTracer:ITracer_startTrace");
        }
    }

    public void ITracer_finishTrace(int index, InvocationData invocationData) {
    }
}

