/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices.extension.agent.trace;

import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.ASingleInstanceTracerFactory;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.powerpack.webservices.WSMUtils;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.properties.AttributeListing;
import java.lang.reflect.Method;

public class SOAPTransportBindingTracer
extends ASingleInstanceTracerFactory {
    private static final String kPrependClientHandler = "com.wily.introscope.soa.client.prependhandler";
    private static final String kAppendServerHandler = "com.wily.introscope.soa.server.appendhandler";
    private ReentrancyLevel fReEntryLeveL = this.calculateReentrancyLevel(ReentrancyLevel.kNone);
    private IAgent agent = null;
    private IModuleFeedbackChannel logger = null;
    private String agentHome = null;

    public SOAPTransportBindingTracer(IAgent agent, AttributeListing attributeListing, ProbeIdentification probeIdentification, Object sample) {
        super(agent, attributeListing, probeIdentification, sample);
        this.agent = agent;
        this.logger = agent.IAgent_getModuleFeedback();
        this.agentHome = WSMUtils.getAbsoluteAgentPath();
    }

    public ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return this.fReEntryLeveL;
    }

    public boolean ITracerFactory_isShutoff() {
        return false;
    }

    public void ITracer_finishTrace(int index, InvocationData invocationData) {
        try {
            boolean prop = AgentShim.getAgentShim().IAgentShim_getAgent().IAgent_getIndexedProperties().getBooleanProperty(kPrependClientHandler, true);
            if (!prop) {
                this.executeWilyHandler(invocationData);
            }
        }
        catch (Throwable th) {
            try {
                WSMUtils.getLogger().error("SOAPTransportBindingTracer: " + WSMUtils.dumpStackTrace(th));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void ITracer_startTrace(int index, InvocationData invocationData) {
        try {
            boolean prop = AgentShim.getAgentShim().IAgentShim_getAgent().IAgent_getIndexedProperties().getBooleanProperty(kPrependClientHandler, true);
            if (prop) {
                this.executeWilyHandler(invocationData);
            }
        }
        catch (Throwable th) {
            try {
                WSMUtils.getLogger().error("SOAPTransportBindingTracer: " + WSMUtils.dumpStackTrace(th));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void executeWilyHandler(InvocationData invocationData) {
        Object parent = null;
        Object wsCl = null;
        if (this.logger != null && this.logger.isDebugEnabled()) {
            this.logger.debug("Start In SOAPTransportBindingTracer:ITracer_startTrace");
            this.logger.debug("agentHome:" + this.agentHome);
        }
        try {
            int paramIndex = 1;
            String strMethod = invocationData.getProbeInformation().getProbeIdentification().getProbeMethodName();
            this.logger.debug("SOAPTransportBindingTracer-Method:" + strMethod);
            String strWSDMClientProtocolMethod = "";
            if (strMethod.equals("invokeHandlerRequest")) {
                strWSDMClientProtocolMethod = "handleRequest";
                paramIndex = 1;
            } else if (strMethod.equals("invokeHandleSOAPResponse")) {
                strWSDMClientProtocolMethod = "handleResponse";
                paramIndex = 2;
            } else {
                strWSDMClientProtocolMethod = "handleFault";
                paramIndex = 2;
            }
            String strWSDMClientProtocol = "com.wily.powerpack.webservices.handlers.netweaver.client.NW71JAXWSClientProtocol";
            String strClientConfigurationContext = "com.sap.engine.services.webservices.espbase.client.bindings.ClientConfigurationContext";
            ClassLoader wilyCL = WSMUtils.getWilyClassLoader();
            if (wilyCL == null) {
                this.logger.debug("Ignore SOAPTransportBindingTracer invocation before RuntimeProcessingEnvironment is created");
                return;
            }
            Class<?> wsdmClientProtocol = Class.forName(strWSDMClientProtocol, true, wilyCL);
            Class<?> clientConfigurationContext = Class.forName(strClientConfigurationContext, true, wilyCL);
            Method wsdmClientProtocolMethod = wsdmClientProtocol.getDeclaredMethod(strWSDMClientProtocolMethod, clientConfigurationContext);
            Object clientCongurationContextObj = invocationData.getInvocationParameterAsObject(paramIndex);
            wsdmClientProtocolMethod.invoke(WSMUtils.getWsdmClientProtocol(), clientCongurationContextObj);
        }
        catch (Throwable t) {
            StackTraceElement[] arr = t.getStackTrace();
            StringBuilder buf = new StringBuilder();
            for (int m = 0; m < arr.length; ++m) {
                buf.append(arr[m].toString() + "\n");
            }
            this.logger.debug("Unable to Execute WSDMClientProtocol.<method>" + buf.toString());
            this.logger.debug("Unable to Execute WSDMClientProtocol.<method> " + t);
        }
        if (this.logger != null && this.logger.isDebugEnabled()) {
            this.logger.debug("End In SOAPTransportBindingTracer:ITracer_startTrace");
        }
    }
}

