/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices.extension.agent.trace.correlation;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.transactiontrace.CorrelationId;
import com.wily.powerpack.webservices.WSMUtils;
import com.wily.powerpack.webservices.extension.agent.trace.correlation.WSClientCorrelationTracer;
import com.wily.util.properties.AttributeListing;
import java.lang.reflect.Field;

public class WAS61WSOutboundHTTPCorrelationTracer
extends WSClientCorrelationTracer {
    public WAS61WSOutboundHTTPCorrelationTracer(IAgent agent, AttributeListing attributeListing, ProbeIdentification probeIdentification, Object sample) {
        super(agent, attributeListing, probeIdentification, sample);
    }

    @Override
    public void ITracer_startTrace(int index, InvocationData data) {
        try {
            WSMUtils.refreshLogLevels();
            if (WSMUtils.getLogger().isDebugEnabled()) {
                WSMUtils.getLogger().debug("WAS61WSOutboundHTTPCorrelationTracer ITracer_startTrace data =" + data + " data.getInvocationObject()=" + data.getInvocationObject() + " agent=" + this.getAgent() + " data.getClass()=" + data.getClass());
            }
            boolean isHTTPInsertionEnabled = WSMUtils.correlationHTTPInsertionEnabled();
            this.insertHTTPCorrelationInfo(data, isHTTPInsertionEnabled);
        }
        catch (Throwable t) {
            WSMUtils.getLogger().error("WAS61WSOutboundHTTPCorrelationTracer ITracer_startTrace exception " + WSMUtils.dumpStackTrace(t));
            WSMUtils.handleError(this.getAgent(), "WAS61WSOutboundHTTPCorrelationTracer ITracer_startTrace exception " + t);
        }
    }

    protected void insertHTTPCorrelationInfo(InvocationData data, boolean isHTTPInsertionEnabled) throws Exception {
        if (isHTTPInsertionEnabled) {
            Object httpOutboundChannelConnection = data.getInvocationObject();
            Class<?> clzHttpOutboundChannelConnection = httpOutboundChannelConnection.getClass();
            Field fHttpOutSCclzHttpOutboundChannelConnection = WAS61WSOutboundHTTPCorrelationTracer.getDeclaredField(clzHttpOutboundChannelConnection, "httpOutSC");
            fHttpOutSCclzHttpOutboundChannelConnection.setAccessible(true);
            Object objHttpOutSC = fHttpOutSCclzHttpOutboundChannelConnection.get(httpOutboundChannelConnection);
            Object objHttpRequestMessage = WSMUtils.invokeMethodOnObject(objHttpOutSC, "getRequest");
            this.addCorrelationInfoToHttpHeaders(objHttpRequestMessage);
        }
    }

    protected void addCorrelationInfoToHttpHeaders(Object objHttpRequestMessage) throws Exception {
        CorrelationId corrId = new CorrelationId();
        String correlationString = corrId.getCurrentOutgoingCorrelationIdStrippedForHeader();
        WSMUtils.invokeMethodOnObject(objHttpRequestMessage, "setHeader", new Class[]{String.class, String.class}, new Object[]{"CorID", correlationString});
    }

    public static Field getDeclaredField(Class clazz, String name) {
        try {
            return clazz.getDeclaredField(name);
        }
        catch (NoSuchFieldException nsfe) {
            if (WSMUtils.getLogger().isDebugEnabled()) {
                WSMUtils.getLogger().debug("WAS61WSOutboundHTTPCorrelationTracer trying iterate class hierarchy, because of exception in ITracer_startTrace " + WSMUtils.dumpStackTrace(nsfe));
            }
            return WAS61WSOutboundHTTPCorrelationTracer.getDeclaredField1(clazz, name);
        }
    }

    public static Field getDeclaredField1(Class clazz, String name) {
        Field[] fields;
        for (Field field : fields = clazz.getDeclaredFields()) {
            if (!name.equals(field.getName())) continue;
            return field;
        }
        Class superClass = clazz.getSuperclass();
        if (superClass != null) {
            return WAS61WSOutboundHTTPCorrelationTracer.getDeclaredField1(superClass, name);
        }
        return null;
    }
}

