/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices.extension.agent.trace.fault.websphere.hc2;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.stat.IDataAccumulator;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.powerpack.webservices.WSMUtils;
import com.wily.powerpack.webservices.extension.agent.errors.hc2.SoapFaultReportingTracer;
import com.wily.util.properties.AttributeListing;

public class WAS61ServerFaultTracer
extends SoapFaultReportingTracer {
    public WAS61ServerFaultTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    @Override
    protected String getFaultMessage(InvocationData data) {
        try {
            Object fault;
            Object messageContext = data.getInvocationParameterAsObject(0);
            Object message = WSMUtils.invokeMethodOnObject(messageContext, "getCurrentMessage");
            Object soapEnvelope = WSMUtils.invokeMethodOnObject(message, "getSOAPEnvelope");
            Object body = WSMUtils.invokeMethodOnObject(soapEnvelope, "getBody");
            Boolean hasFault = (Boolean)WSMUtils.invokeMethodOnObject(body, "hasFault");
            if (hasFault.booleanValue() && (fault = WSMUtils.invokeMethodOnObject(body, "getFault")) != null) {
                return (String)WSMUtils.invokeMethodOnObject(fault, "getFaultString");
            }
            if (data.hasInvocationThrownException()) {
                return data.getInvocationThrownException().getMessage();
            }
        }
        catch (Throwable bomb) {
            WSMUtils.handleException(this.getAgent(), "WAS61ServerFaultTracer reportFaultIfExists", bomb);
        }
        return null;
    }

    @Override
    protected String getTitle() {
        return "WAS61ServerFaultTracer";
    }

    protected IDataAccumulator createDataAccumulator(String arg0) {
        return null;
    }
}

