/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices.extension.agent.trace.jboss;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.transactiontrace.CorrelationId;
import com.wily.powerpack.webservices.WSMUtils;
import com.wily.powerpack.webservices.extension.agent.trace.correlation.WSCorrelationTracer;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.properties.AttributeListing;
import java.lang.reflect.Constructor;
import java.util.Iterator;

public class JBossServerSOAPCorrelationTracer
extends WSCorrelationTracer {
    private IModuleFeedbackChannel logger = null;

    public JBossServerSOAPCorrelationTracer(IAgent agent, AttributeListing attributeListing, ProbeIdentification probeIdentification, Object sample) {
        super(agent, attributeListing, probeIdentification, sample);
        this.logger = agent.IAgent_getModuleFeedback();
        WSMUtils.refreshLogLevels();
    }

    public Object getSOAPMessage(InvocationData data) throws Exception {
        if (data.getInvocationParameterCount() < 2) {
            this.logger.debug("JBossServerNameFormatter getOperationMetaData getInvocationParameterCount=" + data.getInvocationParameterCount() + " getInvocationObject()=" + data.getInvocationObject().getClass());
            return null;
        }
        Object invocation = data.getInvocationParameterAsObject(1);
        Object invocationContext = WSMUtils.invokeMethodOnObject(invocation, "getInvocationContext");
        ClassLoader threadClassLoader = invocationContext.getClass().getClassLoader();
        Object messageContext = WSMUtils.invokeMethodOnObject(invocationContext, "getAttachment", new Class[]{Class.class}, new Object[]{Class.forName("javax.xml.ws.handler.MessageContext", true, threadClassLoader)});
        if (messageContext == null) {
            messageContext = WSMUtils.invokeMethodOnObject(invocationContext, "getAttachment", new Class[]{Class.class}, new Object[]{Class.forName("javax.xml.rpc.handler.MessageContext", true, threadClassLoader)});
        }
        if (messageContext == null) {
            this.logger.debug("JBossServerNameFormatter getOperationMetaData (messageContext == null)");
            return null;
        }
        Object soapMessage = null;
        try {
            soapMessage = WSMUtils.invokeMethodOnObject(messageContext, "getSOAPMessage");
        }
        catch (Exception nsme) {
            soapMessage = this.getSoapMessageFromWrappedMessageContext(messageContext, threadClassLoader);
        }
        return soapMessage;
    }

    private Object getSoapMessageFromWrappedMessageContext(Object msgContext, ClassLoader cl) {
        Object result = null;
        Object wmsg = null;
        if (msgContext != null) {
            try {
                wmsg = WSMUtils.getField(msgContext, "message");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (wmsg != null) {
            try {
                Class<?> cls = Class.forName("org.apache.cxf.jaxws.handler.soap.SOAPMessageContextImpl", false, wmsg.getClass().getClassLoader());
                Class[] partypes = new Class[]{Class.forName("org.apache.cxf.message.Message", true, wmsg.getClass().getClassLoader())};
                Constructor<?> ct = cls.getConstructor(partypes);
                Object[] arglist = new Object[]{wmsg};
                Object sOAPMessageContextImpl = ct.newInstance(arglist);
                result = WSMUtils.invokeDeclaredMethodOnObject(sOAPMessageContextImpl, "getMessage");
            }
            catch (Throwable e) {
                WSMUtils.handleException(this.getAgent(), "", e);
            }
        }
        return result;
    }

    @Override
    public void ITracer_startTrace(int index, InvocationData data) {
        if (!WSMUtils.correlationSOAPReadEnabled()) {
            return;
        }
        if (this.logger != null && this.logger.isDebugEnabled()) {
            this.logger.debug("JBossServerSOAPCorrelationTracer.ITracer_startTrace() invoking class=" + data.getInvocationObject().getClass().getName());
        }
        try {
            boolean correlationIdFound = false;
            Object soapMessageImpl = this.getSOAPMessage(data);
            if (soapMessageImpl != null) {
                ClassLoader threadClassLoader = soapMessageImpl.getClass().getClassLoader();
                Object soapPart = WSMUtils.invokeMethodOnObject(soapMessageImpl, "getSOAPPart");
                Object sOAPEnvelope = WSMUtils.invokeMethodOnObject(soapPart, "getEnvelope");
                Object header = WSMUtils.invokeMethodOnObject(sOAPEnvelope, "getHeader");
                Object attrName = WSMUtils.invokeMethodOnObject(sOAPEnvelope, "createName", new Class[]{String.class}, new Object[]{"CorID"});
                if (this.logger != null && this.logger.isDebugEnabled()) {
                    this.logger.debug("JBossServerSOAPCorrelationTracer::ITracer_startTrace: header=" + header);
                }
                if (header != null) {
                    Iterator it = (Iterator)WSMUtils.invokeMethodOnObject(header, "getChildElements");
                    while (it.hasNext()) {
                        Object elementName;
                        String headerName;
                        Object childElement = it.next();
                        if (this.logger != null && this.logger.isDebugEnabled()) {
                            this.logger.debug("JBossServerSOAPCorrelationTracer::ITracer_startTrace: in while childElement class=" + childElement.getClass());
                        }
                        if (!(headerName = (String)WSMUtils.invokeMethodOnObject(elementName = WSMUtils.invokeMethodOnObject(childElement, "getElementName"), "getLocalName")).equals("WSCorIDSOAPHeader")) continue;
                        correlationIdFound = true;
                        String correlationId = (String)WSMUtils.invokeMethodOnObject(childElement, "getAttributeValue", new Class[]{Class.forName("javax.xml.soap.Name", true, threadClassLoader)}, new Object[]{attrName});
                        if (this.logger != null && this.logger.isDebugEnabled()) {
                            this.logger.debug("JBossServerSOAPCorrelationTracer::ITracer_startTrace: server correlationId=" + correlationId);
                        }
                        CorrelationId correlationIdTmp = new CorrelationId(correlationId);
                        break;
                    }
                }
            }
            if (!correlationIdFound) {
                this.logger.debug("JBossServerSOAPCorrelationTracer::processCorrelationId: correlation id not found");
                CorrelationId correlationId = new CorrelationId();
            }
        }
        catch (Throwable t) {
            this.logger.error("JBossServerSOAPCorrelationTracer ITracer_startTrace exception " + WSMUtils.dumpStackTrace(t));
        }
    }
}

