/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices.extension.agent.trace.nameformatter;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.INameFormatter;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.powerpack.webservices.KConstants;
import com.wily.powerpack.webservices.WSMUtils;
import com.wily.util.StringUtils;
import com.wily.util.feedback.IModuleFeedbackChannel;

public class JAXWSNameFormatter
implements INameFormatter,
KConstants {
    protected final IAgent fAgent;
    protected String operationName = "UnknownOperationName";
    protected String serviceName = "UnknownService";
    protected String namespace = "UnknownNamespace";
    protected IModuleFeedbackChannel logger;

    protected IAgent getAgent() {
        return this.fAgent;
    }

    public JAXWSNameFormatter(IAgent agent) {
        this.fAgent = agent;
        this.logger = this.fAgent.IAgent_getModuleFeedback();
    }

    protected String getOperationName(InvocationData data) {
        return this.operationName;
    }

    protected String getServiceName(InvocationData data) {
        return this.serviceName;
    }

    protected String getNamespace(InvocationData data) {
        return this.namespace;
    }

    public String INameFormatter_format(String name, InvocationData data) {
        String currNamespace = "UnknownNamespace";
        String currServiceName = "UnknownService";
        String currOperationName = "UnknownOperationName";
        if (name != null) {
            if (name.indexOf("{namespace}", 0) >= 0) {
                currNamespace = this.getNamespace(data);
                if (currNamespace == null) {
                    currNamespace = this.getServiceName(data);
                }
                currNamespace = WSMUtils.formatToBeResourceSafe(currNamespace);
                name = StringUtils.replace((String)name, (String)"{namespace}", (String)currNamespace);
            }
            if (name.indexOf("{servicename}", 0) >= 0) {
                currServiceName = this.getServiceName(data);
                if (currServiceName == null) {
                    currServiceName = "UnknownService";
                }
                currServiceName = WSMUtils.formatToBeResourceSafe(currServiceName);
                name = StringUtils.replace((String)name, (String)"{servicename}", (String)currServiceName);
            }
            if (name.indexOf("{operationname}", 0) >= 0) {
                currOperationName = this.getOperationName(data);
                if (currOperationName == null) {
                    currOperationName = "UnknownOperationName";
                }
                currOperationName = WSMUtils.formatToBeResourceSafe(currOperationName);
                name = StringUtils.replace((String)name, (String)"{operationname}", (String)currOperationName);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("[JAXWSNameFormatter] namespace=" + currNamespace + " operationName=" + currOperationName + " serviceName=" + currServiceName);
            }
        }
        return name;
    }
}

