/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices.extension.agent.trace.nameformatter;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.INameFormatter;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.powerpack.webservices.KConstants;
import com.wily.powerpack.webservices.WSMUtils;
import com.wily.util.StringUtils;
import java.lang.reflect.Field;

public abstract class PacketNameFormatter
implements INameFormatter,
KConstants {
    private final IAgent agent;

    public PacketNameFormatter(IAgent agent) {
        this.agent = agent;
    }

    public abstract Object getPacket(InvocationData var1);

    public String INameFormatter_format(String name, InvocationData data) {
        String operationName = null;
        String serviceName = null;
        String namespace = null;
        WSMUtils.getLogger().debug("\nSTART:PacketNameFormatter.INameFormatter_format()");
        try {
            try {
                Object objPacket = this.getPacket(data);
                Object objMessage = WSMUtils.invokeMethodOnObject(objPacket, "getMessage");
                namespace = (String)WSMUtils.invokeMethodOnObject(objMessage, "getPayloadNamespaceURI");
                WSMUtils.getLogger().debug("PacketNameFormatter.namespace:" + namespace);
                operationName = (String)WSMUtils.invokeMethodOnObject(objMessage, "getPayloadLocalPart");
                WSMUtils.getLogger().debug("PacketNameFormatter.operation:" + operationName);
                Field fldWSEndpointImpl = objPacket.getClass().getField("endpoint");
                Object objWSEndpoint = fldWSEndpointImpl.get(objPacket);
                if (objWSEndpoint == null) {
                    return name;
                }
                Object seiModelObj = WSMUtils.invokeMethodOnObject(objWSEndpoint, "getSEIModel");
                if (seiModelObj != null) {
                    Object svcnameObj = WSMUtils.invokeMethodOnObject(seiModelObj, "getServiceQName");
                    serviceName = (String)WSMUtils.invokeMethodOnObject(svcnameObj, "getLocalPart");
                    WSMUtils.getLogger().debug("PacketNameFormatter.serviceName:" + serviceName);
                }
                data.put("com.wily.powerpack.webservices.trace.NamespaceKey", (Object)namespace);
                data.put("com.wily.powerpack.webservices.trace.ServiceNameKey", (Object)serviceName);
                data.put("com.wily.powerpack.webservices.trace.OperationNameKey", (Object)operationName);
            }
            catch (Exception e1) {
                this.agent.IAgent_getModuleFeedback().error((Throwable)e1);
            }
            if (name.indexOf("{namespace}", 0) >= 0) {
                if (namespace == null) {
                    namespace = serviceName;
                    if (serviceName == null) {
                        namespace = "UnknownService";
                    }
                }
                namespace = WSMUtils.formatToBeResourceSafe(namespace);
                name = StringUtils.replace((String)name, (String)"{namespace}", (String)namespace);
            }
            if (name.indexOf("{servicename}", 0) >= 0) {
                if (serviceName == null) {
                    serviceName = "UnknownService";
                }
                serviceName = WSMUtils.formatToBeResourceSafe(serviceName);
                name = StringUtils.replace((String)name, (String)"{servicename}", (String)serviceName);
            }
            if (name.indexOf("{operationname}", 0) >= 0) {
                if (operationName == null) {
                    operationName = "UnknownOperationName";
                }
                operationName = WSMUtils.formatToBeResourceSafe(operationName);
                name = StringUtils.replace((String)name, (String)"{operationname}", (String)operationName);
            }
        }
        catch (Exception e) {
            this.agent.IAgent_getModuleFeedback().error((Throwable)e);
        }
        return name;
    }
}

