/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices.extension.agent.trace.nameformatter.axis2;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.powerpack.webservices.WSMUtils;
import com.wily.powerpack.webservices.extension.agent.trace.nameformatter.ANameFormatter;
import com.wily.util.feedback.IModuleFeedbackChannel;

public class Axis2ServerNameFormatter
extends ANameFormatter {
    protected IModuleFeedbackChannel logger;

    public Axis2ServerNameFormatter(IAgent agent) {
        super(agent);
        this.logger = agent.IAgent_getModuleFeedback();
        WSMUtils.refreshLogLevels();
    }

    @Override
    public String getNamespace(InvocationData data) {
        String namespaceURI = null;
        Object call = null;
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Axis2ServerNameFormatter::getNamespace");
            }
            if ((call = data.getInvocationParameterAsObject(0)) != null && (call = WSMUtils.invokeMethodOnObject(call, "getAxisService")) != null) {
                namespaceURI = (String)WSMUtils.invokeMethodOnObject(call, "getTargetNamespace");
            }
        }
        catch (Throwable bomb) {
            WSMUtils.handleException(this.getAgent(), "Axis2ServerNameFormatter getNamespace ", bomb);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Axis2ServerNameFormatter:: namespaceURI= " + namespaceURI);
        }
        return namespaceURI;
    }

    @Override
    public String getServiceName(InvocationData data) {
        String serviceURI = (String)data.get("com.wily.powerpack.webservices.trace.ServiceNameKey");
        if (serviceURI != null) {
            return serviceURI;
        }
        Object call = null;
        try {
            Object endPointReference;
            call = data.getInvocationParameterAsObject(0);
            if (call != null && (endPointReference = WSMUtils.invokeMethodOnObject(call, "getTo")) != null) {
                serviceURI = (String)WSMUtils.invokeMethodOnObject(endPointReference, "getAddress");
            }
            if ((serviceURI == null || "".equals(serviceURI.trim())) && (call = WSMUtils.invokeMethodOnObject(call, "getOperationContext")) != null && (call = WSMUtils.invokeMethodOnObject(call, "getServiceContext")) != null && (call = WSMUtils.invokeMethodOnObject(call, "getMyEPR")) != null) {
                serviceURI = (String)WSMUtils.invokeMethodOnObject(call, "getAddress");
                serviceURI = WSMUtils.removeTrailingSlash(serviceURI);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Axis2ServerNameFormatter::getServiceName  address=" + serviceURI);
                }
            }
        }
        catch (Throwable bomb) {
            WSMUtils.handleException(this.getAgent(), "Axis2ServerNameFormatter getServiceName ", bomb);
        }
        data.put("com.wily.powerpack.webservices.trace.ServiceNameKey", (Object)serviceURI);
        return serviceURI;
    }

    @Override
    public String getOperationName(InvocationData data) {
        String operationName = (String)data.get("com.wily.powerpack.webservices.trace.OperationNameKey");
        if (operationName != null) {
            return operationName;
        }
        Object call = null;
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Axis2ServerNameFormatter::getOperationName");
            }
            if (data.hasInvocationParametersAvailable() && (call = data.getInvocationParameterAsObject(0)) != null && (call = WSMUtils.invokeMethodOnObject(call, "getAxisOperation")) != null && (call = WSMUtils.invokeMethodOnObject(call, "getName")) != null) {
                operationName = (String)WSMUtils.invokeMethodOnObject(call, "getLocalPart");
            }
        }
        catch (Throwable bomb) {
            WSMUtils.handleException(this.getAgent(), "Axis2ServerNameFormatter getOperationName ", bomb);
        }
        if (operationName == null || operationName.equals("")) {
            operationName = "UnknownOperationName";
        }
        data.put("com.wily.powerpack.webservices.trace.OperationNameKey", (Object)operationName);
        return operationName;
    }
}

