/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices.extension.agent.trace.nameformatter.cxf;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.INameFormatter;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.powerpack.webservices.KConstants;
import com.wily.powerpack.webservices.WSMUtils;
import com.wily.util.StringUtils;
import java.lang.reflect.Method;
import java.util.Map;

public class CXFClientProxyNameFormatter
implements INameFormatter,
KConstants {
    private IAgent fAgent;

    public CXFClientProxyNameFormatter(IAgent agent) {
        this.fAgent = agent;
    }

    private IAgent getAgent() {
        return this.fAgent;
    }

    public void populate(InvocationData data) {
        try {
            Boolean isPopulated = (Boolean)data.get("isPopulated");
            if (isPopulated != null && isPopulated.booleanValue()) {
                this.getAgent().IAgent_getModuleFeedback().debug("isPopulated namespace=" + (String)data.get("com.wily.powerpack.webservices.trace.NamespaceKey") + " operationName=" + (String)data.get("com.wily.powerpack.webservices.trace.OperationNameKey"));
                return;
            }
            String operationname = ((Method)data.getInvocationParameterAsObject(0)).getName();
            Object objClientProxy = data.getInvocationObject();
            Object objClient = objClientProxy.getClass().getMethod("getClient", new Class[0]).invoke(objClientProxy, new Object[0]);
            Map mapRequestContext = (Map)objClient.getClass().getMethod("getRequestContext", new Class[0]).invoke(objClient, new Object[0]);
            Object endpoint = objClient.getClass().getMethod("getEndpoint", new Class[0]).invoke(objClient, new Object[0]);
            Object endpointInfo = endpoint.getClass().getMethod("getEndpointInfo", new Class[0]).invoke(endpoint, new Object[0]);
            Object address = endpointInfo.getClass().getMethod("getAddress", new Class[0]).invoke(endpointInfo, new Object[0]);
            String serviceName = WSMUtils.formatURLToBeResourceSafe((String)address);
            if (serviceName == null) {
                serviceName = "UnknownSN";
            }
            mapRequestContext.put("com.wily.powerpack.webservices.trace.ServiceNameKey", serviceName);
            data.put("com.wily.powerpack.webservices.trace.ServiceNameKey", (Object)serviceName);
            Object objBindingOperation = data.getInvocationParameterAsObject(1);
            Object opQName = objBindingOperation.getClass().getMethod("getName", new Class[0]).invoke(objBindingOperation, new Object[0]);
            String namespace = (String)WSMUtils.invokeMethodOnObject(opQName, "getNamespaceURI");
            mapRequestContext.put("com.wily.powerpack.webservices.trace.NamespaceKey", namespace);
            data.put("com.wily.powerpack.webservices.trace.NamespaceKey", (Object)namespace);
            mapRequestContext.put("com.wily.powerpack.webservices.trace.OperationNameKey", operationname);
            data.put("com.wily.powerpack.webservices.trace.OperationNameKey", (Object)operationname);
            data.put("isPopulated", (Object)true);
            this.getAgent().IAgent_getModuleFeedback().debug("isPopulated2 namespace=" + (String)data.get("com.wily.powerpack.webservices.trace.NamespaceKey") + " operationName=" + (String)data.get("com.wily.powerpack.webservices.trace.OperationNameKey"));
        }
        catch (Exception e) {
            WSMUtils.handleException(this.getAgent(), "CXFClientProxyNameFormatter populate", e);
        }
    }

    public String INameFormatter_format(String name, InvocationData data) {
        this.populate(data);
        if (name == null) {
            return null;
        }
        String namespace = (String)data.get("com.wily.powerpack.webservices.trace.NamespaceKey");
        String serviceName = (String)data.get("com.wily.powerpack.webservices.trace.ServiceNameKey");
        String operationName = (String)data.get("com.wily.powerpack.webservices.trace.OperationNameKey");
        if (name.indexOf("{namespace}", 0) >= 0) {
            if (namespace == null) {
                namespace = serviceName;
            }
            if (namespace == null) {
                namespace = "UnknownNamespace";
            }
            namespace = CXFClientProxyNameFormatter.formatToBeResourceSafe(namespace);
            name = StringUtils.replace((String)name, (String)"{namespace}", (String)namespace);
        }
        if (name.indexOf("{servicename}", 0) >= 0) {
            if (serviceName == null) {
                serviceName = "UnknownService";
            }
            serviceName = CXFClientProxyNameFormatter.formatToBeResourceSafe(serviceName);
            name = StringUtils.replace((String)name, (String)"{servicename}", (String)serviceName);
        }
        if (name.indexOf("{operationname}", 0) >= 0) {
            if (operationName == null) {
                operationName = "UnknownOperationName";
            }
            operationName = CXFClientProxyNameFormatter.formatToBeResourceSafe(operationName);
            name = StringUtils.replace((String)name, (String)"{operationname}", (String)operationName);
        }
        return name;
    }

    public static String formatToBeResourceSafe(String value) {
        return StringUtils.replaceIllegalChars((String)value, (char[])kIllegalResourceChars, (char)'_');
    }
}

