/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices.extension.agent.trace.nameformatter.netweaver;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.INameFormatter;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.powerpack.webservices.KConstants;
import com.wily.powerpack.webservices.WSMUtils;
import com.wily.util.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class NWS71Formatter
implements INameFormatter,
KConstants {
    private static final String kInput = "input";
    private static final String kOperationName = "operationName";
    private static final String kEndpointUrl = "endpointUrl";
    private static final String kBindingConfig = "bindingConfig";
    private static final String kFeatureConfig = "featureConfig";
    private static final String kTypeMapping = "typeMapping";
    private static final String kNamespace = "namespace";
    private static final String kStyle = "style";
    private static final String kWriteTo = "writeTo";
    private static final String kEnvelope = "Envelope";
    private static final String kBody = "Body";
    private static final String kDocument = "document";
    private static final String kRPC = "rpc";
    private static final String kInitDeserializationMode = "initDeserializationMode";
    private static final String kGetSoapBody = "getSoapBody";
    private final IAgent fAgent;

    public NWS71Formatter(IAgent agent) {
        this.fAgent = agent;
    }

    public ClassLoader setClassLoader(ClassLoader cl, IAgent agent) {
        WSMUtils.getLogger().debug("anameformatter.setClassLoader()");
        return WSMUtils.setClassLoader(cl, agent);
    }

    protected Class getClassFromInvocationObjectLoader(String className, InvocationData data) throws ClassNotFoundException {
        Class<?> clazz = (Class<?>)data.get(className);
        if (clazz == null) {
            String classNameString = data.getInvocationObject().getClass().getName();
            ClassLoader cl = data.getInvocationObject().getClass().getClassLoader();
            if (classNameString.indexOf("com.wily") >= 0) {
                cl = cl.getParent();
            }
            WSMUtils.getLogger().debug("anameformatter.getClassFromInvocationObjectLoader(): " + data.getInvocationObject().getClass().getName());
            ClassLoader classLoader = this.setClassLoader(cl, this.getAgent());
            if (classLoader != null) {
                clazz = classLoader.loadClass(className);
                data.put(className, clazz);
            } else {
                WSMUtils.getLogger().error("anameformatter, wsdmclassloader is null");
            }
        }
        return clazz;
    }

    protected IAgent getAgent() {
        return this.fAgent;
    }

    public String INameFormatter_format(String name, InvocationData data) {
        String namespace = null;
        String operationName = null;
        if (name != null) {
            if (name.indexOf("{namespace}", 0) >= 0) {
                namespace = (String)data.get("com.wily.powerpack.webservices.trace.NamespaceKey");
                if ((namespace == null || namespace.equals("UnknownService")) && (namespace = this.getNamespace(data)) == null) {
                    namespace = "UnknownService";
                }
                namespace = WSMUtils.formatToBeResourceSafe(namespace);
                data.put("com.wily.powerpack.webservices.trace.NamespaceKey", (Object)namespace);
                name = StringUtils.replace((String)name, (String)"{namespace}", (String)namespace);
            }
            if (name.indexOf("{servicename}", 0) >= 0) {
                namespace = (String)data.get("com.wily.powerpack.webservices.trace.NamespaceKey");
                if ((namespace == null || namespace.equals("UnknownService")) && (namespace = this.getServiceName(data)) == null) {
                    namespace = "UnknownService";
                }
                namespace = WSMUtils.formatToBeResourceSafe(namespace);
                data.put("com.wily.powerpack.webservices.trace.NamespaceKey", (Object)namespace);
                name = StringUtils.replace((String)name, (String)"{servicename}", (String)namespace);
            }
            if (name.indexOf("{operationname}", 0) >= 0) {
                operationName = (String)data.get("com.wily.powerpack.webservices.trace.OperationNameKey");
                if ((operationName == null || operationName.equals("UnknownOperationName")) && (operationName = this.getOperationName(data)) == null) {
                    operationName = "UnknownOperationName";
                }
                operationName = WSMUtils.formatToBeResourceSafe(operationName);
                data.put("com.wily.powerpack.webservices.trace.OperationNameKey", (Object)operationName);
                name = StringUtils.replace((String)name, (String)"{operationname}", (String)operationName);
            }
        }
        return name;
    }

    private Object getBindingConfig(InvocationData data) throws NoSuchMethodException, SecurityException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Object invObj = data.getInvocationParameterAsObject(0);
        Method m = WSMUtils.getMethodForObject(invObj, "getSubContext", new Class[]{String.class});
        Object configObj = m.invoke(invObj, kBindingConfig);
        return configObj;
    }

    public String getOperationName(InvocationData data) {
        String opName = null;
        Object clientCongurationContextObj = data.getInvocationParameterAsObject(0);
        try {
            String javaOpName = this.getJavaOperationName(data);
            Method m = WSMUtils.getMethodForObject(clientCongurationContextObj, "getStaticContext", null);
            Object stcCtx = m.invoke(clientCongurationContextObj, new Object[0]);
            Method m2 = WSMUtils.getMethodForObject(stcCtx, "getInterfaceData", null);
            Object infData = m2.invoke(stcCtx, new Object[0]);
            Method m3 = WSMUtils.getMethodForObject(infData, "getOperationByJavaName", new Class[]{String.class});
            Object opMap = m3.invoke(infData, javaOpName);
            Method m4 = WSMUtils.getMethodForObject(opMap, "getWSDLOperationName", null);
            opName = (String)m4.invoke(opMap, new Object[0]);
        }
        catch (Throwable e) {
            WSMUtils.getLogger().error("NWS6Formatter::getOperationName.Unable to getOperationName:" + e);
        }
        return StringUtils.isEmpty(opName) ? "UnknownOperationName" : opName;
    }

    public String getJavaOperationName(InvocationData data) {
        String name = null;
        Object clientCongurationContextObj = data.getInvocationParameterAsObject(0);
        try {
            Method m = WSMUtils.getMethodForObject(clientCongurationContextObj, "getOperationName", null);
            name = (String)m.invoke(clientCongurationContextObj, new Object[0]);
        }
        catch (Throwable e) {
            WSMUtils.getLogger().error("NWS71Formatter::getJavaOperationName.Unable to getOperation from client configuration context:" + e);
        }
        return StringUtils.isEmpty((String)name) ? "UnknownOperationName" : name;
    }

    public String getServiceName(InvocationData data) {
        String name = null;
        Object clientCongurationContextObj = data.getInvocationParameterAsObject(0);
        try {
            Method m = WSMUtils.getMethodForObject(clientCongurationContextObj, "getServiceContext", null);
            Object svcContext = m.invoke(clientCongurationContextObj, new Object[0]);
            Method m1 = WSMUtils.getMethodForObject(svcContext, "getServiceName", null);
            Object svcQName = m1.invoke(svcContext, new Object[0]);
            Method m2 = WSMUtils.getMethodForObject(svcQName, "getNamespaceURI", null);
            String svcNameSpaceURI = (String)m2.invoke(svcQName, new Object[0]);
            Method m3 = WSMUtils.getMethodForObject(svcQName, "getLocalPart", null);
            String svcName = (String)m3.invoke(svcQName, new Object[0]);
            name = WSMUtils.formatURLToBeResourceSafe(svcNameSpaceURI + svcName);
        }
        catch (Throwable e) {
            name = "UnknownService";
            WSMUtils.getLogger().error("NWS6Formatter.getServiceName().Unable to get Servicename:" + e);
        }
        return StringUtils.isEmpty((String)name) ? "UnknownService" : name;
    }

    public String getNamespace(InvocationData data) {
        String namespace = null;
        Object clientCongurationContextObj = data.getInvocationParameterAsObject(0);
        try {
            String javaOpName = this.getJavaOperationName(data);
            Method m = WSMUtils.getMethodForObject(clientCongurationContextObj, "getStaticContext", null);
            Object stcCtx = m.invoke(clientCongurationContextObj, new Object[0]);
            Method m2 = WSMUtils.getMethodForObject(stcCtx, "getInterfaceData", null);
            Object infData = m2.invoke(stcCtx, new Object[0]);
            Method m3 = WSMUtils.getMethodForObject(infData, "getOperationByJavaName", new Class[]{String.class});
            Object opMap = m3.invoke(infData, javaOpName);
            Method m4 = WSMUtils.getMethodForObject(opMap, "getProperty", new Class[]{String.class});
            namespace = (String)m4.invoke(opMap, "InputNamespace");
        }
        catch (Throwable e) {
            WSMUtils.getLogger().error("NWS6Formatter::getNamespace.Unable to getNamespace:" + e);
        }
        return StringUtils.isEmpty(namespace) ? "UnknownNamespace" : namespace;
    }

    private String getWSDLStyle(InvocationData data) {
        String style = null;
        try {
            Object configObj = this.getBindingConfig(data);
            Method method = WSMUtils.getMethodForObject(configObj, "getProperty", new Class[]{String.class});
            style = (String)method.invoke(configObj, kStyle);
        }
        catch (Exception e) {
            WSMUtils.getLogger().error("NWS6Formatter::getWSDLStyle.Unable to getWSDLStyle:" + e);
        }
        return style == null ? kDocument : style;
    }

    private String queryBindingConfig(InvocationData data, String name) {
        try {
            Object configObj = this.getBindingConfig(data);
            Method method = WSMUtils.getMethodForObject(configObj, "getSubContext", new Class[]{String.class});
            Object inputObj = method.invoke(configObj, kInput);
            method = WSMUtils.getMethodForObject(inputObj, "getProperty", new Class[]{String.class});
            if (name != null && name.equalsIgnoreCase(kOperationName)) {
                name = (String)method.invoke(inputObj, kOperationName);
            } else if (name != null && name.equalsIgnoreCase(kNamespace)) {
                name = (String)method.invoke(inputObj, kNamespace);
            }
        }
        catch (Exception e) {
            WSMUtils.getLogger().error("NWS6Formatter::queryBindingConfig.Unable to queryBindingConfig:" + e);
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getSOAPRequestMessage(InvocationData data) {
        ByteArrayOutputStream soapStream = null;
        String message = null;
        try {
            soapStream = new ByteArrayOutputStream();
            Object invObj = data.getInvocationParameterAsObject(0);
            Method method = WSMUtils.getMethodForObject(invObj, kWriteTo, new Class[]{OutputStream.class});
            method.invoke(invObj, soapStream);
            message = soapStream.toString();
        }
        catch (Exception e) {
            WSMUtils.getLogger().error("NWS6Formatter::getSOAPRequestMessage.Unable to getSOAPRequestMessage:" + e);
        }
        finally {
            try {
                soapStream.close();
            }
            catch (IOException iOException) {}
        }
        return message;
    }
}

