/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices.extension.agent.trace.nameformatter.weblogic;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.INameFormatter;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.powerpack.webservices.KConstants;
import com.wily.powerpack.webservices.WSMUtils;
import com.wily.util.StringUtils;
import java.lang.reflect.Method;
import java.util.Map;

public class SyncHandlerNameFormatter
implements INameFormatter,
KConstants {
    private final IAgent agent;
    public static final String kPropertyNamespace = "wily.jaxws.client.namespace";
    public static final String kPropertyOperation = "wily.jaxws.client.operationname";
    public static final String kPropertyEndpoint = "javax.xml.ws.service.endpoint.address";
    public static final String kPropertyWsdlServiceName = "wily.jaxws.client.wsdlservicename";
    public static final String kAsMapMethod = "asMap";
    public static final String kGetMapViewMethod = "getMapView";
    private static volatile boolean fUseAsMapMethod = false;
    private static volatile boolean fCheckedForAsMapMethodPresence = false;

    public SyncHandlerNameFormatter(IAgent agent) {
        this.agent = agent;
        WSMUtils.getLogger().info("SyncHandlerFormatter::loaded");
    }

    public String INameFormatter_format(String name, InvocationData data) {
        boolean isDebugEnabled = WSMUtils.getLogger().isDebugEnabled();
        if (name == null) {
            if (isDebugEnabled) {
                WSMUtils.getLogger().debug("INVALID name to format.NULL");
            }
            return null;
        }
        String operationName = null;
        String serviceName = null;
        String namespace = null;
        String wsdlServiceName = null;
        try {
            Object mapViewRc = null;
            if (isDebugEnabled) {
                WSMUtils.getLogger().debug("SyncHandlerNameFormatter::invObj:" + data.getInvocationObject().getClass().getName());
                WSMUtils.getLogger().debug("SyncHandlerNameFormatter::invObj details:" + data.getInvocationParameterCount() + " " + data.getInvocationParameterAsObject(2).getClass().getName());
            }
            Object objRequestContext = data.getInvocationParameterAsObject(2);
            if (!fCheckedForAsMapMethodPresence && !fUseAsMapMethod) {
                block25: {
                    if (isDebugEnabled) {
                        WSMUtils.getLogger().debug("looking for method asMap in RequestContext");
                    }
                    try {
                        Method methodDesc = WSMUtils.getMethodForObject(objRequestContext, kAsMapMethod, new Class[0]);
                        if (methodDesc != null) {
                            fUseAsMapMethod = true;
                        }
                    }
                    catch (Exception e) {
                        if (!isDebugEnabled) break block25;
                        WSMUtils.getLogger().debug("SyncHandlerNameFormatter::invObj: exception finding asMap" + e);
                    }
                }
                if (isDebugEnabled) {
                    WSMUtils.getLogger().debug("method asMap was " + (fUseAsMapMethod ? "not" : "") + " found in RequestContext object class");
                }
                fCheckedForAsMapMethodPresence = true;
            }
            if ((mapViewRc = fUseAsMapMethod ? WSMUtils.invokeMethodOnObject(objRequestContext, kAsMapMethod) : WSMUtils.invokeMethodOnObject(objRequestContext, kGetMapViewMethod)) == null) {
                this.agent.IAgent_getModuleFeedback().error("SyncHandlerNameFormatter - no map available");
                return null;
            }
            Map mapRequestContext = (Map)mapViewRc;
            if (name.indexOf("{servicename}", 0) >= 0) {
                serviceName = (String)mapRequestContext.get(kPropertyEndpoint);
                if (serviceName == null) {
                    serviceName = "UnknownService";
                }
                serviceName = WSMUtils.formatToBeResourceSafe(serviceName);
                data.put("com.wily.powerpack.webservices.trace.NamespaceKey", (Object)serviceName);
                if (isDebugEnabled) {
                    WSMUtils.getLogger().debug("SyncHandlerNameFormatter::serviceName:" + serviceName);
                }
                name = StringUtils.replace((String)name, (String)"{servicename}", (String)serviceName);
            }
            if (name.indexOf("{wsdlservicename}", 0) >= 0) {
                wsdlServiceName = (String)mapRequestContext.get(kPropertyWsdlServiceName);
                if (wsdlServiceName == null) {
                    wsdlServiceName = "UnknownService";
                }
                wsdlServiceName = WSMUtils.formatToBeResourceSafe(wsdlServiceName);
                data.put("com.wily.powerpack.webservices.trace.NamespaceKey", (Object)wsdlServiceName);
                if (isDebugEnabled) {
                    WSMUtils.getLogger().debug("SyncHandlerNameFormatter::wsdlServiceName:" + wsdlServiceName);
                }
                name = StringUtils.replace((String)name, (String)"{wsdlservicename}", (String)wsdlServiceName);
            }
            if (name.indexOf("{namespace}", 0) >= 0) {
                namespace = (String)mapRequestContext.get(kPropertyNamespace);
                if (namespace == null) {
                    namespace = (String)mapRequestContext.get(kPropertyEndpoint);
                }
                if (namespace == null) {
                    namespace = "UnknownNamespace";
                }
                namespace = WSMUtils.formatToBeResourceSafe(namespace);
                data.put("com.wily.powerpack.webservices.trace.NamespaceKey", (Object)namespace);
                if (isDebugEnabled) {
                    WSMUtils.getLogger().debug("SyncHandlerNameFormatter::NameSpace:" + namespace);
                }
                name = StringUtils.replace((String)name, (String)"{namespace}", (String)namespace);
            }
            if (name.indexOf("{operationname}", 0) >= 0) {
                operationName = (String)mapRequestContext.get(kPropertyOperation);
                if (operationName == null) {
                    operationName = "UnknownOperationName";
                }
                operationName = WSMUtils.formatToBeResourceSafe(operationName);
                data.put("com.wily.powerpack.webservices.trace.OperationNameKey", (Object)operationName);
                name = StringUtils.replace((String)name, (String)"{operationname}", (String)operationName);
            }
        }
        catch (Exception e) {
            this.agent.IAgent_getModuleFeedback().error((Throwable)e);
        }
        if (isDebugEnabled) {
            WSMUtils.getLogger().debug("SyncHandlerFormatter::ended");
        }
        return name;
    }
}

