/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices.extension.agent.trace.soap;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.blame.ComponentTracer;
import com.wily.introscope.agent.trace.ASingleInstanceTracerFactory;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.powerpack.webservices.WSMUtils;
import com.wily.powerpack.webservices.extension.agent.trace.soap.WSDMEventCache;
import com.wily.util.properties.AttributeListing;

public class HandlerImplTracer
extends ASingleInstanceTracerFactory {
    public static final String kWSDM_REQUEST_SOAP = "WSDM_Request_SOAP";
    public static final String kWSDM_RESPONSE_SOAP = "WSDM_Response_SOAP";
    public static final String kWSTargetNSParameterKey = "WebService";
    public static final String kWSOperationParameterKey = "Operation";
    public static final String kstTracerName = "HandlerImplTracer";
    private ReentrancyLevel fReEntryLeveL = this.calculateReentrancyLevel(ReentrancyLevel.kNone);

    public HandlerImplTracer(IAgent agent, AttributeListing attributeListing, ProbeIdentification probeIdentification, Object sample) {
        super(agent, attributeListing, probeIdentification, sample);
    }

    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        HandlerImplTracer.handleDebug("HandlerImplTracer:startTrace", null);
        boolean bTTSoapFlag = false;
        boolean bERSoapFlag = false;
        boolean bTTSoapFlagAdded = WSDMEventCache.getTTSOAPMessageAddEvent();
        boolean bERSoapFlagAdded = WSDMEventCache.getERSOAPMessageAddEvent();
        if (!bTTSoapFlagAdded) {
            bTTSoapFlag = WSDMEventCache.getTransactionTraceEvent();
        }
        if (!bERSoapFlagAdded) {
            bERSoapFlag = WSDMEventCache.getErrorSnapshotEvent();
        }
        if (bTTSoapFlag && !bERSoapFlag) {
            this.addSOAPMessage(data, "Normal");
            WSDMEventCache.setTTSOAPHeaderAddEvent();
        }
        if (bERSoapFlag) {
            this.addSOAPMessage(data, "ErrorSnapshot");
            WSDMEventCache.setERSOAPHeaderAddEvent();
        }
    }

    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
    }

    public ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return this.fReEntryLeveL;
    }

    public boolean ITracerFactory_isShutoff() {
        return false;
    }

    private void addSOAPMessage(InvocationData data, String type) {
        try {
            Object serviceRequestInfo = HandlerImplTracer.getParameter(data, 0);
            Object transactionInfo = WSMUtils.invokeMethodOnObject(serviceRequestInfo, "getTransactionInfo");
            String operationNS = (String)WSMUtils.invokeMethodOnObject(serviceRequestInfo, "getOperationNameSpace");
            String operation = (String)WSMUtils.invokeMethodOnObject(serviceRequestInfo, "getOperationName");
            String requestSoap = (String)WSMUtils.invokeMethodOnObject(transactionInfo, "getRequest");
            String responseSoap = (String)WSMUtils.invokeMethodOnObject(transactionInfo, "getResponse");
            ComponentTracer objTracer = this.getComponentTracer();
            objTracer.addExtraParameter("Trace Type", type);
            objTracer.addExtraParameter(kWSTargetNSParameterKey, operationNS);
            objTracer.addExtraParameter(kWSOperationParameterKey, operation);
            objTracer.addExtraParameter(kWSDM_REQUEST_SOAP, requestSoap);
            objTracer.addExtraParameter(kWSDM_RESPONSE_SOAP, responseSoap);
            HandlerImplTracer.handleDebug("In Add NonSOAP:" + objTracer, null);
            HandlerImplTracer.handleDebug("operationNS" + operationNS + "/" + operation, null);
            HandlerImplTracer.handleDebug("requestSoap:" + requestSoap + "\nresponseSoap:" + responseSoap, null);
            HandlerImplTracer.handleDebug("End Adding soapmessage", null);
        }
        catch (Exception e) {
            HandlerImplTracer.handleError("HandleImplTracer: SOA trace problem: " + e, e);
        }
    }

    public static final Object getParameter(InvocationData data, int paramPos) {
        if (!data.hasInvocationParametersAvailable()) {
            HandlerImplTracer.handleError("Error: HandlerImplTracer: no parameters available.  Have you used the right tracer?", null);
            return null;
        }
        if (data.getInvocationParameterCount() <= paramPos) {
            HandlerImplTracer.handleError("Error: HandlerImplTracer: there aren't that many parameters", null);
            return null;
        }
        Object result = data.getInvocationParameterAsObject(paramPos);
        if (result == null) {
            HandlerImplTracer.handleError("Error: HandlerImplTracer: param " + paramPos + " is null", null);
            return null;
        }
        return result;
    }

    private static void handleDebug(String msg, Throwable t) {
        WSMUtils.getLogger().debug(msg, t);
    }

    private static void handleError(String msg, Throwable t) {
        WSMUtils.getLogger().error(msg, t);
    }
}

