/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices.extension.agent.trace.substituteresult.netweaver;

import com.sap.engine.interfaces.webservices.runtime.Config;
import com.sap.engine.interfaces.webservices.runtime.component.ProtocolFactory;
import com.sap.engine.services.webservices.runtime.component.ProtocolFactoryRegistry;
import com.sap.engine.services.webservices.runtime.definition.ConfigImpl;
import com.sap.engine.services.webservices.runtime.definition.FeatureInfo;
import com.sap.engine.services.webservices.runtime.definition.PropertyDescriptorInterfaceImpl;
import com.sap.engine.services.webservices.server.WSContainer;
import com.wily.powerpack.webservices.WSMUtils;
import com.wily.powerpack.webservices.extension.agent.WSDMHandlerInstantiationException;
import com.wily.powerpack.webservices.handlers.netweaver.server.WSDMProtocolFactory;
import java.util.Enumeration;
import java.util.Hashtable;

public class NTW6ModifyHandler {
    public static FeatureInfo getWsdmFeature() {
        return FeatureHolder.wsdmFeature;
    }

    public static FeatureInfo[] modifyFeaturesList(FeatureInfo[] globalFeatures) {
        WSMUtils.refreshLogLevels();
        FeatureInfo[] newGlobalFeatures = globalFeatures;
        try {
            String message = Thread.currentThread() + " Getting global handler";
            WSMUtils.getLogger().debug(message);
            FeatureInfo wsdmFeature = NTW6ModifyHandler.getWsdmFeature();
            if (wsdmFeature != null) {
                newGlobalFeatures = NTW6ModifyHandler.appendWSDMHandler(globalFeatures, wsdmFeature);
            }
        }
        catch (ThreadDeath bomb) {
            return globalFeatures;
        }
        return newGlobalFeatures;
    }

    private static FeatureInfo[] appendWSDMHandler(FeatureInfo[] globalFeatures, FeatureInfo WSDMFeature) {
        WSMUtils.getLogger().debug("Server Protocol appendWSMDHandler..");
        String message = Thread.currentThread() + " [::appendWSDMHandler]  Appending WSDM handler to Global Features chain, size=actual global features " + globalFeatures.length;
        WSMUtils.getLogger().trace(WSMUtils.getModule(), message);
        FeatureInfo[] modifiedFeatures = null;
        FeatureInfo[] actualFeatures = globalFeatures;
        try {
            if (!NTW6ModifyHandler.checkForDuplicates(actualFeatures) && actualFeatures != null && actualFeatures.length >= 0) {
                int nSize = actualFeatures.length;
                modifiedFeatures = new FeatureInfo[nSize + 1];
                if (nSize > 0) {
                    System.arraycopy(actualFeatures, 0, modifiedFeatures, 0, nSize);
                }
                modifiedFeatures[nSize] = WSDMFeature;
                NTW6ModifyHandler.printFeatures(modifiedFeatures);
            }
        }
        catch (Exception e) {
            return actualFeatures;
        }
        return modifiedFeatures;
    }

    private static void printFeatures(FeatureInfo[] modifiedFeatures) {
        if (WSMUtils.getLogger().isDebugEnabled()) {
            WSMUtils.getLogger().debug("Start Printing server side feature");
            for (int i = 0; i < modifiedFeatures.length; ++i) {
                FeatureInfo debugFeature = modifiedFeatures[i];
                if (debugFeature != null) {
                    WSMUtils.getLogger().debug("Protocol:" + debugFeature.getProtocolID());
                    WSMUtils.getLogger().debug("FeatureName:" + debugFeature.getFeatureName());
                    continue;
                }
                WSMUtils.getLogger().debug("Debug Featureis NULL");
            }
            WSMUtils.getLogger().debug("End Start Printing server side feature");
        }
    }

    public static FeatureInfo getWSDMHandler(Hashtable config) throws WSDMHandlerInstantiationException {
        FeatureInfo wsdmFeature = null;
        ConfigImpl cfg = null;
        try {
            wsdmFeature = new FeatureInfo();
            wsdmFeature.setName("http://www.ca.com/wsdmfeature");
            wsdmFeature.setProtocol("WSDMProtocol");
            config = NTW6ModifyHandler.updateConfigValueTypes(config);
            cfg = new ConfigImpl();
            cfg.addProperties(config);
            wsdmFeature.setConfiguration((Config)cfg);
        }
        catch (ThreadDeath bomb) {
            throw bomb;
        }
        catch (Throwable bomb) {
            throw new WSDMHandlerInstantiationException(bomb);
        }
        return wsdmFeature;
    }

    public static boolean checkForDuplicates(FeatureInfo[] featureInfo) {
        boolean isWSDMProtocolFound = false;
        if (featureInfo == null || featureInfo.length == 0) {
            isWSDMProtocolFound = false;
        } else {
            for (int i = 0; i < featureInfo.length; ++i) {
                String protocolName = featureInfo[i].getProtocolID();
                if (protocolName != null && protocolName.equalsIgnoreCase("WSDMProtocol")) {
                    isWSDMProtocolFound = true;
                    break;
                }
                isWSDMProtocolFound = false;
            }
        }
        return isWSDMProtocolFound;
    }

    private static Hashtable updateConfigValueTypes(Hashtable config) {
        Hashtable<String, PropertyDescriptorInterfaceImpl> updatedConfig = new Hashtable<String, PropertyDescriptorInterfaceImpl>();
        String key = null;
        Enumeration keys = config.keys();
        while (keys.hasMoreElements()) {
            key = (String)keys.nextElement();
            updatedConfig.put(key, new PropertyDescriptorInterfaceImpl(key, (String)config.get(key)));
        }
        return updatedConfig;
    }

    private static class FeatureHolder {
        public static FeatureInfo wsdmFeature = null;

        private FeatureHolder() {
        }

        private static void onError(Exception e) {
            String message = Thread.currentThread() + " Caught unexpected exception while modifying client handlers " + e;
            WSMUtils.getLogger().error(message);
        }

        static {
            try {
                ProtocolFactoryRegistry protocolFactoryRegistry = WSContainer.getProtocolFactoryRegistry();
                protocolFactoryRegistry.registerProtocolFactory("WSDMProtocol", (ProtocolFactory)new WSDMProtocolFactory(WSContainer.getServiceContext()));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            try {
                wsdmFeature = NTW6ModifyHandler.getWSDMHandler(WSMUtils.getWSDMHandlerConfig("1"));
            }
            catch (WSDMHandlerInstantiationException e) {
                FeatureHolder.onError((Exception)((Object)e));
            }
        }
    }
}

