/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices.extension.agent.trace.substituteresult.weblogic;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.powerpack.webservices.WSMUtils;
import com.wily.powerpack.webservices.extension.agent.WSDMHandlerInstantiationException;
import com.wily.powerpack.webservices.handlers.weblogic9.WsdmWebLogic90Handler;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.xml.rpc.handler.HandlerInfo;
import weblogic.wsee.handler.HandlerException;
import weblogic.wsee.handler.HandlerListImpl;
import weblogic.wsee.handler.JaxrpcHandlerChain;
import weblogic.wsee.monitoring.HandlerStats;
import weblogic.wsee.ws.dispatch.server.JaxrpcChainHandler;

public class WLS103ModifyHandler {
    private static ThreadLocal Cache = new ThreadLocal(){

        protected synchronized Object initialValue() {
            return new HashMap();
        }
    };
    private static final HandlerStats kEmptyHandlerStats = new WLS9EmptyHandlerStats();

    public static HandlerInfo getClientHandler() {
        return ClientHandlerHolder.wsdmHandler;
    }

    public static HandlerInfo getServerHandler() {
        return ServerHandlerHolder.wsdmHandler;
    }

    public static void set(Object key, Object value) {
        WLS103ModifyHandler.get().put(key, value);
        WSMUtils.getLogger().debug("Set value in threadlocal cache:" + WLS103ModifyHandler.get().size() + WLS103ModifyHandler.get());
    }

    public static Object get(Object key) {
        WSMUtils.getLogger().debug("Get value in threadlocal cache:" + WLS103ModifyHandler.get().size() + WLS103ModifyHandler.get());
        return WLS103ModifyHandler.get().get(key);
    }

    private static Map get() {
        return (Map)Cache.get();
    }

    public static void clear() {
        WLS103ModifyHandler.get().clear();
    }

    public static HandlerInfo getWSDMHandler(Hashtable config) {
        HandlerInfo WSDMHandler = null;
        try {
            HandlerListImpl handlers = new HandlerListImpl();
            handlers.add("WSDM Weblogic 9 Handler", new HandlerInfo(WsdmWebLogic90Handler.class, (Map)config, null));
            JaxrpcHandlerChain handlerChain = new JaxrpcHandlerChain(handlers);
            handlerChain.init();
            config.put("weblogic.wsee.handler.jaxrpcHandlerChain", handlerChain);
            config.put("weblogic.wsee.handler.jaxrpcHandlerChainPoolSize", "0");
            WSDMHandler = new HandlerInfo(JaxrpcChainHandler.class, (Map)config, null);
        }
        catch (ThreadDeath bomb) {
            throw bomb;
        }
        catch (Throwable bomb) {
            WSMUtils.getLogger().error("getWSDMHandler " + WSMUtils.dumpStackTrace(bomb));
        }
        return WSDMHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HandlerListImpl modifyHandlerList(HandlerListImpl handlers) {
        HandlerListImpl newHandlers = handlers;
        WSMUtils.refreshLogLevels();
        try {
            WSMUtils.getLogger().debug("WLS103ModifyHandler modifyHandlerList");
            String dispatcherType = (String)WLS103ModifyHandler.get("com.wily.powerpack.webservices.WLS103Dispatcher");
            WSMUtils.getLogger().debug("WLS103ModifyHandler:: cache size" + WLS103ModifyHandler.get().size());
            WSMUtils.getLogger().debug("WLS103ModifyHandler:: dispatcherType: " + dispatcherType);
            if (dispatcherType != null) {
                if (dispatcherType.equals("weblogic.wsee.ws.dispatch.server.ServerDispatcher")) {
                    WSMUtils.getLogger().debug("WLS103ModifyHandler modifyHandlerList ServerDispatcher");
                    newHandlers = WLS103ModifyHandler.getServerHandlerList(handlers);
                } else if (dispatcherType.equals("weblogic.wsee.ws.dispatch.client.ClientDispatcher")) {
                    WSMUtils.getLogger().debug("WLS103ModifyHandler modifyHandlerList ClientDispatcher");
                    newHandlers = WLS103ModifyHandler.getClientHandlerList(handlers);
                } else {
                    WSMUtils.getLogger().debug("Detected unsupported Weblogic103 dispatcher");
                }
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable th) {
            try {
                WSMUtils.getLogger().error("WLS103ModifyHandler modifyHandlerList error:" + WSMUtils.dumpStackTrace(th));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            newHandlers = handlers;
        }
        finally {
            try {
                WLS103ModifyHandler.clear();
            }
            catch (Throwable throwable) {}
        }
        return newHandlers;
    }

    private static int getServerInsertPoint(HandlerListImpl handlers) {
        int insertPoint = WLS103ModifyHandler.findHandler("JAX_RPC_CHAIN_HANDLER", handlers);
        if (insertPoint == -1) {
            insertPoint = WLS103ModifyHandler.findHandler("CODEC_HANDLER", handlers);
            if (insertPoint == -1) {
                insertPoint = Math.max(0, handlers.size() - 1);
            }
        } else {
            ++insertPoint;
        }
        return insertPoint;
    }

    protected static HandlerListImpl appendWSDMHandler(HandlerListImpl handlers, HandlerInfo WSDMHandler) throws WSDMHandlerInstantiationException {
        WSMUtils.getLogger().debug("WLS103ModifyHandler: Appending WSDM handler to handler chain");
        if (handlers != null && !handlers.contains("WSDM Server Observer Handler")) {
            int insertPoint = WLS103ModifyHandler.getServerInsertPoint(handlers);
            try {
                handlers.insert("WSDM Server Observer Handler", insertPoint, WSDMHandler);
            }
            catch (HandlerException bomb) {
                throw new WSDMHandlerInstantiationException(bomb);
            }
            try {
                if (handlers.getStats(insertPoint) != null) {
                    handlers.insert(insertPoint, kEmptyHandlerStats);
                }
            }
            catch (Throwable bomb) {
                try {
                    handlers.remove(insertPoint);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw new WSDMHandlerInstantiationException(bomb);
            }
        }
        return handlers;
    }

    private static HandlerListImpl getServerHandlerList(HandlerListImpl handlers) throws AgentNotAvailableException, WSDMHandlerInstantiationException {
        HandlerInfo wsdmHandler = WLS103ModifyHandler.getServerHandler();
        return WLS103ModifyHandler.appendWSDMHandler(handlers, wsdmHandler);
    }

    private static int getClientInsertPoint(HandlerListImpl handlers) {
        int insertPoint = WLS103ModifyHandler.findHandler("JAX_RPC_CHAIN_HANDLER", handlers);
        if (insertPoint == -1) {
            insertPoint = WLS103ModifyHandler.findHandler("ADDRESSING_HANDLER", handlers) + 1;
        }
        return insertPoint;
    }

    protected static HandlerListImpl prependWSDMHandler(HandlerListImpl handlers, HandlerInfo WSDMHandler) throws WSDMHandlerInstantiationException {
        WSMUtils.getLogger().debug("WLS9ModifyHander::prependWSDMHandler");
        if (handlers != null && !handlers.contains("WSDM Client Observer Handler")) {
            int insertPoint = WLS103ModifyHandler.getClientInsertPoint(handlers);
            try {
                handlers.insert("WSDM Client Observer Handler", insertPoint, WSDMHandler);
            }
            catch (HandlerException bomb) {
                throw new WSDMHandlerInstantiationException(bomb);
            }
            try {
                if (handlers.getStats(insertPoint) != null) {
                    handlers.insert(insertPoint, kEmptyHandlerStats);
                }
            }
            catch (Throwable bomb) {
                try {
                    handlers.remove(insertPoint);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw new WSDMHandlerInstantiationException(bomb);
            }
        }
        return handlers;
    }

    private static HandlerListImpl getClientHandlerList(HandlerListImpl handlers) throws AgentNotAvailableException, WSDMHandlerInstantiationException {
        HandlerInfo wsdmHandler = WLS103ModifyHandler.getClientHandler();
        return WLS103ModifyHandler.prependWSDMHandler(handlers, wsdmHandler);
    }

    protected static int findHandler(String handlerName, HandlerListImpl handlers) {
        int pos = -1;
        for (int iter = 0; iter < handlers.size() && pos < 0; ++iter) {
            if (!handlers.getName(iter).equals(handlerName)) continue;
            pos = iter;
        }
        return pos;
    }

    private static class WLS9EmptyHandlerStats
    implements HandlerStats {
        private WLS9EmptyHandlerStats() {
        }

        public void reportInitError(Throwable throwable) {
        }

        public void reportRequestTermination() {
        }

        public void reportRequestError(Throwable throwable) {
        }

        public void reportResponseTermination() {
        }

        public void reportResponseError(Throwable throwable) {
        }
    }

    private static class ServerHandlerHolder {
        public static HandlerInfo wsdmHandler = null;

        private ServerHandlerHolder() {
        }

        static {
            wsdmHandler = WLS103ModifyHandler.getWSDMHandler(WSMUtils.getWSDMHandlerConfig("1"));
        }
    }

    private static class ClientHandlerHolder {
        public static HandlerInfo wsdmHandler = null;

        private ClientHandlerHolder() {
        }

        static {
            wsdmHandler = WLS103ModifyHandler.getWSDMHandler(WSMUtils.getWSDMHandlerConfig("2"));
        }
    }
}

