/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices.extension.agent.trace.substituteresult.weblogic;

import com.wily.powerpack.webservices.WSMUtils;
import com.wily.powerpack.webservices.extension.agent.WSDMHandlerInstantiationException;
import com.wily.powerpack.webservices.handlers.weblogic8.WsdmWebLogicHandler;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.xml.rpc.handler.HandlerInfo;

public class WLS8ModifyHandler {
    private static final String kWLS8ClientHandlerInfos = "com.wily.powerpack.webservices.WLS8ClientHandlerInfos";
    private static final String kWLS8ServerHandlerInfos = "com.wily.powerpack.webservices.WLS8ServerHandlerInfos";

    public static HandlerInfo getClientWsdmHandler() {
        return ClientHandlerHolder.wsdmHandler;
    }

    public static HandlerInfo getServerWsdmHandler() {
        return ServerHandlerHolder.wsdmHandler;
    }

    public static List modifyOutboundGlobalHandler(List handlerInfos) {
        List newHandlerInfos;
        block6: {
            newHandlerInfos = handlerInfos;
            WSMUtils.refreshLogLevels();
            try {
                String message = Thread.currentThread() + " [" + WLS8ModifyHandler.class + "::modifyOutboundGlobalHandler] Modifying CLIENT global handler";
                WSMUtils.getLogger().trace(WSMUtils.getModule(), message);
                message = Thread.currentThread() + " Getting CLIENT global handler";
                WSMUtils.getLogger().debug(message);
                HandlerInfo wsdmHandler = WLS8ModifyHandler.getClientWsdmHandler();
                if (wsdmHandler == null) break block6;
                boolean prop = WSMUtils.prependClientHandlerEnabled();
                newHandlerInfos = prop ? WLS8ModifyHandler.prependWSDMHandler(handlerInfos, wsdmHandler) : WLS8ModifyHandler.appendWSDMHandler(handlerInfos, wsdmHandler);
            }
            catch (ThreadDeath bomb) {
                throw bomb;
            }
            catch (Throwable bomb) {
                try {
                    String message = Thread.currentThread() + " Caught unexpected exception while modifying CLIENT global handler, " + bomb + ", using configured CLIENT global handler";
                    WSMUtils.getLogger().error(message);
                }
                catch (Throwable message) {
                    // empty catch block
                }
                newHandlerInfos = handlerInfos;
                if (!WSMUtils.getLogger().isDebugEnabled()) break block6;
                WSMUtils.getLogger().debug("WLS8ModifyHandler: Clientside Handler Order");
                for (int iter = 0; iter < newHandlerInfos.size(); ++iter) {
                    WSMUtils.getLogger().debug("WLS8ModifyHandler  Handler(" + iter + "):" + ((HandlerInfo)newHandlerInfos.get(iter)).getHandlerClass().getName());
                }
            }
        }
        return newHandlerInfos;
    }

    public static List modifyInboundGlobalHandler(List handlerInfos) {
        List newHandlerInfos = handlerInfos;
        WSMUtils.refreshLogLevels();
        try {
            String message = Thread.currentThread() + " [" + WLS8ModifyHandler.class + "::modifyInboundGlobalHandler] Modifying SERVER global handler";
            WSMUtils.getLogger().trace(WSMUtils.getModule(), message);
            message = Thread.currentThread() + " Getting SERVER handler";
            WSMUtils.getLogger().debug(message);
            HandlerInfo wsdmHandler = WLS8ModifyHandler.getServerWsdmHandler();
            if (wsdmHandler != null) {
                boolean prop = WSMUtils.appendServerHandlerEnabled();
                newHandlerInfos = prop ? WLS8ModifyHandler.appendWSDMHandler(handlerInfos, wsdmHandler) : WLS8ModifyHandler.prependWSDMHandler(handlerInfos, wsdmHandler);
            }
        }
        catch (ThreadDeath bomb) {
            throw bomb;
        }
        catch (Throwable bomb) {
            try {
                String message = Thread.currentThread() + " Caught unexpected exception while modifying SERVER handler, " + bomb + ", using configured SERVER handler";
                WSMUtils.getLogger().error(message.toString());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            newHandlerInfos = handlerInfos;
        }
        if (WSMUtils.getLogger().isDebugEnabled()) {
            WSMUtils.getLogger().debug("WLS8ModifyHandler: Serverside Handler Order");
            for (int iter = 0; iter < newHandlerInfos.size(); ++iter) {
                WSMUtils.getLogger().debug("WLS8ModifyHandler  Handler(" + iter + "):" + ((HandlerInfo)newHandlerInfos.get(iter)).getHandlerClass().getName());
            }
        }
        return newHandlerInfos;
    }

    private static List prependWSDMHandler(List handlers, HandlerInfo WSDMHandler) throws WSDMHandlerInstantiationException {
        String message = Thread.currentThread() + " [::prependWSDMHandler]  Prepending WSDM handler to handler chain, size=" + (handlers == null ? "null" : Integer.toString(handlers.size()));
        WSMUtils.getLogger().trace(WSMUtils.getModule(), message);
        ArrayList<HandlerInfo> newHandlers = new ArrayList<HandlerInfo>();
        newHandlers.add(WSDMHandler);
        if (handlers != null) {
            newHandlers.addAll(handlers);
        }
        return newHandlers;
    }

    private static List appendWSDMHandler(List handlers, HandlerInfo WSDMHandler) throws WSDMHandlerInstantiationException {
        String message = Thread.currentThread() + " [::appendWSDMHandler]  Appending WSDM handler to handler chain, size=" + (handlers == null ? "null" : Integer.toString(handlers.size()));
        WSMUtils.getLogger().trace(WSMUtils.getModule(), message);
        ArrayList<HandlerInfo> newHandlers = new ArrayList<HandlerInfo>();
        if (handlers != null) {
            newHandlers.addAll(handlers);
        }
        newHandlers.add(WSDMHandler);
        return newHandlers;
    }

    private static HandlerInfo getWSDMHandler(Hashtable config) throws WSDMHandlerInstantiationException {
        HandlerInfo WSDMHandler;
        try {
            WSDMHandler = new HandlerInfo(WsdmWebLogicHandler.class, (Map)config, null);
        }
        catch (ThreadDeath bomb) {
            throw bomb;
        }
        catch (Throwable bomb) {
            throw new WSDMHandlerInstantiationException(bomb);
        }
        return WSDMHandler;
    }

    private static class ServerHandlerHolder {
        public static HandlerInfo wsdmHandler = null;

        private ServerHandlerHolder() {
        }

        private static void onError(Exception e) {
            String message = Thread.currentThread() + " Caught unexpected exception while creating SOA handlers";
            WSMUtils.getLogger().error(message.toString());
        }

        static {
            try {
                wsdmHandler = WLS8ModifyHandler.getWSDMHandler(WSMUtils.getWSDMHandlerConfig("1"));
            }
            catch (WSDMHandlerInstantiationException e) {
                ServerHandlerHolder.onError((Exception)((Object)e));
            }
        }
    }

    private static class ClientHandlerHolder {
        public static HandlerInfo wsdmHandler = null;

        private ClientHandlerHolder() {
        }

        private static void onError(Exception e) {
            String message = Thread.currentThread() + " Caught unexpected exception while creating SOA handlers";
            WSMUtils.getLogger().error(message.toString());
        }

        static {
            try {
                wsdmHandler = WLS8ModifyHandler.getWSDMHandler(WSMUtils.getWSDMHandlerConfig("2"));
            }
            catch (WSDMHandlerInstantiationException e) {
                ClientHandlerHolder.onError((Exception)((Object)e));
            }
        }
    }
}

