/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices.formatter.producer;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.powerpack.webservices.WSMUtils;
import com.wily.powerpack.webservices.formatter.producer.AFormatter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class WAS5Formatter
extends AFormatter {
    public WAS5Formatter(IAgent agent) {
        super(agent);
    }

    @Override
    public String getServiceName(InvocationData data) {
        String name = null;
        try {
            String serviceName = null;
            Object o = data.getInvocationParameterAsObject(0);
            Class<?> cl = o.getClass();
            Method getProperty = WSMUtils.findGetPropertyWithStringArgMethod(cl);
            Object servicePath = getProperty.invoke(o, "path");
            if (servicePath != null) {
                serviceName = WSMUtils.toString(servicePath);
            } else {
                Object opdes = WSMUtils.invokeMethodOnObject(o, "getOperation");
                Object portDesc = WSMUtils.invokeMethodOnObject(opdes, "getParent");
                serviceName = (String)WSMUtils.invokeMethodOnObject(portDesc, "getName");
            }
            name = WSMUtils.formatURLToBeResourceSafe(serviceName);
        }
        catch (Throwable t) {
            WSMUtils.handleError(this.getAgent(), "WebServices_Error_Determining_Service_Name", t);
        }
        return name == null ? "UnknownService" : name;
    }

    protected Object getOperationDesc(InvocationData data) throws NoSuchMethodException, NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Object context = this.getMessageContext(data);
        Object operation = WSMUtils.invokeMethodOnObject(context, "getOperation");
        if (operation == null) {
            Object soapEnvelope = data.getInvocationParameterAsObject(1);
            Object body = WSMUtils.invokeMethodOnObject(soapEnvelope, "getBody");
            Object reqRes = WSMUtils.invokeMethodOnObject(body, "getRequestResponse");
            operation = WSMUtils.invokeMethodOnObject(reqRes, "getOperation");
        }
        return operation;
    }

    @Override
    protected Object getMessageContext(InvocationData data) throws RuntimeException {
        Object context = data.getInvocationParameterAsObject(0);
        return context;
    }

    @Override
    public String getOperation(InvocationData data) {
        String name = null;
        try {
            Object operation = this.getOperationDesc(data);
            name = (String)WSMUtils.invokeMethodOnObject(operation, "getName");
        }
        catch (Throwable t) {
            WSMUtils.handleError(this.getAgent(), "WebServices_Error_Determining_Operation_Name", t);
        }
        return name == null ? "UnknownOperationName" : name;
    }
}

