/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices.handlers;

import com.wily.powerpack.webservices.WSMUtils;
import java.io.IOException;
import java.io.StringReader;
import java.util.Hashtable;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SimpleServiceDeserializer
extends DefaultHandler {
    private static ThreadLocal parserCache = new ThreadLocal(){

        protected synchronized Object initialValue() {
            SAXParser parser = null;
            try {
                SAXParserFactory spf = SAXParserFactory.newInstance();
                spf.setFeature("http://xml.org/sax/features/external-general-entities", false);
                spf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                parser = spf.newSAXParser();
            }
            catch (ParserConfigurationException pe) {
                WSMUtils.getLogger().error((Throwable)pe);
            }
            catch (SAXException se) {
                WSMUtils.getLogger().error((Throwable)se);
            }
            return parser;
        }
    };
    private boolean partialParsing;
    boolean doneParsing = false;
    boolean inBody = false;
    protected String inputString;
    private String serviceName = "";
    private String operationName = "";
    private String savedNs = "";
    private Hashtable savedDefines = null;

    public SimpleServiceDeserializer(String is) {
        this.inputString = is;
        this.partialParsing = this.inputString.length() > 1024;
    }

    @Override
    public void startDocument() {
    }

    @Override
    public void startElement(String uri, String name, String qName, Attributes atts) {
        if (!this.doneParsing) {
            String prefix = "";
            int idx = qName.indexOf(58);
            if (idx > 0) {
                prefix = qName.substring(0, idx);
            }
            this.operationName = qName.substring(idx + 1);
            if (this.savedDefines == null) {
                this.savedDefines = new Hashtable();
            }
            if (!this.operationName.equalsIgnoreCase("Body") && !this.operationName.equalsIgnoreCase("Envelope")) {
                this.savedNs = prefix;
                this.getDefinesFromAttr(atts);
                if (this.savedDefines != null && this.savedDefines.containsKey(this.savedNs)) {
                    this.serviceName = (String)this.savedDefines.get(this.savedNs);
                }
                this.doneParsing = true;
            } else {
                this.getDefinesFromAttr(atts);
            }
        } else if (this.partialParsing) {
            throw new RuntimeException("Done parsing");
        }
    }

    @Override
    public void characters(char[] text, int start, int length) {
    }

    @Override
    public void endElement(String uri, String name, String qName) {
    }

    @Override
    public void endDocument() {
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void parse() throws SAXException {
        if (this.inputString != null) {
            block4: {
                InputSource iSource = new InputSource(new StringReader(this.inputString));
                try {
                    SAXParser parser = (SAXParser)parserCache.get();
                    parser.parse(iSource, (DefaultHandler)this);
                }
                catch (IOException e) {
                    throw new SAXException(e);
                }
                catch (RuntimeException re) {
                    if ("Done parsing".equals(re.getMessage())) break block4;
                    throw re;
                }
            }
            Object var1_1 = null;
        }
        this.inputString = null;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getOperationName() {
        return this.operationName;
    }

    private void getDefinesFromAttr(Attributes atts) {
        if (atts != null) {
            if (this.savedDefines == null) {
                this.savedDefines = new Hashtable();
            }
            for (int i = 0; i < atts.getLength(); ++i) {
                String qn = atts.getQName(i);
                String key = "";
                String value = "";
                int ii = qn.indexOf("xmlns:");
                if (ii < 0) continue;
                key = qn.substring(ii + 6, qn.length());
                value = atts.getValue(atts.getQName(i));
                this.savedDefines.put(key, value);
            }
        }
    }
}

