/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices.handlers.netweaver.client;

import com.sap.engine.interfaces.webservices.esp.Message;
import com.sap.engine.interfaces.webservices.runtime.MessageException;
import com.sap.engine.interfaces.webservices.runtime.ProtocolException;
import com.sap.engine.lib.xml.parser.handlers.INamespaceHandler;
import com.sap.engine.lib.xml.parser.helpers.CharArray;
import com.sap.engine.lib.xml.parser.tokenizer.XMLTokenReaderImpl;
import com.sap.engine.services.webservices.espbase.client.bindings.ClientConfigurationContext;
import com.sap.engine.services.webservices.espbase.client.bindings.ClientServiceContext;
import com.sap.engine.services.webservices.espbase.mappings.OperationMapping;
import com.sap.engine.services.webservices.espbase.messaging.MIMEMessage;
import com.sap.engine.services.webservices.espbase.messaging.SOAPHeaderList;
import com.sap.engine.services.webservices.espbase.messaging.impl.SOAPMessageImpl;
import com.sap.engine.services.webservices.jaxrpc.handlers.JAXRPCHandlersEngine;
import com.wily.introscope.agent.transactiontrace.CorrelationId;
import com.wily.powerpack.webservices.WSMUtils;
import com.wily.powerpack.webservices.extension.agent.trace.nameformatter.WSNameCache;
import com.wily.powerpack.webservices.handlers.WsdmHandlerUtil;
import com.wily.powerpack.webservices.handlers.WsdmLogger;
import com.wily.powerpack.webservices.handlers.WsdmMessageContext;
import com.wily.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.soap.Detail;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class NW71JAXWSClientProtocol {
    public static final String CORRELATION_ID_NAME = "WSCorIDSOAPHeader";
    public static final String CORRELATION_NAMESPACE = "http://www.ca.com/apm";
    public static final String CORRELATION_ATTR_NAME = "CorID";
    public static final String CORRELATION_ID_KEY = "CorIDForSOAPInvocation";
    public static final String WSDM_CLIENT_PROTOCOL = "WSDMClientProtocol";
    public static final String WSDM_CLIENT_FEATURE = "http://www.ca.com/wsdmclientfeature";
    public static final String SAP_J2EESERVER_VER = "19";
    private static WsdmHandlerUtil wsdmHandlerUtil = null;
    private static final WsdmLogger log = new WsdmLogger();

    public static Object getInstanceMethod(Object rpe, Object appSrvCtx, Object appWSContext) {
        return new NW71JAXWSClientProtocol();
    }

    public void init() {
        this.initWsdmHandlerUtil();
    }

    private void initWsdmHandlerUtil() {
        wsdmHandlerUtil = WsdmHandlerUtil.getWsdmHandlerUtil();
    }

    private void processCorrelationId(int observationType, com.sap.engine.services.webservices.espbase.messaging.SOAPMessage soapmessage) {
        block5: {
            if (!WSMUtils.correlationEnabled()) {
                return;
            }
            try {
                CorrelationId corrId = new CorrelationId();
                corrId.incrementSequenceId();
                String correlationString = corrId.getCurrentOutgoingCorrelationIdStrippedForHeader();
                if (log.isDebugLogging().booleanValue()) {
                    log.debug("NW71JAXWSClientProtocol.processCorrelationId() correlationId:" + correlationString);
                }
                if (WSMUtils.correlationSOAPInsertionEnabled()) {
                    Element header = soapmessage.getSOAPHeaders().createHeader(new QName(CORRELATION_NAMESPACE, CORRELATION_ID_NAME));
                    Attr attr = header.getOwnerDocument().createAttribute(CORRELATION_ATTR_NAME);
                    attr.setValue(correlationString);
                    header.setAttributeNode(attr);
                    soapmessage.getSOAPHeaders().addHeader(header);
                }
            }
            catch (Throwable e) {
                log.error("NW71JAXWSClientProtocol::processCorrelationId.Unable to processCorrelationId:" + e);
                if (!log.isDebugLogging().booleanValue()) break block5;
                log.debug("NW71JAXWSClientProtocol::processCorrelationId.Unable to processCorrelationId:" + WSMUtils.dumpStackTrace(e));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getSOAPEnvelope(com.sap.engine.services.webservices.espbase.messaging.SOAPMessage soapmessage) {
        String soapEnvelope = null;
        ByteArrayOutputStream outputStream = null;
        try {
            outputStream = new ByteArrayOutputStream();
            soapmessage.writeTo((OutputStream)outputStream);
            soapEnvelope = ((Object)outputStream).toString();
        }
        catch (Throwable e) {
            log.error("NW71JAXWSClientProtocol::getSOAPEnvelope.Unable to getSOAPEnvelope:" + e);
            if (log.isDebugLogging().booleanValue()) {
                log.debug("NW71JAXWSClientProtocol::getSOAPEnvelope.Unable to getSOAPEnvelope:" + WSMUtils.dumpStackTrace(e));
            }
        }
        finally {
            block13: {
                try {
                    ((OutputStream)outputStream).close();
                }
                catch (Throwable e) {
                    log.error("WSDMClientProtocol::getSOAPEnvelope.Unable to close the stream:" + e);
                    if (!log.isDebugLogging().booleanValue()) break block13;
                    log.debug("Unable to close the stream" + WSMUtils.dumpStackTrace(e));
                }
            }
        }
        return soapEnvelope;
    }

    public int handleRequest(ClientConfigurationContext context) throws ProtocolException, MessageException {
        block5: {
            WsdmMessageContext wsdmMessageContext = null;
            try {
                ClientConfigurationContext ctx = context;
                String opName = ctx.getOperationName();
                ClientServiceContext svcCtx = ctx.getServiceContext();
                QName svcQName = svcCtx.getServiceName();
                String svcNameSpaceURI = svcQName.getNamespaceURI();
                String svcName = svcQName.getLocalPart();
                MIMEMessage soapMessage = (MIMEMessage)ctx.getMessage();
                OperationMapping opMapping = ctx.getStaticContext().getInterfaceData().getOperationByJavaName(ctx.getOperationName());
                String operationNamespace = opMapping.getProperty("InputNamespace");
                StringBuilder resp = new StringBuilder();
                SOAPHeaderList headerList = soapMessage.getSOAPHeaders();
                if (headerList != null) {
                    Element[] headers = headerList.getHeaders();
                    for (int i = 0; i < headers.length; ++i) {
                        Element headerElement = headers[i];
                        String headerName = headerElement.getLocalName();
                        resp.append(headerElement.toString());
                    }
                }
                String reqMsg = resp.toString();
                log.debug("NW71JAXWSClientProtocol.handleRequest():reqMsg:\n" + reqMsg);
                if (wsdmHandlerUtil == null) {
                    this.initWsdmHandlerUtil();
                }
                wsdmMessageContext = new WsdmMessageContext(2);
                wsdmMessageContext.setServiceName(svcNameSpaceURI + svcName);
                wsdmMessageContext.setPortName(svcNameSpaceURI);
                wsdmMessageContext.setRequestorLocation(InetAddress.getLocalHost().getHostAddress());
                wsdmMessageContext.setOperationName(opName);
                String operationNS = operationNamespace;
                operationNS = StringUtils.isEmpty((String)operationNS) ? svcNameSpaceURI : operationNS;
                wsdmMessageContext.setOperationNameSpace(operationNS);
                this.setNameCache(wsdmMessageContext.getOperationName(), wsdmMessageContext.getOperationNameSpace());
                this.processCorrelationId(2, (com.sap.engine.services.webservices.espbase.messaging.SOAPMessage)soapMessage);
                wsdmHandlerUtil.observeRequest(wsdmMessageContext);
                ctx.getDynamicContext().setProperty("WSDM_TRANSID", (Object)wsdmMessageContext);
            }
            catch (Throwable e) {
                WSMUtils.getLogger().debug("NW71JAXWSClientProtocol::handleRequest.Unable to handleRequest:" + e);
                log.error("NW71JAXWSClientProtocol::handleRequest.Unable to handleRequest:" + e);
                if (!log.isDebugLogging().booleanValue()) break block5;
                log.debug("NW71JAXWSClientProtocol::handleRequest.Unable to handleRequest:" + WSMUtils.dumpStackTrace(e));
            }
        }
        return 1;
    }

    public int handleResponse(ClientConfigurationContext context) throws ProtocolException {
        block4: {
            WsdmMessageContext wsdmMessageContext = null;
            Object respSOAPMessage = null;
            int correlationCount = new CorrelationId().decrementCorrelationCount();
            log.debug("WSDMClientProtocol handleResponse correlationCount=" + correlationCount);
            WSMUtils.getLogger().debug("NW71JAXWSClientProtocol::handleResponse");
            try {
                ClientConfigurationContext ctx = context;
                Message msg = ctx.getMessage();
                if (msg == null || !(msg instanceof MIMEMessage)) {
                    return 1;
                }
                MIMEMessage message = (MIMEMessage)msg;
                wsdmMessageContext = (WsdmMessageContext)ctx.getDynamicContext().getProperty("WSDM_TRANSID");
                if (wsdmMessageContext == null) {
                    return 1;
                }
                this.setNameCache(wsdmMessageContext.getOperationName(), wsdmMessageContext.getOperationNameSpace());
                wsdmHandlerUtil.observeResponse(wsdmMessageContext);
            }
            catch (Exception e) {
                log.error("NW71JAXWSClientProtocol::handleResponse.Unable to handleResponse:" + e);
                if (!log.isDebugLogging().booleanValue()) break block4;
                log.debug("NW71JAXWSClientProtocol::handleResponse.Unable to handleResponse:" + WSMUtils.dumpStackTrace(e));
            }
        }
        return 1;
    }

    public int handleFault(ClientConfigurationContext context) throws ProtocolException {
        block9: {
            WSMUtils.getLogger().debug("NW71JAXWSClientProtocol::handleFault");
            int correlationCount = new CorrelationId().decrementCorrelationCount();
            log.debug("WSDMClientProtocol wsdmHandleFault correlationCount=" + correlationCount);
            WsdmMessageContext wsdmMessageContext = null;
            MIMEMessage rawMessage = null;
            Object soapmessage = null;
            Object respSOAPMessage = null;
            String faultCode = null;
            String faultString = " ";
            try {
                ClientConfigurationContext ctx = context;
                wsdmMessageContext = (WsdmMessageContext)ctx.getDynamicContext().getProperty("WSDM_TRANSID");
                this.setNameCache(wsdmMessageContext.getOperationName(), wsdmMessageContext.getOperationNameSpace());
                rawMessage = (MIMEMessage)ctx.getMessage();
                if (rawMessage != null && rawMessage instanceof SOAPMessageImpl) {
                    SOAPMessageImpl msg = (SOAPMessageImpl)rawMessage;
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    msg.writeTo((OutputStream)baos);
                    wsdmMessageContext.setResponseMessage(baos.toString());
                    SOAPMessage resultMsg = JAXRPCHandlersEngine.createMessage();
                    if (msg.getSOAPHeaders().size() > 0) {
                        SOAPHeader sHeader = resultMsg.getSOAPHeader();
                        NW71JAXWSClientProtocol.initSOAPHeader(sHeader, msg.getSOAPHeaders());
                    }
                    SOAPBody soapBody = resultMsg.getSOAPBody();
                    XMLTokenReaderImpl reader = new XMLTokenReaderImpl((InputStream)new ByteArrayInputStream(baos.toByteArray(), 0, baos.size()));
                    reader.begin();
                    NW71JAXWSClientProtocol.addEnvelopePrefixesInReader(reader.getNamespaceHandler(), msg.getBuiltInEnvNamespaceMap());
                    if (reader.next() != 6) {
                        reader.getDOMRepresentation((Element)soapBody);
                    } else {
                        WSMUtils.getLogger().debug("NW71JAXWSClientProtocol::handleFault has error reading soap fault message");
                    }
                    SOAPBody body = resultMsg.getSOAPBody();
                    String[] sarr = new String[]{};
                    if (body.hasFault()) {
                        WSMUtils.getLogger().debug("NW71JAXWSClientProtocol::handleFault : has fault");
                        SOAPFault fault = resultMsg.getSOAPBody().getFault();
                        faultCode = fault.getFaultCode();
                        faultString = fault.getFaultString();
                        Detail detail = fault.getDetail();
                        Iterator ir = detail.getDetailEntries();
                        ArrayList<String> detailList = new ArrayList<String>();
                        while (ir.hasNext()) {
                            detailList.add(((Detail)ir.next()).getValue());
                        }
                        sarr = detailList.toArray(new String[0]);
                    }
                    WSMUtils.getLogger().debug("NW71JAXWSClientProtocol::calling WSDMHandlerUtil.spoolFault");
                    wsdmHandlerUtil.spoolFault(wsdmMessageContext, wsdmMessageContext.getOperationNameSpace(), faultCode, faultString, sarr);
                } else {
                    WSMUtils.getLogger().debug("NW71JAXWSClientProtocol::handleFault. Message is not SOAPMessageImpl!!!");
                }
            }
            catch (Exception e) {
                WSMUtils.getLogger().error("NW71JAXWSClientProtocol::handleFault.Unable to handleFault:" + WSMUtils.dumpStackTrace(e));
                log.error("NW71JAXWSClientProtocol::handleFault.Unable to handleFault:" + e);
                if (!log.isDebugLogging().booleanValue()) break block9;
                log.debug("NW71JAXWSClientProtocol::handleFault.Unable to handleFault:" + WSMUtils.dumpStackTrace(e));
            }
        }
        return 1;
    }

    public String getName() {
        return WSDM_CLIENT_PROTOCOL;
    }

    public String[] getFeatures() {
        return new String[]{WSDM_CLIENT_FEATURE};
    }

    public void setNameCache(String operationName, String namespace) {
        WSNameCache.setOperationName(operationName);
        WSNameCache.setNamespaceURI(namespace);
    }

    private static void addEnvelopePrefixesInReader(INamespaceHandler nsHandler, Map envMap) {
        for (String prefNS : envMap.keySet()) {
            String pref = (String)envMap.get(prefNS);
            nsHandler.add(new CharArray(pref), new CharArray(prefNS));
        }
    }

    private static void initSOAPHeader(SOAPHeader soapHeader, SOAPHeaderList hList) throws SOAPException {
        Element[] hElems = hList.getHeaders();
        for (int i = 0; i < hElems.length; ++i) {
            Element hEl = hElems[i];
            Element importedHEl = (Element)soapHeader.getOwnerDocument().importNode(hEl, true);
            soapHeader.appendChild((Node)importedHEl);
        }
    }
}

