/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices.handlers.netweaver.client;

import com.sap.engine.interfaces.webservices.client.ClientFeatureProvider;
import com.sap.engine.interfaces.webservices.runtime.ProtocolException;
import com.sap.engine.interfaces.webservices.runtime.component.ClientProtocolFactory;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.AbstractMessage;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.AbstractProtocol;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.ClientProtocolException;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.PropertyContext;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.soapbinding.ClientMimeMessage;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.soapbinding.ClientSOAPMessage;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.soapbinding.HTTPTransport;
import com.wily.introscope.agent.transactiontrace.CorrelationId;
import com.wily.powerpack.webservices.WSMUtils;
import com.wily.powerpack.webservices.extension.agent.trace.nameformatter.WSNameCache;
import com.wily.powerpack.webservices.handlers.WsdmHandlerUtil;
import com.wily.powerpack.webservices.handlers.WsdmLogger;
import com.wily.powerpack.webservices.handlers.WsdmMessageContext;
import com.wily.util.StringUtils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetAddress;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class WSDMClientProtocol
implements AbstractProtocol,
ClientProtocolFactory {
    public static final String CORRELATION_ID_NAME = "WSCorIDSOAPHeader";
    public static final String CORRELATION_NAMESPACE = "http://www.ca.com/apm";
    public static final String CORRELATION_ATTR_NAME = "CorID";
    public static final String CORRELATION_ID_KEY = "CorIDForSOAPInvocation";
    public static final String WSDM_CLIENT_PROTOCOL = "WSDMClientProtocol";
    public static final String WSDM_CLIENT_FEATURE = "http://www.ca.com/wsdmclientfeature";
    public static final String SAP_J2EESERVER_VER = "19";
    private static WsdmHandlerUtil wsdmHandlerUtil = null;
    public static final String WSDM_AGENT_PARSE_RESPONSE_SOAP = "com.wily.introscope.soa.parsesoap";
    private static final WsdmLogger log = new WsdmLogger();

    public static Object getInstanceMethod(Object rpe, Object appSrvCtx, Object appWSContext) {
        return new WSDMClientProtocol();
    }

    public void init(PropertyContext propertycontext) throws ClientProtocolException {
        this.initWsdmHandlerUtil();
    }

    private void initWsdmHandlerUtil() {
        wsdmHandlerUtil = WsdmHandlerUtil.getWsdmHandlerUtil();
    }

    private void processCorrelationId(int observationType, ClientSOAPMessage soapmessage) {
        block5: {
            if (!WSMUtils.correlationEnabled()) {
                return;
            }
            try {
                CorrelationId corrId = new CorrelationId();
                corrId.incrementSequenceId();
                String correlationString = corrId.getCurrentOutgoingCorrelationIdStrippedForHeader();
                if (log.isDebugLogging().booleanValue()) {
                    log.debug("WSDMClientProtocol.processCorrelationId() correlationId:" + correlationString);
                }
                if (WSMUtils.correlationSOAPInsertionEnabled()) {
                    Element header = soapmessage.createSoapHeader(CORRELATION_NAMESPACE, CORRELATION_ID_NAME);
                    Attr attr = header.getOwnerDocument().createAttribute(CORRELATION_ATTR_NAME);
                    attr.setValue(correlationString);
                    header.setAttributeNode(attr);
                    soapmessage.getHeaders().add(header);
                }
            }
            catch (Throwable e) {
                log.error("WSDMClientProtocol::processCorrelationId.Unable to processCorrelationId:" + e);
                if (!log.isDebugLogging().booleanValue()) break block5;
                log.debug("WSDMClientProtocol::processCorrelationId.Unable to processCorrelationId:" + WSMUtils.dumpStackTrace(e));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getSOAPEnvelope(ClientSOAPMessage soapmessage) {
        String soapEnvelope = null;
        ByteArrayOutputStream outputStream = null;
        try {
            outputStream = new ByteArrayOutputStream();
            soapmessage.writeTo((OutputStream)outputStream);
            soapEnvelope = ((Object)outputStream).toString();
        }
        catch (Throwable e) {
            log.error("WSDMClientProtocol::getSOAPEnvelope.Unable to getSOAPEnvelope:" + e);
            if (log.isDebugLogging().booleanValue()) {
                log.debug("WSDMClientProtocol::getSOAPEnvelope.Unable to getSOAPEnvelope:" + WSMUtils.dumpStackTrace(e));
            }
        }
        finally {
            block13: {
                try {
                    ((OutputStream)outputStream).close();
                }
                catch (Throwable e) {
                    log.error("WSDMClientProtocol::getSOAPEnvelope.Unable to close the stream:" + e);
                    if (!log.isDebugLogging().booleanValue()) break block13;
                    log.debug("Unable to close the stream" + WSMUtils.dumpStackTrace(e));
                }
            }
        }
        return soapEnvelope;
    }

    public boolean handleRequest(AbstractMessage message, PropertyContext propertyContext) throws ClientProtocolException {
        block4: {
            WsdmMessageContext wsdmMessageContext = null;
            ClientSOAPMessage soapmessage = null;
            try {
                PropertyContext bindingConfigContext = propertyContext.getSubContext("bindingConfig");
                String endpoint = (String)bindingConfigContext.getProperty("endpointUrl");
                if (wsdmHandlerUtil == null) {
                    this.initWsdmHandlerUtil();
                }
                soapmessage = ((ClientMimeMessage)message).getSOAPMessage();
                String reqSOAPMsg = this.getSOAPEnvelope(soapmessage);
                if (log.isDebugLogging().booleanValue()) {
                    log.debug("WSDMClientProtocol.handleRequest:reqSOAPMsg is \n" + reqSOAPMsg);
                }
                Element soapBody = soapmessage.getSoapBody();
                Node operationNode = soapBody.getFirstChild();
                wsdmMessageContext = new WsdmMessageContext(2);
                wsdmMessageContext.setServiceName(endpoint);
                wsdmMessageContext.setPortName(this.getHttpTransport(propertyContext).getEndpoint());
                wsdmMessageContext.setRequestorLocation(InetAddress.getLocalHost().getHostAddress());
                wsdmMessageContext.setRequestMessage(reqSOAPMsg);
                wsdmMessageContext.setOperationName(operationNode.getLocalName());
                String operationNS = operationNode.getNamespaceURI();
                operationNS = StringUtils.isEmpty((String)operationNS) ? endpoint : operationNS;
                wsdmMessageContext.setOperationNameSpace(operationNS);
                this.setNameCache(wsdmMessageContext.getOperationName(), wsdmMessageContext.getOperationNameSpace());
                this.processCorrelationId(2, soapmessage);
                wsdmHandlerUtil.observeRequest(wsdmMessageContext);
                propertyContext.setProperty("WSDM_TRANSID", (Object)wsdmMessageContext);
            }
            catch (Throwable e) {
                log.error("WSDMClientProtocol::handleRequest.Unable to handleRequest:" + e);
                if (!log.isDebugLogging().booleanValue()) break block4;
                log.debug("WSDMClientProtocol::handleRequest.Unable to handleRequest:" + WSMUtils.dumpStackTrace(e));
            }
        }
        return true;
    }

    public boolean handleResponse(AbstractMessage message, PropertyContext propertyContext) throws ClientProtocolException {
        block7: {
            WsdmMessageContext wsdmMessageContext = null;
            HTTPTransport transport = null;
            Object respSOAPMessage = null;
            int correlationCount = new CorrelationId().decrementCorrelationCount();
            log.debug("WSDMClientProtocol handleResponse correlationCount=" + correlationCount);
            try {
                if (message == null || !(message instanceof ClientMimeMessage)) {
                    return true;
                }
                wsdmMessageContext = (WsdmMessageContext)propertyContext.getProperty("WSDM_TRANSID");
                if (wsdmMessageContext == null) {
                    return true;
                }
                this.setNameCache(wsdmMessageContext.getOperationName(), wsdmMessageContext.getOperationNameSpace());
                transport = this.getHttpTransport(propertyContext);
                wsdmHandlerUtil.observeResponse(wsdmMessageContext);
                boolean bParseSoapMsg = WSMUtils.getAgentConfiguration().getBooleanProperty(WSDM_AGENT_PARSE_RESPONSE_SOAP, true);
                if (bParseSoapMsg) {
                    Document d;
                    WSMUtils.getLogger().debug("Parsing SOAP response for faults");
                    ClientMimeMessage msg = (ClientMimeMessage)message;
                    ByteArrayOutputStream baos = new ByteArrayOutputStream(1000);
                    msg.getSOAPMessage().writeTo((OutputStream)baos);
                    wsdmMessageContext.setResponseMessage(baos.toString());
                    if (WSMUtils.getLogger().isDebugEnabled()) {
                        WSMUtils.getLogger().debug("WSDMClientProtocol::handleResponse SOAP:" + baos.toString());
                    }
                    if (this.hasFault((d = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(baos.toByteArray(), 0, baos.size()))).getChildNodes())) {
                        WSMUtils.getLogger().debug("WSDMClientProtocol::handleResponse. Response has SoapFault");
                        this.reportFault(propertyContext);
                    }
                }
            }
            catch (Exception e) {
                log.error("WSDMClientProtocol::handleResponse.Unable to handleResponse:" + e);
                if (!log.isDebugLogging().booleanValue()) break block7;
                log.debug("WSDMClientProtocol::handleResponse.Unable to handleResponse:" + WSMUtils.dumpStackTrace(e));
            }
        }
        return true;
    }

    private boolean hasFault(NodeList nl) {
        if (nl != null) {
            int nLen = nl.getLength();
            for (int k = 0; k < nLen; ++k) {
                Node el = nl.item(k);
                if (!el.getNodeName().endsWith("Fault") && !this.hasFault(el.getChildNodes())) continue;
                return true;
            }
        }
        return false;
    }

    private void reportFault(PropertyContext propertyContext) throws ProtocolException {
        WsdmMessageContext wsdmMessageContext;
        String faultCode = null;
        String faultString = "SOAP Fault:";
        if (WSMUtils.getLogger().isDebugEnabled()) {
            WSMUtils.getLogger().debug("WSDMClientProtocol::reportFault");
        }
        if ((wsdmMessageContext = (WsdmMessageContext)propertyContext.getProperty("WSDM_TRANSID")) != null) {
            this.setNameCache(wsdmMessageContext.getOperationName(), wsdmMessageContext.getOperationNameSpace());
        }
        String[] sarr = new String[]{};
        wsdmHandlerUtil.spoolFault(wsdmMessageContext, wsdmMessageContext.getOperationNameSpace(), faultCode, faultString, sarr);
    }

    public boolean handleFault(AbstractMessage message, PropertyContext propertyContext) throws ClientProtocolException {
        block2: {
            int correlationCount = new CorrelationId().decrementCorrelationCount();
            log.debug("WSDMClientProtocol wsdmHandleFault correlationCount=" + correlationCount);
            try {
                this.reportFault(propertyContext);
            }
            catch (Throwable e) {
                log.error("WSDMClientProtocol::handleFault.Unable to handleFault:" + e);
                if (!log.isDebugLogging().booleanValue()) break block2;
                log.debug("WSDMClientProtocol::handleFault.Unable to handleFault:" + WSMUtils.dumpStackTrace(e));
            }
        }
        return true;
    }

    public boolean isFeatureImplemented(String featureName, PropertyContext property) {
        return true;
    }

    public String getName() {
        return WSDM_CLIENT_PROTOCOL;
    }

    public String[] getFeatures() {
        return new String[]{WSDM_CLIENT_FEATURE};
    }

    public ClientFeatureProvider newInstance() {
        try {
            return new WSDMClientProtocol();
        }
        catch (Throwable e) {
            log.error("WSDMClientProtocol::newInstance.Unable to newInstance:" + e);
            if (log.isDebugLogging().booleanValue()) {
                log.debug("WSDMClientProtocol::newInstance.Unable to newInstance:" + WSMUtils.dumpStackTrace(e));
            }
            return null;
        }
    }

    private String getSOAPResponse(HTTPTransport transport) throws Exception {
        StringBuilder respSOAPMessage = new StringBuilder();
        InputStream respStream = transport.getResponseStream();
        BufferedReader bufRdr = new BufferedReader(new InputStreamReader(respStream));
        String str = null;
        while ((str = bufRdr.readLine()) != null) {
            respSOAPMessage.append(str);
        }
        respStream.reset();
        return respSOAPMessage.toString();
    }

    private HTTPTransport getHttpTransport(PropertyContext ctx) {
        return (HTTPTransport)ctx.getProperty("transportInterface");
    }

    public boolean hasSOAPHeader(AbstractMessage message, PropertyContext propertyContext, String headerName) {
        boolean headerFound;
        block6: {
            headerFound = false;
            ClientSOAPMessage soapmessage = null;
            try {
                if (log.isDebugLogging().booleanValue()) {
                    log.debug("IN WSDMClientProtocol hasSOAPHeader-->Start Exec." + headerName);
                }
                if (message != null && message instanceof ClientMimeMessage) {
                    soapmessage = ((ClientMimeMessage)message).getSOAPMessage();
                }
                ArrayList headers = soapmessage.getHeaders();
                for (Element headerElement : headers) {
                    String localHeaderName = headerElement.getLocalName();
                    if (!localHeaderName.equals(headerName)) continue;
                    headerFound = true;
                    if (log.isDebugLogging().booleanValue()) {
                        log.debug("headerFound :" + headerFound);
                    }
                    break;
                }
            }
            catch (Throwable e) {
                log.error("WSDMClientProtocol::hasSOAPHeader.Unable to hasSOAPHeader:" + e);
                if (!log.isDebugLogging().booleanValue()) break block6;
                log.debug("WSDMClientProtocol::hasSOAPHeader.Unable to hasSOAPHeader:" + WSMUtils.dumpStackTrace(e));
            }
        }
        return headerFound;
    }

    public void addSOAPHeader(AbstractMessage message, PropertyContext propertyContext, String headerName) {
        block8: {
            ClientSOAPMessage soapmessage = null;
            try {
                if (log.isDebugLogging().booleanValue()) {
                    log.debug("IN WSDMClientProtocol addSOAPHeader.:" + headerName);
                }
                if (this.hasSOAPHeader(message, propertyContext, headerName)) {
                    if (log.isDebugLogging().booleanValue()) {
                        log.debug("headerFound.");
                        log.debug("Returning.");
                        log.debug("End exec IN WSDMClientProtocol addSOAPHeader");
                    }
                    return;
                }
                if (log.isDebugLogging().booleanValue()) {
                    log.debug("Header not found");
                    log.debug("Adding Header:" + headerName);
                }
                if (message != null && message instanceof ClientMimeMessage) {
                    soapmessage = ((ClientMimeMessage)message).getSOAPMessage();
                }
                Element header = soapmessage.createSoapHeader(CORRELATION_NAMESPACE, headerName);
                Text content = header.getOwnerDocument().createTextNode("WSDM_TRUE");
                header.appendChild(content);
                soapmessage.getHeaders().add(header);
                if (log.isDebugLogging().booleanValue()) {
                    log.debug("IN WSDMClientProtocol addSOAPHeader-->End Exec");
                }
            }
            catch (Throwable e) {
                log.error("WSDMClientProtocol::addSOAPHeader.Unable to addSOAPHeader:" + e);
                if (!log.isDebugLogging().booleanValue()) break block8;
                log.debug("WSDMClientProtocol::addSOAPHeader.Unable to addSOAPHeader:" + WSMUtils.dumpStackTrace(e));
            }
        }
    }

    public void setNameCache(String operationName, String namespace) {
        WSNameCache.setOperationName(operationName);
        WSNameCache.setNamespaceURI(namespace);
    }
}

