/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices.handlers.netweaver.server;

import com.sap.engine.interfaces.webservices.runtime.Config;
import com.sap.engine.interfaces.webservices.runtime.Key;
import com.sap.engine.interfaces.webservices.runtime.MessageException;
import com.sap.engine.interfaces.webservices.runtime.Protocol;
import com.sap.engine.interfaces.webservices.runtime.ProtocolContext;
import com.sap.engine.interfaces.webservices.runtime.ProtocolException;
import com.sap.engine.interfaces.webservices.runtime.RawMessage;
import com.sap.engine.interfaces.webservices.runtime.RuntimeContext;
import com.sap.engine.interfaces.webservices.runtime.ServerProtocolAppStateEvents;
import com.sap.engine.interfaces.webservices.runtime.Transport;
import com.sap.engine.interfaces.webservices.runtime.TransportBinding;
import com.sap.engine.interfaces.webservices.runtime.TransportBindingException;
import com.sap.engine.interfaces.webservices.runtime.soaphttp.HTTPTransport;
import com.sap.engine.services.webservices.additions.soaphttp.InternalSOAPMessage;
import com.sap.engine.services.webservices.additions.soaphttp.SOAPHTTPTransportBinding;
import com.sap.engine.services.webservices.runtime.definition.OperationDefinitionImpl;
import com.wily.introscope.agent.transactiontrace.CorrelationId;
import com.wily.powerpack.webservices.WSMUtils;
import com.wily.powerpack.webservices.extension.agent.trace.nameformatter.WSNameCache;
import com.wily.powerpack.webservices.handlers.WsdmHandlerUtil;
import com.wily.powerpack.webservices.handlers.WsdmLogger;
import com.wily.powerpack.webservices.handlers.WsdmMessageContext;
import com.wily.util.StringUtils;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;
import javax.xml.rpc.soap.SOAPFaultException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class WSDMProtocol
implements Protocol,
ServerProtocolAppStateEvents {
    public static final String WSDM_PROTOCOL = "WSDMProtocol";
    public static final String WSDM_FEATURE = "http://www.ca.com/wsdmfeature";
    public static final String SAP_J2EESERVER_VER = "19";
    private static WsdmHandlerUtil wsdmHandlerUtil = null;
    public static final String CORRELATION_ID_NAME = "WSCorIDSOAPHeader";
    public static final String CORRELATION_NAMESPACE = "http://www.ca.com/apm";
    public static final String CORRELATION_ATTR_NAME = "CorID";
    public static final String CORRELATION_ID_KEY = "CorIDForSOAPInvocation";
    private static final WsdmLogger log = new WsdmLogger();

    public Config getRequiredFeatures() {
        return null;
    }

    public String getProtocolName() {
        return WSDM_PROTOCOL;
    }

    public void init() {
    }

    public boolean handleFault(ProtocolContext context) throws ProtocolException {
        block17: {
            String faultCode = null;
            String faultString = null;
            try {
                TransportBinding tb = context.getRuntimeContext().getRuntimeTransportBinding();
                SOAPHTTPTransportBinding binding = (SOAPHTTPTransportBinding)tb;
                Transport transport = binding.getTransport();
                HTTPTransport httptransport = (HTTPTransport)transport;
                HttpServletRequest req = httptransport.getRequest();
                if (req == null) break block17;
                if (log.isDebugLogging().booleanValue()) {
                    log.debug("WSDMProtocol::handleFault -> Request Found ...........");
                }
                WsdmMessageContext wsdmMessageContext = (WsdmMessageContext)context.getPropertiesReference().get("WSDM_TRANSID");
                this.setNameCache(wsdmMessageContext.getOperationName(), wsdmMessageContext.getOperationNameSpace());
                try {
                    RawMessage rawMessage = context.getRuntimeContext().getRuntimeTransportBinding().getRawMessage();
                    if (log.isDebugLogging().booleanValue()) {
                        log.debug("WSDMProtocol::handleFault -> Raw Message ..........." + rawMessage);
                    }
                    if (rawMessage != null && rawMessage instanceof InternalSOAPMessage) {
                        InternalSOAPMessage msg = (InternalSOAPMessage)rawMessage;
                        Element ele = msg.getSoapEnvelope();
                        Element body = msg.getSoapBody();
                        NodeList bodyElement = body.getChildNodes();
                        Node messageElement = body.getFirstChild();
                        String resp = ele.toString();
                        wsdmMessageContext.setResponseMessage(resp);
                        for (int i = 0; i < bodyElement.getLength(); ++i) {
                            Node bodyChild = bodyElement.item(i);
                            if (bodyChild.getNodeType() != 1) continue;
                            messageElement = bodyChild;
                            break;
                        }
                        if (messageElement != null) {
                            NodeList faultElements = messageElement.getChildNodes();
                            String[] sarr = null;
                            for (int k = 0; k < faultElements.getLength(); ++k) {
                                Node faultElement = faultElements.item(k);
                                String nodeName = faultElement.getNodeName();
                                String nodeValue = faultElement.getFirstChild().getNodeValue();
                                if ("faultcode".equals(nodeName)) {
                                    faultCode = nodeValue;
                                    continue;
                                }
                                if ("faultstring".equals(nodeName)) {
                                    faultString = nodeValue;
                                    continue;
                                }
                                if (!"detail".equals(nodeValue)) continue;
                                ArrayList<String> detailList = new ArrayList<String>();
                                NodeList detailNodes = faultElement.getChildNodes();
                                int nSize = detailNodes.getLength();
                                for (int i = 0; i < nSize; ++i) {
                                    Node detailNode = detailNodes.item(i);
                                    if (detailNode.getNodeType() != 1) continue;
                                    detailList.add(detailNode.toString());
                                }
                                log.debug("ServerFault:detailList:" + detailList);
                                sarr = detailList.toArray(new String[0]);
                            }
                            if (log.isDebugLogging().booleanValue()) {
                                log.debug("WSDMProtocol::handleFault -> faultString Fault ..........." + faultString);
                                log.debug("faultCode:" + faultCode);
                                log.debug("faultString:" + faultString);
                                log.debug("Spooling Fault:");
                                if (sarr != null) {
                                    log.debug("Spooling Fault with detail:");
                                    for (int i = 0; i < sarr.length; ++i) {
                                        log.debug((String)sarr[i]);
                                    }
                                    log.debug("End of the detail before Spooling Fault.");
                                }
                            }
                            wsdmHandlerUtil.spoolFault(wsdmMessageContext, wsdmMessageContext.getOperationNameSpace(), faultCode, faultString, sarr);
                        }
                    }
                }
                catch (TransportBindingException e) {
                    log.error("WSDMProtocol::handleFault.Unable to handleFault:" + (Object)((Object)e));
                    if (log.isDebugLogging().booleanValue()) {
                        log.debug("WSDMProtocol::handleFault.Unable to handleFault:" + WSMUtils.dumpStackTrace(e));
                    }
                }
            }
            catch (Throwable e) {
                log.error("WSDMProtocol::handleFault.Unable to handleFault:" + e);
                if (!log.isDebugLogging().booleanValue()) break block17;
                log.debug("WSDMProtocol::handleFault.Unable to handleFault:" + WSMUtils.dumpStackTrace(e));
            }
        }
        return true;
    }

    private void processCorrelationId(WsdmMessageContext wsdmMessageContext, InternalSOAPMessage msg) {
        block11: {
            try {
                ArrayList headers = msg.getHeaders();
                boolean correlationIdFound = false;
                if (headers != null) {
                    for (Element headerElement : headers) {
                        String headerName = headerElement.getLocalName();
                        if (!headerName.equals(CORRELATION_ID_NAME)) continue;
                        correlationIdFound = true;
                        String correlationId = headerElement.getAttribute(CORRELATION_ATTR_NAME);
                        wsdmMessageContext.setCorrelationId(correlationId);
                        if (log.isDebugLogging().booleanValue()) {
                            log.debug("correlationId..." + correlationId);
                        }
                        try {
                            CorrelationId correlationId2 = new CorrelationId(correlationId);
                        }
                        catch (Exception e) {
                            log.error(e.getMessage());
                        }
                        break;
                    }
                }
                if (!correlationIdFound) {
                    try {
                        CorrelationId headerIterator = new CorrelationId();
                    }
                    catch (Exception e) {
                        log.error("WSDMProtocol::processCorrelationId.Unable to processCorrelationId:" + e);
                        if (log.isDebugLogging().booleanValue()) {
                            log.debug("WSDMProtocol::processCorrelationId.Unable to processCorrelationId:" + WSMUtils.dumpStackTrace(e));
                        }
                    }
                }
            }
            catch (Throwable e) {
                log.error("WSDMProtocol::processCorrelationId.Unable to processCorrelationId:" + e);
                if (!log.isDebugLogging().booleanValue()) break block11;
                log.debug("WSDMProtocol::processCorrelationId.Unable to processCorrelationId:" + WSMUtils.dumpStackTrace(e));
            }
        }
    }

    public boolean handleRequest(ProtocolContext context) throws ProtocolException, MessageException {
        String portName = null;
        String reqLoc = null;
        String reqMsg = "";
        String opName = "";
        String opNameSpace = null;
        WsdmMessageContext wsdmMessageContext = null;
        RuntimeContext runtimeCtx = null;
        TransportBinding runtimeTransport = null;
        try {
            wsdmMessageContext = new WsdmMessageContext(1);
            if (wsdmHandlerUtil == null) {
                wsdmHandlerUtil = WsdmHandlerUtil.getWsdmHandlerUtil();
            }
            runtimeCtx = context.getRuntimeContext();
            OperationDefinitionImpl opDefImpl = (OperationDefinitionImpl)runtimeCtx.getOperation();
            opName = opDefImpl.getOperationName();
            Key[] operationDef = opDefImpl.getKeys();
            if (operationDef != null) {
                for (Key objOpdefKey : operationDef) {
                    if (!objOpdefKey.getName().equals("first-body-element-ns")) continue;
                    opNameSpace = objOpdefKey.getValue();
                    break;
                }
            }
            runtimeTransport = runtimeCtx.getRuntimeTransportBinding();
            RawMessage rawMessage = runtimeTransport.getRawMessage();
            InternalSOAPMessage msg = (InternalSOAPMessage)rawMessage;
            this.processCorrelationId(wsdmMessageContext, msg);
            reqMsg = msg.getSoapEnvelope().toString();
            log.debug("WSDMProtocol.handleRequest():reqMsg:\n" + reqMsg);
            SOAPHTTPTransportBinding binding = (SOAPHTTPTransportBinding)runtimeTransport;
            Transport transport = binding.getTransport();
            HTTPTransport httptransport = (HTTPTransport)transport;
            HttpServletRequest req = httptransport.getRequest();
            if (req != null) {
                String queryStr = req.getQueryString();
                portName = req.getServerPort() == 80 ? "http://" + req.getServerName() + req.getRequestURI() : "http://" + req.getServerName() + ":" + req.getServerPort() + req.getRequestURI();
                if (queryStr != null) {
                    portName = portName + "?" + queryStr;
                }
                reqLoc = req.getRemoteAddr();
            }
            String serviceName = runtimeCtx.getTransport().getEntryPointID();
            wsdmMessageContext.setServiceName(serviceName);
            wsdmMessageContext.setPortName(portName);
            wsdmMessageContext.setRequestorLocation(reqLoc);
            wsdmMessageContext.setRequestMessage(reqMsg);
            wsdmMessageContext.setOperationName(opName);
            wsdmMessageContext.setOperationNameSpace(StringUtils.isEmpty((String)opNameSpace) ? serviceName : opNameSpace);
            wsdmHandlerUtil.observeRequest(wsdmMessageContext);
            context.getPropertiesReference().put("WSDM_TRANSID", wsdmMessageContext);
            return true;
        }
        catch (Throwable e) {
            block11: {
                try {
                    log.error("WSDMProtocol::handleRequest.Unable to handleRequest:" + e);
                    if (log.isDebugLogging().booleanValue()) {
                        log.debug("WSDMProtocol::handleRequest.Unable to handleRequest:" + WSMUtils.dumpStackTrace(e));
                    }
                }
                catch (Exception ex) {
                    log.error("WSDMProtocol::handleRequest.Unable to handleRequest:" + ex);
                    if (!log.isDebugLogging().booleanValue()) break block11;
                    log.debug("WSDMProtocol::handleRequest.Unable to handleRequest:" + WSMUtils.dumpStackTrace(ex));
                }
            }
            if (e instanceof SOAPFaultException) {
                throw (SOAPFaultException)e;
            }
            return true;
        }
    }

    public boolean handleResponse(ProtocolContext arg0) throws ProtocolException {
        block9: {
            WsdmMessageContext wsdmMessageContext = null;
            try {
                wsdmMessageContext = (WsdmMessageContext)arg0.getPropertiesReference().get("WSDM_TRANSID");
                if (wsdmMessageContext == null) {
                    if (log.isDebugLogging().booleanValue()) {
                        log.debug("WsdmJaxRpcHandler::response not found.hence returning.");
                    }
                    return true;
                }
                RawMessage rawMessage = arg0.getRuntimeContext().getRuntimeTransportBinding().getRawMessage();
                InternalSOAPMessage msg = (InternalSOAPMessage)rawMessage;
                Element ele = msg.getSoapEnvelope();
                Element body = msg.getSoapBody();
                String resp = ele.toString();
                wsdmMessageContext.setResponseMessage(resp);
                NodeList bodyElement = body.getChildNodes();
                Node messageElement = body.getFirstChild();
                for (int i = 0; i < bodyElement.getLength(); ++i) {
                    Node bodyChild = bodyElement.item(i);
                    if (bodyChild.getNodeType() != 1) continue;
                    messageElement = bodyChild;
                    break;
                }
                if (messageElement != null) {
                    QName msQName = new QName(messageElement.getNamespaceURI(), messageElement.getLocalName());
                    QName SOAP11FaultQName = new QName("http://schemas.xmlsoap.org/soap/envelope/", "Fault");
                    QName SOAP12FaultQName = new QName("http://www.w3.org/2003/05/soap-envelope", "Fault");
                    if (msQName.equals(SOAP11FaultQName) || msQName.equals(SOAP12FaultQName)) {
                        return this.handleFault(arg0);
                    }
                }
                this.setNameCache(wsdmMessageContext.getOperationName(), wsdmMessageContext.getOperationNameSpace());
                wsdmHandlerUtil.observeResponse(wsdmMessageContext);
            }
            catch (TransportBindingException e) {
                log.error("WSDMProtocol::handleResponse.Unable to handleResponse:" + (Object)((Object)e));
                if (log.isDebugLogging().booleanValue()) {
                    log.debug("WSDMProtocol::handleResponse.Unable to handleResponse:" + WSMUtils.dumpStackTrace(e));
                }
            }
            catch (Exception e) {
                log.error("WSDMProtocol::handleResponse.Unable to handleResponse:" + e);
                if (!log.isDebugLogging().booleanValue()) break block9;
                log.debug("WSDMProtocol::handleResponse.Unable to handleResponse:" + WSMUtils.dumpStackTrace(e));
            }
        }
        return true;
    }

    public void onStartApplicationEvent(RuntimeContext arg0) {
    }

    public void onStopApplicationEvent(RuntimeContext arg0) {
    }

    public boolean hasSOAPHeader(ProtocolContext context, String headerName) {
        boolean headerFound;
        block6: {
            headerFound = false;
            try {
                InternalSOAPMessage msg;
                ArrayList headers;
                RawMessage rawMessage;
                if (log.isDebugLogging().booleanValue()) {
                    log.debug("IN WSDMProtocol hasSOAPHeader-->Start Exec");
                }
                if ((rawMessage = context.getRuntimeContext().getRuntimeTransportBinding().getRawMessage()) != null && rawMessage instanceof InternalSOAPMessage && (headers = (msg = (InternalSOAPMessage)rawMessage).getHeaders()) != null) {
                    for (Element headerElement : headers) {
                        String localHeaderName = headerElement.getLocalName();
                        if (!headerName.equals(localHeaderName)) continue;
                        headerFound = true;
                        break;
                    }
                }
                if (log.isDebugLogging().booleanValue()) {
                    log.debug("IN WSDMProtocol hasSOAPHeader-->End Exec");
                }
            }
            catch (Throwable e) {
                log.error("WSDMProtocol::hasSOAPHeader.Unable to hasSOAPHeader:" + e);
                if (!log.isDebugLogging().booleanValue()) break block6;
                log.debug("WSDMProtocol::hasSOAPHeader.Unable to hasSOAPHeader:" + WSMUtils.dumpStackTrace(e));
            }
        }
        return headerFound;
    }

    public void addSOAPHeader(ProtocolContext context, String headerName) {
        block12: {
            if (log.isDebugLogging().booleanValue()) {
                log.debug("Start exec :WSDMProtocol addSOAPHeader");
            }
            RawMessage rawMessage = null;
            try {
                if (this.hasSOAPHeader(context, headerName)) {
                    if (log.isDebugLogging().booleanValue()) {
                        log.debug("Header Flag found.....Returning.");
                    }
                    return;
                }
                if (log.isDebugLogging().booleanValue()) {
                    log.debug("No header Flag found.");
                    log.debug("Adding Flag in the Header:" + headerName);
                }
                if ((rawMessage = context.getRuntimeContext().getRuntimeTransportBinding().getRawMessage()) != null && rawMessage instanceof InternalSOAPMessage) {
                    InternalSOAPMessage soapMessage = (InternalSOAPMessage)rawMessage;
                    Element soapEnvelope = soapMessage.getSoapEnvelope();
                    ArrayList headers = soapMessage.getHeaders();
                    Element soapHeader = soapEnvelope.getOwnerDocument().createElementNS("http://schemas.xmlsoap.org/soap/envelope/", headerName);
                    Text content = soapHeader.getOwnerDocument().createTextNode("WSDM_TRUE");
                    soapHeader.appendChild(content);
                    soapMessage.getHeaders().add(soapHeader);
                    if (log.isDebugLogging().booleanValue()) {
                        log.debug("Added headers successfully");
                        log.debug("\nHEaders2:" + soapMessage.getHeaders());
                    }
                } else if (log.isDebugLogging().booleanValue()) {
                    log.debug("IN WSDMProtocol addSOAPHeader-->No InternalSOAPMessage found");
                }
                if (log.isDebugLogging().booleanValue()) {
                    log.debug("IN WSDMProtocol addSOAPHeader-->End Exec");
                }
            }
            catch (Throwable e) {
                log.error("WSDMProtocol::addSOAPHeader.Unable to addSOAPHeader:" + e);
                if (!log.isDebugLogging().booleanValue()) break block12;
                log.debug("WSDMProtocol::addSOAPHeader.Unable to addSOAPHeader:" + WSMUtils.dumpStackTrace(e));
            }
        }
        if (log.isDebugLogging().booleanValue()) {
            log.debug("End exec :WSDMProtocol addSOAPHeader");
        }
    }

    private void setNameCache(String operationName, String namespace) {
        WSNameCache.setOperationName(operationName);
        WSNameCache.setNamespaceURI(namespace);
    }
}

