/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.cmp.directives;

import com.wily.diagnos.cmp.directives.ADirective;
import com.wily.diagnos.cmp.directives.builder.CompilerSettingsBuilder;
import com.wily.diagnos.cmp.transform.builder.SubstituteClassTransformationBuilder;
import com.wily.util.classfile.IClassName;

public final class SubstituteClassDirective
extends ADirective {
    private final IClassName fSourceClass;
    private final IClassName fReplacementClass;

    public SubstituteClassDirective(String source, int lineNumber, IClassName sourceClass, IClassName replacementClass) {
        super(source, lineNumber);
        this.fSourceClass = sourceClass;
        this.fReplacementClass = replacementClass;
    }

    private IClassName getSourceClass() {
        return this.fSourceClass;
    }

    private IClassName getReplacementClass() {
        return this.fReplacementClass;
    }

    @Override
    protected void applyToSettings(CompilerSettingsBuilder builder) {
        builder.addTransformation(new SubstituteClassTransformationBuilder(this.getSourceClass(), this.getReplacementClass()));
    }
}

