/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.cmp.directives.utility;

import com.wily.diagnos.cmp.directives.TracerGroup;
import com.wily.diagnos.cmp.log.ICompilerLog;
import com.wily.util.classfile.IModeledClass;
import com.wily.util.classfile.IModeledMethod;

public class CompilerSettingsUtility {
    private static final String kEmptyString = "                    ";
    private static final int kLength = "                    ".length();

    public static boolean shouldSkipMethodInClassForTracerGroup(ICompilerLog log, IModeledClass theClass, IModeledMethod theMethod, boolean checkClass, TracerGroup tracerGroup) {
        boolean skipMethod = false;
        if (tracerGroup != null) {
            if (tracerGroup.isEnabled()) {
                if (checkClass && tracerGroup.shouldSkipInstrumentationInClass(theClass)) {
                    log.ICompilerLog_logSkippedClassForFlag(tracerGroup.getName().getName());
                    skipMethod = true;
                }
                if (!skipMethod) {
                    boolean skipBecauseOfClass = tracerGroup.shouldSkipInstrumentationInClassForMethod(theClass, theMethod);
                    boolean skipBecauseOfFlag = tracerGroup.shouldSkipFlaggedMethod(theMethod);
                    skipMethod = skipBecauseOfClass || skipBecauseOfFlag;
                }
            } else {
                skipMethod = true;
            }
        }
        return skipMethod;
    }

    public static final String getKeyFromString(String s) {
        String result = kEmptyString.concat(s);
        return result.substring(result.length() - kLength);
    }
}

