/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.cmp.transform;

import com.wily.diagnos.cmp.classmatcher.DGAllClassMatcher;
import com.wily.diagnos.cmp.classmatcher.IClassMatcher;
import com.wily.diagnos.cmp.directives.DGCompilerSettings;
import com.wily.diagnos.cmp.directives.TracerGroup;
import com.wily.diagnos.cmp.directives.apply.ClassSettingsApplier;
import com.wily.diagnos.cmp.directives.builder.CompilerSettingsBuilder;
import com.wily.diagnos.cmp.log.ICompilerLog;
import com.wily.diagnos.cmp.mutate.IMethodMutator;
import com.wily.diagnos.cmp.mutate.IMutation;
import com.wily.diagnos.cmp.transform.AEveryMethodTransformation;
import com.wily.diagnos.cmp.transform.ITracerGroupTransformation;
import com.wily.diagnos.cmp.transform.builder.ITransformationBuilder;
import com.wily.diagnos.cmp.transform.builder.NoticeFieldAssignmentTransformationBuilder;
import com.wily.util.classfile.IClassName;
import com.wily.util.classfile.IModeledClass;
import com.wily.util.classfile.IModeledMethod;

public final class NoticeFieldAssignmentTransformation
extends AEveryMethodTransformation
implements ITracerGroupTransformation {
    private final IClassName fInstrumentationClassName;
    private final TracerGroup fTracerGroup;
    private final IClassName fEventNoticingClass;
    private final TracerGroup fScopeTracerGroup;

    public NoticeFieldAssignmentTransformation(ICompilerLog log, IClassName instrumentationClassName, TracerGroup tracerGroup, IClassName eventNoticingClass, TracerGroup scopeTracerGroup) {
        super(log);
        this.fInstrumentationClassName = instrumentationClassName;
        this.fTracerGroup = tracerGroup;
        this.fEventNoticingClass = eventNoticingClass;
        this.fScopeTracerGroup = scopeTracerGroup;
    }

    public IClassName getInstrumentationClassName() {
        return this.fInstrumentationClassName;
    }

    @Override
    public TracerGroup getTracerGroup() {
        return this.fTracerGroup;
    }

    public IClassName getEventNoticingClass() {
        return this.fEventNoticingClass;
    }

    public TracerGroup getScopeTracerGroup() {
        return this.fScopeTracerGroup;
    }

    public IClassMatcher getScopeClassMatcher() {
        if (this.getScopeTracerGroup() == null) {
            return DGAllClassMatcher.getInstance();
        }
        return this.getScopeTracerGroup().getClassMatcher();
    }

    @Override
    protected boolean doShouldProcessClass(DGCompilerSettings settings, IModeledClass targetClass) {
        return !ClassSettingsApplier.shouldSkipClassForTracerGroup(this.getLog(), targetClass, this.getTracerGroup()) && !ClassSettingsApplier.shouldSkipClassForTracerGroup(this.getLog(), targetClass, this.getScopeTracerGroup()) && this.getScopeClassMatcher().IClassMatcher_matches(targetClass);
    }

    @Override
    protected boolean doShouldMutateMethod(DGCompilerSettings settings, IModeledMethod targetMethod) {
        return targetMethod.hasBytecode();
    }

    @Override
    protected IMutation doGenerateMethodMutation(DGCompilerSettings settings, IMethodMutator mutator, IModeledMethod targetMethod) {
        return mutator.newNoticeFieldAssignmentMethodMutation(settings, targetMethod, this);
    }

    @Override
    public ITransformationBuilder generateTransformationBuilder(CompilerSettingsBuilder builder) {
        return new NoticeFieldAssignmentTransformationBuilder(builder.getTracerGroupBuilder(this.getTracerGroup()), this.getEventNoticingClass(), builder.getTracerGroupBuilder(this.getScopeTracerGroup()));
    }
}

