/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.cmp.transform;

import com.wily.diagnos.cmp.directives.DGCompilerSettings;
import com.wily.diagnos.cmp.directives.TracerGroup;
import com.wily.diagnos.cmp.directives.apply.ClassSettingsApplier;
import com.wily.diagnos.cmp.directives.builder.CompilerSettingsBuilder;
import com.wily.diagnos.cmp.log.ICompilerLog;
import com.wily.diagnos.cmp.mutate.IClassMutator;
import com.wily.diagnos.cmp.mutate.IMutation;
import com.wily.diagnos.cmp.transform.AClassTransformation;
import com.wily.diagnos.cmp.transform.ITracerGroupTransformation;
import com.wily.diagnos.cmp.transform.builder.ITransformationBuilder;
import com.wily.diagnos.cmp.transform.builder.SubstituteStaticFieldTransformationBuilder;
import com.wily.util.classfile.FullyQualifiedFieldName;
import com.wily.util.classfile.IModeledClass;

public final class SubstituteStaticFieldTransformation
extends AClassTransformation
implements ITracerGroupTransformation {
    private final TracerGroup fTracerGroup;
    private final FullyQualifiedFieldName fSourceField;
    private final FullyQualifiedFieldName fReplacementField;

    public SubstituteStaticFieldTransformation(ICompilerLog log, FullyQualifiedFieldName sourceField, FullyQualifiedFieldName replacementField) {
        this(log, null, sourceField, replacementField);
    }

    public SubstituteStaticFieldTransformation(ICompilerLog log, TracerGroup tracerGroup, FullyQualifiedFieldName sourceField, FullyQualifiedFieldName replacementField) {
        super(log);
        this.fTracerGroup = tracerGroup;
        this.fSourceField = sourceField;
        this.fReplacementField = replacementField;
    }

    @Override
    public TracerGroup getTracerGroup() {
        return this.fTracerGroup;
    }

    public FullyQualifiedFieldName getSourceField() {
        return this.fSourceField;
    }

    public FullyQualifiedFieldName getReplacementField() {
        return this.fReplacementField;
    }

    @Override
    protected boolean doShouldProcessClass(DGCompilerSettings settings, IModeledClass targetClass) {
        return !ClassSettingsApplier.shouldSkipClassForTracerGroup(this.getLog(), targetClass, this.getTracerGroup());
    }

    @Override
    protected boolean doShouldMutateClass(DGCompilerSettings settings, IModeledClass targetClass) {
        return true;
    }

    @Override
    protected IMutation doGenerateClassMutation(DGCompilerSettings settings, IClassMutator mutator, IModeledClass targetClass) {
        return mutator.newSubstituteStaticFieldClassMutation(settings, targetClass, this);
    }

    @Override
    public ITransformationBuilder generateTransformationBuilder(CompilerSettingsBuilder builder) {
        return new SubstituteStaticFieldTransformationBuilder(builder.getTracerGroupBuilder(this.getTracerGroup()), this.getSourceField(), this.getReplacementField());
    }
}

