/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.cmp.transform.builder;

import com.wily.diagnos.cmp.directives.TracerGroup;
import com.wily.diagnos.cmp.directives.builder.TracerGroupBuilder;
import com.wily.diagnos.cmp.log.ICompilerLog;
import com.wily.diagnos.cmp.transform.ITransformation;
import com.wily.diagnos.cmp.transform.SubstituteStaticFieldTransformation;
import com.wily.diagnos.cmp.transform.builder.ITransformationBuilder;
import com.wily.util.classfile.FullyQualifiedFieldName;
import com.wily.util.classfile.IClassName;
import java.util.Map;

public final class SubstituteStaticFieldTransformationBuilder
implements ITransformationBuilder {
    private final TracerGroupBuilder fTracerGroupBuilder;
    private final FullyQualifiedFieldName fSourceField;
    private final FullyQualifiedFieldName fReplacementField;

    public SubstituteStaticFieldTransformationBuilder(FullyQualifiedFieldName sourceField, FullyQualifiedFieldName replacementField) {
        this(null, sourceField, replacementField);
    }

    public SubstituteStaticFieldTransformationBuilder(TracerGroupBuilder tracerGroupBuilder, FullyQualifiedFieldName sourceField, FullyQualifiedFieldName replacementField) {
        this.fTracerGroupBuilder = tracerGroupBuilder;
        this.fSourceField = sourceField;
        this.fReplacementField = replacementField;
    }

    public TracerGroupBuilder getTracerGroupBuilder() {
        return this.fTracerGroupBuilder;
    }

    public FullyQualifiedFieldName getSourceField() {
        return this.fSourceField;
    }

    public FullyQualifiedFieldName getReplacementField() {
        return this.fReplacementField;
    }

    @Override
    public ITransformation generateTransformation(ICompilerLog log, IClassName instrumentationClass, Map tracerGroups) {
        TracerGroup tracerGroup = this.getTracerGroupBuilder() == null ? null : this.getTracerGroupBuilder().lookupTracerGroup(tracerGroups);
        return new SubstituteStaticFieldTransformation(log, tracerGroup, this.getSourceField(), this.getReplacementField());
    }
}

