/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.personality.java.classfile.attributes;

import com.wily.diagnos.cmp.classfile.DGClassLoadingException;
import com.wily.diagnos.cmp.classfile.DGClassModificationException;
import com.wily.diagnos.cmp.classmatcher.IClassMatcher;
import com.wily.diagnos.cmp.directives.DGMethodSkippedException;
import com.wily.diagnos.cmp.log.ICompilerLog;
import com.wily.diagnos.personality.java.classfile.DGClassConstants;
import com.wily.diagnos.personality.java.classfile.DGMethod;
import com.wily.diagnos.personality.java.classfile.attributes.DGAttribute;
import com.wily.diagnos.personality.java.classfile.attributes.DGLineNumberTable;
import com.wily.diagnos.personality.java.classfile.attributes.DGStackMapTable;
import com.wily.diagnos.personality.java.classfile.bytecode.DGByteCode;
import com.wily.diagnos.personality.java.classfile.bytecode.DGOpcodes;
import com.wily.diagnos.personality.java.classfile.bytecode.DupByteCode;
import com.wily.diagnos.personality.java.classfile.bytecode.DupX1ByteCode;
import com.wily.diagnos.personality.java.classfile.bytecode.GotoByteCode;
import com.wily.diagnos.personality.java.classfile.bytecode.LoadLocalObjectAndInvokeStaticMethodByteCode;
import com.wily.diagnos.personality.java.classfile.bytecode.NoticeEventByteCode;
import com.wily.diagnos.personality.java.classfile.bytecode.SaveThisByteCode;
import com.wily.diagnos.personality.java.classfile.bytecode.SocketReadStaticMethodCallByteCode;
import com.wily.diagnos.personality.java.classfile.bytecode.SocketWriteStaticMethodCallByteCode;
import com.wily.diagnos.personality.java.classfile.bytecode.StaticMethodCallByteCode;
import com.wily.diagnos.personality.java.classfile.bytecode.StaticMethodCallByteCodeForParameterSubstitution;
import com.wily.diagnos.personality.java.classfile.bytecode.StaticMethodCallByteCodeWithCastResult;
import com.wily.diagnos.personality.java.classfile.bytecode.StoreAwayStackByteCode;
import com.wily.diagnos.personality.java.classfile.constants.DGClassConstant;
import com.wily.diagnos.personality.java.classfile.constants.DGConstantPool;
import com.wily.diagnos.personality.java.classfile.constants.DGFieldMethodRefConstant;
import com.wily.diagnos.personality.java.compiler.DGStreamSingleCompiler;
import com.wily.diagnos.personality.java.tracer.IJavaMethodTracerInstance;
import com.wily.introscope.agent.runtime.java.environment.EnvironmentStatisticsHandler;
import com.wily.introscope.probebuilder.instrumentation.IInstrumentationDecider;
import com.wily.introscope.probebuilder.instrumentation.InstrumentationDeciderFactory;
import com.wily.util.classfile.IClassName;
import com.wily.util.classfile.InvalidClassNameException;
import com.wily.util.classfile.java.ClassFileFieldDescriptor;
import com.wily.util.classfile.java.ClassName;
import com.wily.util.text.CompoundLocalizableMessage;
import com.wily.util.text.FormattedLocalizableMessage;
import com.wily.util.text.ILocalizableMessage;
import com.wily.util.text.LocalizedMessage;
import com.wily.util.text.SimpleLocalizableMessage;
import com.wily.wilyassert.Assertion;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public final class DGCode
extends DGAttribute
implements DGClassConstants,
DGOpcodes {
    public static final boolean kInsertAsStartOfBasicBlock = true;
    public static final boolean kInsertAsEndOfBasicBlock = false;
    public static volatile boolean sRemoveLineNumbers;
    public static final String kRemoveLineNumbersSystemPropertyKey = "com.wily.probebuilder.removeLineNumbers";
    private static final String kConstructorPolicyFull = "Full";
    public static final String kConstructorPolicyPartial = "Partial";
    private static final String kConstructorPolicyNone = "None";
    private static final String kConstructorPolicyAuto = "Auto";
    private static volatile boolean sConstructorInstrumentation;
    private static volatile boolean sConstructorInstrumentationPartial;
    public static final String kCodeName = "Code";
    private static final String kMaxStackTooLarge = "Stack size is too large";
    private static final String kMaxLocalsTooLarge = "Too many local variables";
    private static final String kMethodTooLong = "Method is too long";
    private static final String kWideningConstantIndicesNotSupported = "Widening of constant pool indices is not supported";
    private static final String kWideningJumpsWhileInstrumentingNotSupported = "Widening of jump offsets while inserting intrumentation is not supported";
    private static final String kWideningJumpsWithStackMapNotSupported = "Widening of conditional jump offsets for java 1.6+ code is not supported";
    private static final String kClassModificationExceptionWhileWideningJumpOffsets = "An exception occured while widening jump offsets: ";
    private static final String kConditionalOpcodeExpected = "Expected a conditional opcode";
    private static final String kZeroJumpOffsetFound = "Jump offset of zero should never occur";
    private static final String kConstructorSkipped = "Constructor instrumentation skipped by policy.";
    private DGConstantPool fConstantPool;
    private int fPC;
    private int fMaxStack;
    private int fMaxLocals;
    private byte[] fCode;
    private List fAttributes;
    private int fTotalSize;
    private boolean fDirty = true;
    private boolean fDirty2;
    private boolean fCannotWidenJumpOffset = false;
    private DGExceptionEntry[] fExceptions;
    private final ICompilerLog fLog;
    private DGMethod fMethod;
    private DGLineNumberTable fLineNumberTable;
    private DGStackMapTable fStackMapTable;
    private final IInstrumentationDecider fInstrumentationDecider;

    public static void setRemoveLineNumbersFlag(boolean flag) {
        sRemoveLineNumbers = flag;
    }

    public static void setConstructorInstrumentationPolicy(String policy) {
        if (kConstructorPolicyNone.equals(policy)) {
            sConstructorInstrumentation = false;
        } else if (kConstructorPolicyPartial.equals(policy)) {
            sConstructorInstrumentation = true;
            sConstructorInstrumentationPartial = true;
        } else if (kConstructorPolicyFull.equals(policy)) {
            sConstructorInstrumentation = true;
            sConstructorInstrumentationPartial = false;
        } else if (kConstructorPolicyAuto.equals(policy)) {
            String vmVersion = EnvironmentStatisticsHandler.getVmVersion();
            sConstructorInstrumentation = true;
            sConstructorInstrumentationPartial = vmVersion.startsWith("1.7") || vmVersion.startsWith("1.8");
        }
    }

    DGStackMapTable getStackMapTable() {
        return this.fStackMapTable;
    }

    public DGCode(DGConstantPool constantPool, int nameIndex, String name, byte[] data, ICompilerLog log) throws DGClassLoadingException, IOException {
        super(nameIndex, name, data);
        this.fLog = log;
        this.fConstantPool = constantPool;
        this.fTotalSize = this.fAttribData.length;
        this.fDirty2 = false;
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(this.fAttribData));
        this.fMaxStack = in.readUnsignedShort();
        this.fMaxLocals = in.readUnsignedShort();
        int codeLength = in.readInt();
        this.fCode = new byte[codeLength];
        in.readFully(this.fCode);
        int exceptionTableLength = in.readUnsignedShort();
        this.fExceptions = new DGExceptionEntry[exceptionTableLength];
        for (int i = 0; i < this.fExceptions.length; ++i) {
            this.fExceptions[i] = new DGExceptionEntry(in);
        }
        int attributeCount = in.readUnsignedShort();
        this.fAttributes = new ArrayList();
        for (int i = 0; i < attributeCount; ++i) {
            DGAttribute a = DGAttribute.createAttribute(this.fConstantPool, in, this.fLog);
            if (a instanceof DGLineNumberTable) {
                if (sRemoveLineNumbers) {
                    this.fTotalSize -= a.getLength();
                    continue;
                }
                this.fLineNumberTable = (DGLineNumberTable)a;
                this.fAttributes.add(a);
                continue;
            }
            if (a instanceof DGStackMapTable) {
                this.fStackMapTable = (DGStackMapTable)a;
                this.fAttributes.add(a);
                if (!DGStreamSingleCompiler.kIsVerificationDebugEnabled) continue;
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                DataOutputStream teststream = new DataOutputStream(buffer);
                this.fStackMapTable.writeContent(teststream);
                if (Arrays.equals(a.fAttribData, buffer.toByteArray())) continue;
                throw new DGClassLoadingException("Internal stackmap loading error.", (ILocalizableMessage)new FormattedLocalizableMessage("Diagnos_Exception_Compilation_Failed", "Stack Map Load Failure.", false));
            }
            this.fAttributes.add(a);
        }
        this.fInstrumentationDecider = InstrumentationDeciderFactory.getDecider();
    }

    public DGCode(DGConstantPool constantPool, int nameIndex, String name, int maxStack, int maxLocals, byte[] byteCode) {
        super(nameIndex, name, null);
        this.fLog = null;
        this.fMaxStack = maxStack;
        this.fMaxLocals = maxLocals;
        this.fDirty2 = false;
        this.fCode = byteCode;
        this.fAttributes = new Vector();
        this.fDirty = true;
        this.fExceptions = new DGExceptionEntry[0];
        this.fTotalSize = this.fCode.length + 2 + 2 + 4 + 2 + 2;
        this.fInstrumentationDecider = InstrumentationDeciderFactory.getDecider();
    }

    public void setMethod(DGMethod method) {
        this.fMethod = method;
    }

    public DGMethod getMethod() {
        return this.fMethod;
    }

    public DGConstantPool getConstantPool() {
        return this.fConstantPool;
    }

    public boolean isComplex() {
        this.fPC = 0;
        while (this.fPC < this.fCode.length) {
            int nextOpcode = this.readUnsignedByte();
            if (nextOpcode == 182 || nextOpcode == 183 || nextOpcode == 184 || nextOpcode == 185) {
                return true;
            }
            this.skipNextOpcode(nextOpcode);
        }
        return false;
    }

    @Override
    public void write(DataOutputStream out) throws IOException {
        if (!this.fDirty) {
            super.write(out);
            return;
        }
        if (this.fDirty2) {
            Iterator it = this.fAttributes.iterator();
            while (it.hasNext()) {
                DGAttribute a = (DGAttribute)it.next();
                if (!a.getName().equals("LocalVariableTypeTable") && !a.getName().equals("LocalVariableTable")) continue;
                this.fTotalSize -= a.getLength();
                it.remove();
            }
        }
        out.writeShort(this.fCPI_name);
        out.writeInt(this.fTotalSize);
        out.writeShort(this.fMaxStack);
        out.writeShort(this.fMaxLocals);
        out.writeInt(this.fCode.length);
        out.write(this.fCode);
        out.writeShort(this.fExceptions.length);
        for (int i = 0; i < this.fExceptions.length; ++i) {
            this.fExceptions[i].write(out);
        }
        int attribCount = this.fAttributes.size();
        out.writeShort(attribCount);
        for (DGAttribute a : this.fAttributes) {
            a.write(out);
        }
    }

    public int insertCode(byte[] javaCode) throws DGClassModificationException {
        return this.insertCode(0, javaCode, false, false);
    }

    public int addLocal() throws DGClassModificationException {
        this.fDirty2 = true;
        if (this.fMaxLocals >= 65535) {
            throw new DGClassModificationException(kMaxLocalsTooLarge, (ILocalizableMessage)new SimpleLocalizableMessage("Diagnos_Exception_Max_Locals_Too_Large"));
        }
        int newLocal = this.fMaxLocals++;
        return newLocal;
    }

    public void substituteClassAllocation(Integer[] cpiClassArray, int cpiSubstituteClass) throws DGClassModificationException {
        this.fPC = 0;
        while (this.fPC < this.fCode.length) {
            int nextOpcode = this.readUnsignedByte();
            this.substituteAllocation(nextOpcode, cpiClassArray, cpiSubstituteClass);
        }
    }

    public void bumpMaxStack(int increase) throws DGClassModificationException {
        this.fDirty2 = true;
        if (this.fMaxStack + increase > 65535) {
            throw new DGClassModificationException(kMaxStackTooLarge, (ILocalizableMessage)new SimpleLocalizableMessage("Diagnos_Exception_Max_Stack_Too_Large"));
        }
        this.fMaxStack += increase;
    }

    public void insertAtSocketWrite(String className, String methodName, String methodType, int secondParam) throws DGClassModificationException, IOException {
        int cpiMethod = this.fConstantPool.addMethodReferenceIfNecessary(className, methodName, methodType);
        SocketWriteStaticMethodCallByteCode codeToInsert = new SocketWriteStaticMethodCallByteCode(cpiMethod, secondParam);
        int[] insertPCs = this.findOpcodePCs(177, true);
        this.insertCodeAtPCs(insertPCs, codeToInsert.getByteCode(), false, true);
        this.bumpMaxStack(((DGByteCode)codeToInsert).getMaxStackSlotsUsed());
        this.fLog.ICompilerLog_logInsertOnMethod(this.fMethod, className + "." + methodName + methodType);
    }

    public void substituteResultForSocketRead(String className, String methodName) throws DGClassModificationException, IOException {
        String methodType_start = "(Ljava/lang/Object;)V";
        String methodType_end = "(ILjava/lang/Object;)I";
        methodName = "readStart";
        int afterSuper = this.findFirstInvokeSpecial();
        int cpiMethod1 = this.fConstantPool.addMethodReferenceIfNecessary(className, methodName, methodType_start);
        SocketReadStaticMethodCallByteCode codeToInsert = new SocketReadStaticMethodCallByteCode(cpiMethod1);
        this.insertCode(afterSuper, codeToInsert.getByteCode(), false, true);
        this.bumpMaxStack(((DGByteCode)codeToInsert).getMaxStackSlotsUsed());
        this.fLog.ICompilerLog_logInsertOnMethod(this.fMethod, className + "." + methodName + methodType_start);
        methodName = "readEnd";
        int[] insertPCs = this.findOpcodePCs(172, true);
        int cpiMethod2 = this.fConstantPool.addMethodReferenceIfNecessary(className, methodName, methodType_end);
        SocketReadStaticMethodCallByteCode codeToInsert_end = new SocketReadStaticMethodCallByteCode(cpiMethod2);
        this.insertCodeAtPCs(insertPCs, codeToInsert_end.getByteCode(), false, true);
        this.bumpMaxStack(((DGByteCode)codeToInsert_end).getMaxStackSlotsUsed());
        this.fLog.ICompilerLog_logInsertOnMethod(this.fMethod, className + "." + methodName + methodType_end);
    }

    public void substituteResultForSocketReadAlt(String className, String methodName) throws DGClassModificationException, IOException {
        String methodType = "(ILjava/lang/Object;)I";
        int[] insertPCs = this.findOpcodePCs(172, true);
        if (insertPCs.length == 0) {
            return;
        }
        int cpiMethod = this.fConstantPool.addMethodReferenceIfNecessary(className, methodName, methodType);
        SocketReadStaticMethodCallByteCode codeToInsert = new SocketReadStaticMethodCallByteCode(cpiMethod);
        this.insertCodeAtPCs(insertPCs, codeToInsert.getByteCode(), false, true);
        this.bumpMaxStack(((DGByteCode)codeToInsert).getMaxStackSlotsUsed());
        this.fLog.ICompilerLog_logInsertOnMethod(this.fMethod, className + methodName);
    }

    public void substituteObjrefResult(String className, String methodName, String methodType) throws DGClassModificationException, IOException {
        int[] insertPCs = this.findOpcodePCs(172, true);
        if (insertPCs.length == 0) {
            return;
        }
        int cpiMethod = this.fConstantPool.addMethodReferenceIfNecessary(className, methodName, methodType);
        this.insertStaticMethodCallAtPCs(insertPCs, cpiMethod, new int[0], false, false, true);
    }

    public void substituteResultByNamedProxy(ClassName agentEntryClass, String substituterMethod, String signature, String substituterName, String originalMethodReturnSignature, boolean canProvideSampleObject) throws DGClassModificationException, IOException {
        int[] insertPCs = this.findOpcodePCs(176, true);
        if (insertPCs.length == 0) {
            return;
        }
        int cpiMethod = this.fConstantPool.addMethodReferenceIfNecessary(agentEntryClass.getPackageAndNameString(), substituterMethod, signature);
        int[] cpiConstantPool = new int[]{this.fConstantPool.addStringIfNecessary(substituterName)};
        int cpiClassRef = this.fConstantPool.addClassReferenceIfNecessary(originalMethodReturnSignature);
        this.insertStaticMethodCallAtPCs(insertPCs, cpiMethod, cpiConstantPool, cpiClassRef, canProvideSampleObject, false, false, true);
    }

    public void substituteParamByNamedProxy(ClassName agentEntryClass, String substituterMethod, String signature, int paramIndex, String substituterName, String originalParamSignature, boolean canProvideSampleObject) throws DGClassModificationException, IOException {
        int cpiMethod = this.fConstantPool.addMethodReferenceIfNecessary(agentEntryClass.getPackageAndNameString(), substituterMethod, signature);
        int[] cpiConstantPool = new int[]{this.fConstantPool.addStringIfNecessary(substituterName)};
        int cpiClassRef = this.fConstantPool.addClassReferenceIfNecessary(originalParamSignature);
        int lineNumber = -1;
        if (this.fLineNumberTable != null) {
            lineNumber = this.fLineNumberTable.findLineNumber(0);
        }
        DGFieldMethodRefConstant constant = (DGFieldMethodRefConstant)this.fConstantPool.getConstant(cpiMethod);
        String fullyQualifiedMethodName = constant.getClassName() + "." + constant.getName();
        this.fLog.ICompilerLog_logInstrumentation(this.fMethod, lineNumber, fullyQualifiedMethodName);
        StaticMethodCallByteCodeForParameterSubstitution codeToInsert = new StaticMethodCallByteCodeForParameterSubstitution(cpiMethod, cpiConstantPool, cpiClassRef, this.fMethod.getDescriptor(), paramIndex, canProvideSampleObject);
        this.insertCode(0, codeToInsert.getByteCode(), false, true);
        this.bumpMaxStack(((DGByteCode)codeToInsert).getMaxStackSlotsUsed());
    }

    public void noticeFieldAssignments(ClassName agentEntryClass, IClassMatcher classesToNotice, ClassName eventNoticingClass) throws DGClassModificationException, IOException {
        ArrayList<Integer> pcsOfInterest = new ArrayList<Integer>();
        ArrayList<DGFieldMethodRefConstant> constantPoolEntriesOfInterest = new ArrayList<DGFieldMethodRefConstant>();
        this.fPC = 0;
        while (this.fPC < this.fCode.length) {
            int nextOpcode = this.readUnsignedByte();
            if (nextOpcode == 181 || nextOpcode == 179) {
                int pcOfPut = this.fPC - 1;
                int cpi = this.readUnsignedShort();
                DGFieldMethodRefConstant cpEntry = (DGFieldMethodRefConstant)this.fMethod.getDGClass().getConstantPool().getConstant(cpi);
                ClassName leftHandType = null;
                try {
                    String fieldType = cpEntry.getType();
                    ClassFileFieldDescriptor fieldDescriptor = ClassFileFieldDescriptor.getFieldDescriptor((String)fieldType);
                    if (fieldDescriptor.isNonArrayReference()) {
                        String fieldTypeClassName = fieldType.substring(1, fieldType.length() - 1);
                        leftHandType = ClassName.getClassName((String)fieldTypeClassName);
                    }
                }
                catch (Exception invalidSomethingOrOther) {
                    Assertion.wilyAssert((boolean)false);
                    return;
                }
                if (leftHandType == null || !classesToNotice.IClassMatcher_matches((IClassName)leftHandType)) continue;
                pcsOfInterest.add(pcOfPut);
                constantPoolEntriesOfInterest.add(cpEntry);
                continue;
            }
            this.skipNextOpcode(nextOpcode);
        }
        Iterator it = pcsOfInterest.iterator();
        int cumulativePCOffset = 0;
        for (int i = 0; i < pcsOfInterest.size(); ++i) {
            int pc = (Integer)pcsOfInterest.get(i);
            DGFieldMethodRefConstant cpEntry = (DGFieldMethodRefConstant)constantPoolEntriesOfInterest.get(i);
            int nextOpcode = this.fCode[pc += cumulativePCOffset] & 0xFF;
            Assertion.wilyAssert((nextOpcode == 179 || nextOpcode == 181 ? 1 : 0) != 0);
            DGByteCode beforeBC = nextOpcode == 179 ? new DupByteCode() : new DupX1ByteCode();
            String eventType = nextOpcode == 179 ? "Static_Field_Assignment" : "Instance_Field_Assignment";
            NoticeEventByteCode afterBC = new NoticeEventByteCode(this, eventType, cpEntry.getName(), cpEntry.getClassName(), agentEntryClass, eventNoticingClass);
            byte[] beforeCode = beforeBC.getByteCode();
            byte[] afterCode = afterBC.getByteCode();
            this.bumpMaxStack(beforeBC.getMaxStackSlotsUsed() + afterBC.getMaxStackSlotsUsed());
            this.fLog.ICompilerLog_logNoticeFieldAssignment(this.fMethod, cpEntry.getClassName(), cpEntry.getName(), (IClassName)eventNoticingClass);
            int beforeCodeLength = this.insertCode(pc, beforeCode, false, true);
            cumulativePCOffset += beforeCodeLength;
            int nextPC = pc + beforeCodeLength + 3;
            int afterCodeLength = this.insertCode(nextPC, afterCode, false, false);
            cumulativePCOffset += afterCodeLength;
        }
    }

    public void noticeObjectCreations(ClassName agentEntryClass, IClassMatcher classesToNotice, ClassName eventNoticingClass) throws DGClassModificationException, IOException {
        ArrayList<Integer> pcsOfInterest = new ArrayList<Integer>();
        ArrayList<DGFieldMethodRefConstant> constantPoolEntriesOfInterest = new ArrayList<DGFieldMethodRefConstant>();
        this.fPC = 0;
        while (this.fPC < this.fCode.length) {
            int nextOpcode = this.readUnsignedByte();
            if (nextOpcode == 183) {
                int pcOfInvokeSpecial = this.fPC - 1;
                int cpi = this.readUnsignedShort();
                DGFieldMethodRefConstant cpEntry = (DGFieldMethodRefConstant)this.fMethod.getDGClass().getConstantPool().getConstant(cpi);
                ClassName constructorCallClass = null;
                try {
                    constructorCallClass = ClassName.getClassName((String)cpEntry.getClassName());
                }
                catch (InvalidClassNameException icne) {
                    Assertion.wilyFail((String)icne.getMessage());
                    return;
                }
                if (!cpEntry.getName().equals("<init>") || !classesToNotice.IClassMatcher_matches((IClassName)constructorCallClass) || cpEntry.getClassName().equals(this.fMethod.getDGClass().getSuperClassQualifiedNameString()) && this.fMethod.getName().equals("<init>")) continue;
                pcsOfInterest.add(pcOfInvokeSpecial);
                constantPoolEntriesOfInterest.add(cpEntry);
                continue;
            }
            this.skipNextOpcode(nextOpcode);
        }
        Iterator it = pcsOfInterest.iterator();
        int cumulativePCOffset = 0;
        for (int i = 0; i < pcsOfInterest.size(); ++i) {
            int pc = (Integer)pcsOfInterest.get(i);
            DGFieldMethodRefConstant cpEntry = (DGFieldMethodRefConstant)constantPoolEntriesOfInterest.get(i);
            pc += cumulativePCOffset;
            StoreAwayStackByteCode beforeBC = new StoreAwayStackByteCode(this, cpEntry.getType());
            int[] localVarsForStack = beforeBC.getLocalVars();
            int localVarOfInitializedObject = localVarsForStack[localVarsForStack.length - 1];
            NoticeEventByteCode afterBC = new NoticeEventByteCode(this, "Object_Created", "", "", agentEntryClass, eventNoticingClass, localVarOfInitializedObject);
            byte[] beforeCode = beforeBC.getByteCode();
            byte[] afterCode = afterBC.getByteCode();
            this.bumpMaxStack(beforeBC.getMaxStackSlotsUsed() + afterBC.getMaxStackSlotsUsed());
            this.fLog.ICompilerLog_logNoticeObjectCreation(this.fMethod, cpEntry.getClassName(), (IClassName)eventNoticingClass);
            int beforeCodeLength = this.insertCode(pc, beforeCode, false, true);
            cumulativePCOffset += beforeCodeLength;
            int nextPC = pc + beforeCodeLength + 3;
            int afterCodeLength = this.insertCode(nextPC, afterCode, false, false);
            cumulativePCOffset += afterCodeLength;
        }
    }

    public List getInvocations() throws DGClassModificationException {
        ArrayList pcsOfInterest = new ArrayList();
        ArrayList constantPoolEntriesOfInterest = new ArrayList();
        ArrayList<DGFieldMethodRefConstant> result = new ArrayList<DGFieldMethodRefConstant>();
        this.fPC = 0;
        while (this.fPC < this.fCode.length) {
            try {
                int nextOpcode;
                block16: {
                    int cpi;
                    block15: {
                        nextOpcode = this.readUnsignedByte();
                        if (nextOpcode == 183) break block15;
                        if (nextOpcode == 184) break block15;
                        if (nextOpcode == 185) break block15;
                        if (nextOpcode != 182) break block16;
                    }
                    if ((cpi = this.readUnsignedShort()) > 0) {
                        try {
                            DGFieldMethodRefConstant cpEntry = (DGFieldMethodRefConstant)this.fMethod.getDGClass().getConstantPool().getConstant(cpi);
                            result.add(cpEntry);
                        }
                        catch (Throwable e) {
                            try {
                                this.fLog.ICompilerLog_logErrorMessage("Unable to get method calls for method " + this.fMethod.getMethodName().getNameAndSignatureString() + " in class " + this.fMethod.getDGClass().getClassName().getReflectionFriendlyQualifiedNameString() + "; fPc = " + this.fPC + ";opcode = " + nextOpcode + "; cpi = " + cpi);
                            }
                            catch (Throwable throwable) {}
                        }
                        continue;
                    }
                    try {
                        this.fLog.ICompilerLog_logErrorMessage("Unable to get method calls for method " + this.fMethod.getMethodName().getNameAndSignatureString() + " in class " + this.fMethod.getDGClass().getClassName().getReflectionFriendlyQualifiedNameString() + "; fPc = " + this.fPC + ";opcode = " + nextOpcode + "; cpi = " + cpi);
                    }
                    catch (Throwable throwable) {}
                    continue;
                }
                this.skipNextOpcode(nextOpcode);
            }
            catch (Throwable r) {
                try {
                    this.fLog.ICompilerLog_logErrorMessage("Unable to get method calls for method " + this.fMethod.getMethodName().getNameAndSignatureString() + " in class " + this.fMethod.getDGClass().getClassName().getReflectionFriendlyQualifiedNameString() + "; fPc = " + this.fPC);
                }
                catch (Throwable throwable) {}
                break;
            }
        }
        return result;
    }

    public void insertStaticMethodCallAtConstructorFinish(String className, String methodName, String methodType) throws DGClassModificationException, IOException {
        int[] insertPCs = this.findOpcodePCs(177, true);
        if (insertPCs.length == 0) {
            return;
        }
        int cpiMethod = this.fConstantPool.addMethodReferenceIfNecessary(className, methodName, methodType);
        int localVarForThis = this.addLocal();
        LoadLocalObjectAndInvokeStaticMethodByteCode call = new LoadLocalObjectAndInvokeStaticMethodByteCode(cpiMethod, localVarForThis);
        this.insertCodeAtPCs(insertPCs, call.getByteCode(), false, true);
        SaveThisByteCode saveThis = new SaveThisByteCode(localVarForThis);
        this.insertCode(saveThis.getByteCode());
        if (this.fStackMapTable != null) {
            this.fTotalSize += this.fStackMapTable.addLocalVariables(0, 0, saveThis, this.fMethod);
        }
    }

    public void insertStaticMethodCallAtOpcode(int opcode, int cpiMethod, int[] cpiParams, boolean passStackTopAsParam) throws DGClassModificationException, IOException {
        int[] insertPCs = this.findOpcodePCs(opcode, true);
        if (insertPCs.length == 0) {
            return;
        }
        this.insertStaticMethodCallAtPCs(insertPCs, cpiMethod, cpiParams, passStackTopAsParam, false, true);
    }

    private int findFirstInvokeSpecial() {
        int newcounter = 0;
        this.fPC = 0;
        while (this.fPC < this.fCode.length) {
            int nextOpcode = this.readUnsignedByte();
            if (nextOpcode == 183) {
                this.readUnsignedShort();
                if (newcounter == 0) {
                    return this.fPC;
                }
                --newcounter;
                continue;
            }
            if (nextOpcode == 187) {
                ++newcounter;
            }
            this.skipNextOpcode(nextOpcode);
        }
        return 0;
    }

    public void setMethodTracer(IJavaMethodTracerInstance tracerInst) throws DGClassModificationException, IOException {
        boolean isInstanceConstructor = this.getMethod().isInstanceConstructor();
        if (isInstanceConstructor && !sConstructorInstrumentation) {
            throw new DGMethodSkippedException(kConstructorSkipped);
        }
        int afterSuper = this.findFirstInvokeSpecial();
        DGByteCode creationCode = tracerInst.IMethodTracerInstance_getBeginByteCode();
        int constructorCodeLength = 0;
        constructorCodeLength = !isInstanceConstructor || !sConstructorInstrumentationPartial ? this.insertCode(creationCode.getByteCode()) : this.insertCode(afterSuper, creationCode.getByteCode(), false, false);
        DGByteCode stubbingCode = tracerInst.IMethodTracerInstance_getStubbingCode();
        this.fTotalSize += this.checkIfStackMapTableNeeded();
        if (stubbingCode != null) {
            this.insertCode(constructorCodeLength, stubbingCode.getByteCode(), true, true);
            if (this.fStackMapTable != null) {
                int catchPC = constructorCodeLength + stubbingCode.getByteCode().length;
                this.fTotalSize += this.fStackMapTable.addSameFrame(catchPC);
            }
        }
        int newTryBegin = afterSuper + constructorCodeLength;
        int trySuperStart = constructorCodeLength;
        int exitCodeMaxStackSlotUsed = 0;
        exitCodeMaxStackSlotUsed = Math.max(exitCodeMaxStackSlotUsed, this.insertMethodExitByteCode(177, tracerInst));
        exitCodeMaxStackSlotUsed = Math.max(exitCodeMaxStackSlotUsed, this.insertMethodExitByteCode(172, tracerInst));
        exitCodeMaxStackSlotUsed = Math.max(exitCodeMaxStackSlotUsed, this.insertMethodExitByteCode(174, tracerInst));
        exitCodeMaxStackSlotUsed = Math.max(exitCodeMaxStackSlotUsed, this.insertMethodExitByteCode(176, tracerInst));
        exitCodeMaxStackSlotUsed = Math.max(exitCodeMaxStackSlotUsed, this.insertMethodExitByteCode(173, tracerInst));
        exitCodeMaxStackSlotUsed = Math.max(exitCodeMaxStackSlotUsed, this.insertMethodExitByteCode(175, tracerInst));
        if (!isInstanceConstructor) {
            int catchPC = this.fCode.length;
            DGByteCode catchCode = tracerInst.IMethodTracerInstance_getCatchByteCode();
            this.insertCode(catchPC, catchCode.getByteCode(), true, true);
            DGExceptionEntry[] exceptions = new DGExceptionEntry[this.fExceptions.length + 1];
            System.arraycopy(this.fExceptions, 0, exceptions, 0, this.fExceptions.length);
            exceptions[exceptions.length - 1] = new DGExceptionEntry(constructorCodeLength, catchPC);
            this.fExceptions = exceptions;
            if (this.fStackMapTable != null) {
                this.fTotalSize += this.fStackMapTable.addCatchClauseFrame(catchPC, this.getMethod(), false);
            }
            this.bumpMaxStack(creationCode.getMaxStackSlotsUsed() + catchCode.getMaxStackSlotsUsed() + exitCodeMaxStackSlotUsed);
            this.fTotalSize += 8;
        } else {
            int tryStartForBody;
            DGByteCode catchCode = tracerInst.IMethodTracerInstance_getCatchByteCode();
            int numExceptions = 0;
            afterSuper = this.findFirstInvokeSpecial();
            int catch1PC = this.fCode.length;
            boolean catchSuper = !sConstructorInstrumentationPartial;
            boolean superFound = afterSuper > 0;
            boolean bodyFound = afterSuper < catch1PC;
            int offset = 0;
            int trySuperEnd = afterSuper;
            if (superFound && catchSuper) {
                this.insertCode(afterSuper, catchCode.getByteCode(), true, true);
                offset = catchCode.getByteCode().length + 4;
                GotoByteCode gb = new GotoByteCode(offset);
                this.insertCode(afterSuper, gb.getByteCode(), true, true);
                ++numExceptions;
            }
            int catch2PC = this.fCode.length;
            int n = tryStartForBody = sConstructorInstrumentationPartial ? newTryBegin : afterSuper + offset;
            if (bodyFound) {
                this.insertCode(catch2PC, catchCode.getByteCode(), true, true);
                ++numExceptions;
            }
            DGExceptionEntry[] exceptions = new DGExceptionEntry[this.fExceptions.length + numExceptions];
            System.arraycopy(this.fExceptions, 0, exceptions, 0, this.fExceptions.length);
            if (superFound && catchSuper) {
                exceptions[exceptions.length - numExceptions] = new DGExceptionEntry(trySuperStart, trySuperEnd, trySuperEnd + 3);
                this.fTotalSize += 8;
            }
            if (bodyFound) {
                exceptions[exceptions.length - 1] = new DGExceptionEntry(tryStartForBody, catch2PC, catch2PC);
                this.fTotalSize += 8;
            }
            this.fExceptions = exceptions;
            if (this.fStackMapTable != null) {
                if (superFound && catchSuper) {
                    this.fTotalSize += this.fStackMapTable.addCatchClauseFrameForSuper(afterSuper + 3, this.getMethod());
                    this.fTotalSize += this.fStackMapTable.addFrameForSuperJump(afterSuper + offset, this.getMethod());
                }
                if (bodyFound) {
                    this.fTotalSize += this.fStackMapTable.addCatchClauseFrame(catch2PC, this.getMethod(), false);
                }
            }
            this.bumpMaxStack(creationCode.getMaxStackSlotsUsed() + catchCode.getMaxStackSlotsUsed() + exitCodeMaxStackSlotUsed);
        }
        if (this.fStackMapTable != null) {
            this.fTotalSize = !isInstanceConstructor || !sConstructorInstrumentationPartial ? (this.fTotalSize += this.fStackMapTable.addLocalVariables(0, afterSuper, creationCode, this.fMethod)) : (this.fTotalSize += this.fStackMapTable.addLocalVariables(afterSuper, afterSuper, creationCode, this.fMethod));
        }
    }

    private boolean isStackMapTableNeeded() {
        return this.getMethod().getDGClass().getMajorVersion() >= 50;
    }

    int checkIfStackMapTableNeeded() throws DGClassModificationException {
        if (this.fStackMapTable != null) {
            return 0;
        }
        if (this.isStackMapTableNeeded()) {
            this.fStackMapTable = new DGStackMapTable(this.getMethod().getConstantPool());
            this.fAttributes.add(this.fStackMapTable);
            return 8;
        }
        return 0;
    }

    private int insertMethodExitByteCode(int opcode, IJavaMethodTracerInstance tracerInst) throws DGClassModificationException, IOException {
        int[] insertPCs = this.findOpcodePCs(opcode, true);
        int maxBumpMaxStack = 0;
        for (int i = 0; i < insertPCs.length; ++i) {
            DGByteCode methodExitByteCode = tracerInst.IMethodTracerInstance_getMethodExitByteCode(opcode);
            int requestedSlots = methodExitByteCode.getMaxStackSlotsUsed();
            maxBumpMaxStack = Math.max(maxBumpMaxStack, requestedSlots);
            int codeLength = this.insertCode(insertPCs[i], methodExitByteCode.getByteCode(), true, true);
            for (int j = i + 1; j < insertPCs.length; ++j) {
                if (insertPCs[j] <= insertPCs[i]) continue;
                int n = j;
                insertPCs[n] = insertPCs[n] + codeLength;
            }
        }
        return maxBumpMaxStack;
    }

    public void insertStaticMethodCallAtCatch(int cpiMethod, int[] cpiParams) throws DGClassModificationException, IOException {
        int[] handlerPC = new int[1];
        boolean frameConversion = true;
        for (int i = 0; i < this.fExceptions.length; ++i) {
            handlerPC[0] = this.fCode.length;
            this.insertStaticMethodCallAtPCs(handlerPC, cpiMethod, cpiParams, true, false, true);
            int offset = this.fExceptions[i].getHandlerPC() - this.fCode.length;
            GotoByteCode code = new GotoByteCode(offset);
            this.bumpMaxStack(code.getMaxStackSlotsUsed());
            byte[] jumpToHandlerCode = code.getByteCode();
            this.insertCode(this.fCode.length, jumpToHandlerCode, false, true);
            this.fTotalSize += this.checkIfStackMapTableNeeded();
            if (this.fStackMapTable != null) {
                this.fTotalSize += this.fStackMapTable.addStackMapFrame(handlerPC[0], this.getMethod(), this.fExceptions[i].getHandlerPC(), frameConversion);
                frameConversion = false;
            }
            this.fExceptions[i].setHandlerPC(handlerPC[0]);
        }
    }

    private void insertStaticMethodCallAtPCs(int[] insertPCs, int cpiMethod, int[] cpiParams, boolean passStackTopAsParam, boolean includeInCatchStatement, boolean insertAsStartOfBasicBlock) throws DGClassModificationException, IOException {
        for (int i = 0; i < insertPCs.length; ++i) {
            int lineNumber = -1;
            if (this.fLineNumberTable != null) {
                lineNumber = this.fLineNumberTable.findLineNumber(insertPCs[i]);
            }
            DGFieldMethodRefConstant constant = (DGFieldMethodRefConstant)this.fConstantPool.getConstant(cpiMethod);
            String fullyQualifiedMethodName = constant.getClassName() + "." + constant.getName();
            this.fLog.ICompilerLog_logInstrumentation(this.fMethod, lineNumber, fullyQualifiedMethodName);
        }
        StaticMethodCallByteCode codeToInsert = new StaticMethodCallByteCode(cpiMethod, cpiParams, passStackTopAsParam);
        this.insertCodeAtPCs(insertPCs, codeToInsert.getByteCode(), includeInCatchStatement, insertAsStartOfBasicBlock);
        this.bumpMaxStack(((DGByteCode)codeToInsert).getMaxStackSlotsUsed());
    }

    private void insertStaticMethodCallAtPCs(int[] insertPCs, int cpiMethod, int[] cpiParams, int cpiResultCast, boolean canProvideSampleObject, boolean passStackTopAsParam, boolean includeInCatchStatement, boolean insertAsStartOfBasicBlock) throws DGClassModificationException, IOException {
        for (int i = 0; i < insertPCs.length; ++i) {
            int lineNumber = -1;
            if (this.fLineNumberTable != null) {
                lineNumber = this.fLineNumberTable.findLineNumber(insertPCs[i]);
            }
            DGFieldMethodRefConstant constant = (DGFieldMethodRefConstant)this.fConstantPool.getConstant(cpiMethod);
            String fullyQualifiedMethodName = constant.getClassName() + "." + constant.getName();
            this.fLog.ICompilerLog_logInstrumentation(this.fMethod, lineNumber, fullyQualifiedMethodName);
        }
        StaticMethodCallByteCodeWithCastResult codeToInsert = new StaticMethodCallByteCodeWithCastResult(cpiMethod, cpiParams, cpiResultCast, canProvideSampleObject, passStackTopAsParam);
        this.insertCodeAtPCs(insertPCs, codeToInsert.getByteCode(), includeInCatchStatement, insertAsStartOfBasicBlock);
        this.bumpMaxStack(((DGByteCode)codeToInsert).getMaxStackSlotsUsed());
    }

    private int insertCodeAtPCs(int[] insertPCs, byte[] codeToInsert, boolean includeInCatchStatement, boolean insertAsStartOfBasicBlock) throws DGClassModificationException, IOException {
        int codeLength = 0;
        for (int i = 0; i < insertPCs.length; ++i) {
            codeLength = this.insertCode(insertPCs[i], codeToInsert, includeInCatchStatement, insertAsStartOfBasicBlock);
            for (int j = i + 1; j < insertPCs.length; ++j) {
                if (insertPCs[j] <= insertPCs[i]) continue;
                int n = j;
                insertPCs[n] = insertPCs[n] + codeLength;
            }
        }
        return codeLength;
    }

    int insertCode(int pc, byte[] insertCode, boolean includeInCatchStatement, boolean insertAsStartOfBasicBlock) throws DGClassModificationException {
        this.fDirty = true;
        this.fDirty2 = true;
        int codeLength = insertCode.length;
        if (pc < this.fCode.length) {
            while (codeLength % 4 != 0) {
                ++codeLength;
            }
        }
        this.fTotalSize += codeLength;
        if (this.fCode.length + codeLength > 65535) {
            throw new DGClassModificationException(kMethodTooLong, (ILocalizableMessage)new SimpleLocalizableMessage("Diagnos_Exception_Method_Too_Long"));
        }
        byte[] newCode = new byte[this.fCode.length + codeLength];
        System.arraycopy(this.fCode, 0, newCode, 0, pc);
        System.arraycopy(insertCode, 0, newCode, pc, insertCode.length);
        System.arraycopy(this.fCode, pc, newCode, pc + codeLength, this.fCode.length - pc);
        this.fCode = newCode;
        for (int i = 0; i < this.fExceptions.length; ++i) {
            this.fExceptions[i].insertCode(pc, codeLength, includeInCatchStatement);
        }
        this.fPC = 0;
        while (this.fPC < this.fCode.length) {
            int nextOpcode = this.readUnsignedByte();
            this.fixJumpInstruction(nextOpcode, pc, codeLength, insertAsStartOfBasicBlock);
        }
        if (this.fStackMapTable != null) {
            this.fTotalSize += this.fStackMapTable.insertCode(pc, codeLength, insertAsStartOfBasicBlock);
        }
        if (this.fLineNumberTable != null) {
            this.fLineNumberTable.insertCode(pc, codeLength);
        }
        return codeLength;
    }

    public void widenJumpOffsets(int minOffsetToWiden) throws DGClassModificationException {
        int i;
        if (this.fCode.length < minOffsetToWiden) {
            return;
        }
        ArrayList<Integer> pcList = new ArrayList<Integer>();
        ArrayList<Integer> absOffsetList = new ArrayList<Integer>();
        this.fPC = 0;
        block5: while (this.fPC < this.fCode.length) {
            int nextOpcode = this.readUnsignedByte();
            switch (nextOpcode) {
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: 
                case 167: 
                case 168: 
                case 198: 
                case 199: {
                    int i2;
                    int offset = this.readShort();
                    int absOffset = Math.abs(offset);
                    if (absOffset < minOffsetToWiden) continue block5;
                    for (i2 = 0; i2 < absOffsetList.size() && absOffset < (Integer)absOffsetList.get(i2); ++i2) {
                    }
                    pcList.add(i2, this.fPC - 3);
                    absOffsetList.add(i2, absOffset);
                    continue block5;
                }
            }
            this.skipNextOpcode(nextOpcode);
        }
        int numWidenings = pcList.size();
        if (numWidenings == 0) {
            return;
        }
        int[] pcArray = new int[numWidenings];
        for (i = 0; i < numWidenings; ++i) {
            pcArray[i] = (Integer)pcList.get(i);
        }
        try {
            for (i = 0; i < numWidenings; ++i) {
                int curPC = pcArray[i];
                int bytesAdded = this.widenJumpOffset(curPC);
                for (int j = i + 1; j < numWidenings; ++j) {
                    if (pcArray[j] <= curPC) continue;
                    int n = j;
                    pcArray[n] = pcArray[n] + bytesAdded;
                }
            }
        }
        catch (DGClassModificationException cme) {
            throw new DGClassModificationException(kClassModificationExceptionWhileWideningJumpOffsets + cme.getMessage(), (ILocalizableMessage)new CompoundLocalizableMessage((ILocalizableMessage)new SimpleLocalizableMessage("Diagnos_Exception_Exception_Occurred_While_Widening_Jumps"), (ILocalizableMessage)new LocalizedMessage(cme.getLocalizedMessage())));
        }
    }

    private int widenJumpOffset(int jumpPC) throws DGClassModificationException {
        this.fPC = jumpPC;
        this.fDirty2 = true;
        int opcode = this.readUnsignedByte();
        switch (opcode) {
            case 167: {
                return this.widenOffset(200);
            }
            case 168: {
                return this.widenOffset(201);
            }
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 198: 
            case 199: {
                if (this.isStackMapTableNeeded()) {
                    this.fCannotWidenJumpOffset = true;
                    return 0;
                }
                opcode = DGCode.getNegatedConditionalOpcode(opcode);
                this.fCode[this.fPC - 1] = (byte)opcode;
                int originalOffset = this.readShort();
                int labelOffset = 3;
                this.fCode[this.fPC - 2] = (byte)(labelOffset >> 8);
                this.fCode[this.fPC - 1] = (byte)(labelOffset & 0xFF);
                byte[] goto_wCode = new byte[]{-56, 0, 0, 0, 0};
                int goto_wPC = this.fPC;
                int bytesInserted = this.insertCode(this.fPC, goto_wCode, false, false);
                if (originalOffset > 0) {
                    originalOffset += bytesInserted - 3;
                } else if (originalOffset < 0) {
                    originalOffset -= 3;
                } else {
                    throw new DGClassModificationException(kZeroJumpOffsetFound, (ILocalizableMessage)new SimpleLocalizableMessage("Diagnos_Exception_Zero_Jump_Offset_Found"));
                }
                this.fCode[goto_wPC + 1] = (byte)(originalOffset >> 24);
                this.fCode[goto_wPC + 2] = (byte)(originalOffset >> 16);
                this.fCode[goto_wPC + 3] = (byte)(originalOffset >> 8);
                this.fCode[goto_wPC + 4] = (byte)(originalOffset & 0xFF);
                return bytesInserted;
            }
        }
        Assertion.wilyAssert((boolean)false, (String)("widenJumpOffset: invalid opcode read: " + opcode));
        return 0;
    }

    private int widenOffset(int newJumpOpCode) throws DGClassModificationException {
        this.fCode[this.fPC - 1] = 0;
        int offset = this.readShort();
        this.fCode[this.fPC - 2] = 0;
        this.fCode[this.fPC - 1] = (byte)newJumpOpCode;
        byte[] newOffSetBytes = new byte[]{(byte)((offset -= 2) >> 24), (byte)(offset >> 16), (byte)(offset >> 8), (byte)(offset & 0xFF)};
        return this.insertCode(this.fPC, newOffSetBytes, false, false);
    }

    public static int getNegatedConditionalOpcode(int opcode) throws DGClassModificationException {
        switch (opcode) {
            case 165: {
                return 166;
            }
            case 166: {
                return 165;
            }
            case 159: {
                return 160;
            }
            case 160: {
                return 159;
            }
            case 164: {
                return 163;
            }
            case 161: {
                return 162;
            }
            case 162: {
                return 161;
            }
            case 163: {
                return 164;
            }
            case 153: {
                return 154;
            }
            case 154: {
                return 153;
            }
            case 158: {
                return 157;
            }
            case 155: {
                return 156;
            }
            case 156: {
                return 155;
            }
            case 157: {
                return 158;
            }
            case 199: {
                return 198;
            }
            case 198: {
                return 199;
            }
        }
        throw new DGClassModificationException(kConditionalOpcodeExpected, (ILocalizableMessage)new SimpleLocalizableMessage("Diagnos_Exception_Conditional_Opcode_Expected"));
    }

    @Override
    public void adjustConstantPoolIndices(int base, int delta) throws DGClassModificationException {
        super.adjustConstantPoolIndices(base, delta);
        for (DGAttribute a : this.fAttributes) {
            a.adjustConstantPoolIndices(base, delta);
        }
        for (int i = 0; i < this.fExceptions.length; ++i) {
            this.fExceptions[i].adjustConstantPoolIndices(base, delta);
        }
        this.fDirty = true;
        this.fPC = 0;
        while (this.fPC < this.fCode.length) {
            int nextOpcode = this.readUnsignedByte();
            if (nextOpcode > 201) {
                Assertion.wilyAssert((String)"Parse Error");
            }
            this.fixConstantPoolIndex(nextOpcode, base, delta);
        }
    }

    private int[] findOpcodePCs(int matchOpcode, boolean insertBefore) {
        int[] hits = new int[this.fCode.length];
        int hitCount = 0;
        int hitPC = 0;
        while ((hitPC = this.findOpcodePC(matchOpcode, insertBefore, hitPC)) != -1) {
            hits[hitCount++] = hitPC;
            if (!insertBefore) continue;
            this.fPC = hitPC;
            int opcode = this.readUnsignedByte();
            this.skipNextOpcode(opcode);
            hitPC = this.fPC;
        }
        int[] returnValue = new int[hitCount];
        System.arraycopy(hits, 0, returnValue, 0, hitCount);
        return returnValue;
    }

    private int findOpcodePC(int opcode, boolean insertBefore, int startPC) {
        this.fPC = startPC;
        while (this.fPC < this.fCode.length) {
            int nextOpcode = this.readUnsignedByte();
            if (nextOpcode == opcode) {
                if (!insertBefore) {
                    this.skipNextOpcode(nextOpcode);
                    return this.fPC;
                }
                return this.fPC - 1;
            }
            this.skipNextOpcode(nextOpcode);
        }
        return -1;
    }

    private void replaceOpcode(int opcode, int replaceOpcode) {
        this.fDirty2 = true;
        this.fPC = 0;
        while (this.fPC < this.fCode.length) {
            int nextOpcode = this.readUnsignedByte();
            if (nextOpcode == opcode) {
                this.fCode[this.fPC - 1] = (byte)replaceOpcode;
            }
            this.skipNextOpcode(nextOpcode);
        }
    }

    private void substituteAllocation(int opcode, Integer[] cpiClassArray, int cpiSubstituteClass) throws DGClassModificationException {
        switch (opcode) {
            case 187: {
                boolean changed = this.replaceNextCPI(cpiClassArray, cpiSubstituteClass);
                if (!changed) break;
                int lineNumber = -1;
                if (this.fLineNumberTable != null) {
                    lineNumber = this.fLineNumberTable.findLineNumber(this.fPC);
                }
                String originalClassName = ((DGClassConstant)this.fConstantPool.getConstant(cpiClassArray[0])).getClassNameString();
                String substituteClassName = ((DGClassConstant)this.fConstantPool.getConstant(cpiSubstituteClass)).getClassNameString();
                this.fLog.ICompilerLog_logClassSubstitution(this.fMethod, lineNumber, originalClassName, substituteClassName);
                break;
            }
            case 183: {
                this.replaceNextConstructorInvocation(cpiClassArray, cpiSubstituteClass);
                break;
            }
            default: {
                this.skipNextOpcode(opcode);
            }
        }
    }

    private void fixConstantPoolIndex(int opcode, int cpiBase, int cpiDelta) throws DGClassModificationException {
        switch (opcode) {
            case 18: {
                int cpi = this.readUnsignedByte();
                if (cpi <= cpiBase) break;
                if ((cpi += cpiDelta) > 255) {
                    throw new DGClassModificationException(kWideningConstantIndicesNotSupported, (ILocalizableMessage)new SimpleLocalizableMessage("Diagnos_Exception_Constant_Index_Widening_Not_Supported"));
                }
                this.fCode[this.fPC - 1] = (byte)cpi;
                break;
            }
            case 17: 
            case 19: 
            case 20: 
            case 132: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 187: 
            case 189: 
            case 192: 
            case 193: {
                this.adjustNextCPI(cpiBase, cpiDelta);
                break;
            }
            case 197: {
                this.adjustNextCPI(cpiBase, cpiDelta);
                ++this.fPC;
                break;
            }
            case 185: {
                this.adjustNextCPI(cpiBase, cpiDelta);
                while (this.readUnsignedByte() != 0) {
                }
                break;
            }
            default: {
                this.skipNextOpcode(opcode);
            }
        }
    }

    private void fixJumpInstruction(int opcode, int insertPC, int insertCodeLength, boolean insertAsStartOfBasicBlock) throws DGClassModificationException {
        switch (opcode) {
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 198: 
            case 199: {
                this.adjustNextJumpDelta(this.fPC - 1, insertPC, insertCodeLength, insertAsStartOfBasicBlock);
                break;
            }
            case 200: 
            case 201: {
                this.adjustNextWideJumpDelta(this.fPC - 1, insertPC, insertCodeLength, insertAsStartOfBasicBlock);
                break;
            }
            case 171: {
                int basePC = this.fPC - 1;
                while (this.fPC % 4 != 0) {
                    ++this.fPC;
                }
                this.adjustNextWideJumpDelta(basePC, insertPC, insertCodeLength, insertAsStartOfBasicBlock);
                int numPairs = this.readInt();
                for (int i = 0; i < numPairs; ++i) {
                    this.fPC += 4;
                    this.adjustNextWideJumpDelta(basePC, insertPC, insertCodeLength, insertAsStartOfBasicBlock);
                }
                break;
            }
            case 170: {
                int basePC2 = this.fPC - 1;
                while (this.fPC % 4 != 0) {
                    ++this.fPC;
                }
                this.adjustNextWideJumpDelta(basePC2, insertPC, insertCodeLength, insertAsStartOfBasicBlock);
                int lowByte = this.readInt();
                int highByte = this.readInt();
                for (int i = lowByte; i <= highByte; ++i) {
                    this.adjustNextWideJumpDelta(basePC2, insertPC, insertCodeLength, insertAsStartOfBasicBlock);
                }
                break;
            }
            default: {
                this.skipNextOpcode(opcode);
            }
        }
    }

    private void skipNextOpcode(int opcode) {
        switch (opcode) {
            case 16: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 169: 
            case 209: {
                ++this.fPC;
                break;
            }
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 198: 
            case 199: 
            case 210: {
                this.fPC += 2;
                break;
            }
            case 200: 
            case 201: 
            case 212: {
                this.fPC += 4;
                break;
            }
            case 18: {
                ++this.fPC;
                break;
            }
            case 17: 
            case 19: 
            case 20: 
            case 132: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 187: 
            case 189: 
            case 192: 
            case 193: {
                this.fPC += 2;
                break;
            }
            case 197: {
                this.fPC += 3;
                break;
            }
            case 185: {
                this.fPC += 2;
                while (this.readUnsignedByte() != 0) {
                }
                break;
            }
            case 186: {
                this.fPC += 4;
                break;
            }
            case 171: {
                while (this.fPC % 4 != 0) {
                    ++this.fPC;
                }
                this.fPC += 4;
                int numPairs = this.readInt();
                this.fPC += numPairs * 8;
                break;
            }
            case 170: {
                while (this.fPC % 4 != 0) {
                    ++this.fPC;
                }
                this.fPC += 4;
                int lowByte = this.readInt();
                int highByte = this.readInt();
                this.fPC += (highByte - lowByte + 1) * 4;
                break;
            }
            case 196: {
                int nextop = this.readUnsignedByte();
                if (nextop == 132) {
                    this.fPC += 4;
                    break;
                }
                this.fPC += 2;
            }
        }
    }

    private void adjustNextCPI(int base, int delta) {
        int nextShort = this.readUnsignedShort();
        if (nextShort > base) {
            this.fCode[this.fPC - 2] = (byte)((nextShort += delta) >> 8);
            this.fCode[this.fPC - 1] = (byte)(nextShort & 0xFF);
        }
    }

    private boolean replaceNextCPI(Integer[] cpiArray, int substituteIndex) {
        int nextShort = this.readUnsignedShort();
        Integer[] integerArray = cpiArray;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int index = integerArray[i];
            if (nextShort != index) continue;
            this.fDirty = true;
            this.fCode[this.fPC - 2] = (byte)(substituteIndex >> 8);
            this.fCode[this.fPC - 1] = (byte)(substituteIndex & 0xFF);
            return true;
        }
        return false;
    }

    private void replaceNextConstructorInvocation(Integer[] cpiClassArray, int cpiSubstituteClass) throws DGClassModificationException {
        int cpiMethodRef = this.readUnsignedShort();
        DGFieldMethodRefConstant c = (DGFieldMethodRefConstant)this.fConstantPool.getConstant(cpiMethodRef);
        boolean classMatches = false;
        Integer[] integerArray = cpiClassArray;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int index = integerArray[i];
            if (c.getClassCPI() != index) continue;
            classMatches = true;
            break;
        }
        if (!classMatches) {
            return;
        }
        if (!c.getName().equals("<init>")) {
            return;
        }
        this.fDirty = true;
        int cpiNameAndType = c.getNameAndTypeCPI();
        int cpiSubstMethodRef = this.fConstantPool.addMethodReference(cpiSubstituteClass, cpiNameAndType);
        this.fCode[this.fPC - 2] = (byte)(cpiSubstMethodRef >> 8);
        this.fCode[this.fPC - 1] = (byte)(cpiSubstMethodRef & 0xFF);
    }

    private void adjustNextJumpDelta(int basePC, int insertPC, int insertCodeLength, boolean insertAsStartOfBasicBlock) throws DGClassModificationException {
        int delta = this.readShort();
        if ((delta = this.adjustJumpDeltaCommon(delta, basePC, insertPC, insertCodeLength, insertAsStartOfBasicBlock)) == 0) {
            return;
        }
        if (delta < Short.MIN_VALUE || delta >= 32768) {
            if (this.fCannotWidenJumpOffset) {
                throw new DGClassModificationException(kWideningJumpsWithStackMapNotSupported, (ILocalizableMessage)new SimpleLocalizableMessage("Diagnos_Exception_Jump_Widening_With_StackMap_Not_Supported"));
            }
            throw new DGClassModificationException(kWideningJumpsWhileInstrumentingNotSupported, (ILocalizableMessage)new SimpleLocalizableMessage("Diagnos_Exception_Jump_Widening_While_Instrumenting_Not_Supported"));
        }
        this.fCode[this.fPC - 2] = (byte)(delta >> 8);
        this.fCode[this.fPC - 1] = (byte)(delta & 0xFF);
    }

    private void adjustNextWideJumpDelta(int basePC, int insertPC, int insertCodeLength, boolean insertAsStartOfBasicBlock) {
        int delta = this.readInt();
        if ((delta = this.adjustJumpDeltaCommon(delta, basePC, insertPC, insertCodeLength, insertAsStartOfBasicBlock)) == 0) {
            return;
        }
        this.fCode[this.fPC - 4] = (byte)(delta >> 24);
        this.fCode[this.fPC - 3] = (byte)(delta >> 16);
        this.fCode[this.fPC - 2] = (byte)(delta >> 8);
        this.fCode[this.fPC - 1] = (byte)(delta & 0xFF);
    }

    private int adjustJumpDeltaCommon(int delta, int basePC, int insertPC, int insertCodeLength, boolean insertAsStartOfBasicBlock) {
        if (basePC < insertPC && (basePC + delta > insertPC || basePC + delta == insertPC && !insertAsStartOfBasicBlock)) {
            delta += insertCodeLength;
        } else if (basePC >= insertPC + insertCodeLength && (basePC + delta < insertPC + insertCodeLength || basePC + delta == insertPC + insertCodeLength && insertAsStartOfBasicBlock)) {
            delta -= insertCodeLength;
        } else {
            return 0;
        }
        if (basePC + delta < 0 || basePC + delta > this.fCode.length) {
            String error = "Wide Jump Offset Error: new PC = " + (basePC + delta) + ", jump delta = " + delta + ", insert PC = " + insertPC + ", base PC = " + basePC + ", insert code length = " + insertCodeLength + ", length = " + this.fCode.length;
            Assertion.wilyAssert((String)error);
            int lineNumber = -1;
            if (this.fLineNumberTable != null) {
                lineNumber = this.fLineNumberTable.findLineNumber(insertPC);
            }
            this.fLog.ICompilerLog_logInternalError(this.fMethod, lineNumber, error);
        }
        return delta;
    }

    private int readUnsignedByte() {
        return this.fCode[this.fPC++] & 0xFF;
    }

    private int readUnsignedShort() {
        int nextShort = this.fCode[this.fPC++];
        nextShort = nextShort << 8 | this.readUnsignedByte();
        return nextShort & 0xFFFF;
    }

    private int readShort() {
        int highByte = this.fCode[this.fPC++] << 8;
        int lowByte = this.readUnsignedByte();
        return highByte + lowByte;
    }

    private int readInt() {
        int nextInt = this.fCode[this.fPC++];
        nextInt = nextInt << 8 | this.readUnsignedByte();
        nextInt = nextInt << 8 | this.readUnsignedByte();
        nextInt = nextInt << 8 | this.readUnsignedByte();
        return nextInt;
    }

    public boolean isDirty() {
        return this.fDirty2;
    }

    public void debug_showCode(PrintStream output) {
        PrintWriter writer = new PrintWriter(output, true);
        this.debug_showCode(writer);
    }

    public void debug_showStackMapTable(PrintWriter output) {
        if (this.fStackMapTable != null) {
            this.fStackMapTable.debug_showMap(output);
        }
    }

    public void debug_showCode(PrintWriter output) {
        output.println("Method " + (this.fMethod == null ? "<null>" : this.fMethod.getName() + this.fMethod.getTypeDescriptor()));
        output.println("Max stack size: " + this.fMaxStack);
        output.println("Max local variables: " + this.fMaxLocals);
        output.println("Code size: " + this.fCode.length);
        output.println();
        int pc = 0;
        while (pc < this.fCode.length) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(this.rightAlign(5, String.valueOf(pc)));
            buffer.append(". ");
            int base = pc;
            int opcode = DGCode.unsignedByteToInt(this.fCode[pc++]);
            buffer.append(this.debug_showOpcode(opcode));
            switch (opcode) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    break;
                }
                case 16: {
                    pc = this.handleOneByteSignedConstant(buffer, pc);
                    break;
                }
                case 17: {
                    pc = this.handleTwoByteSignedConstant(buffer, pc);
                    break;
                }
                case 18: {
                    pc = this.handleOneByteConstantPoolReference(buffer, pc);
                    break;
                }
                case 19: {
                    pc = this.handleTwoByteConstantPoolReference(buffer, pc);
                    break;
                }
                case 20: {
                    pc = this.handleTwoByteConstantPoolReference(buffer, pc);
                    break;
                }
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: {
                    pc = this.handleOneByteLocalVariableReference(buffer, pc);
                    break;
                }
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: {
                    break;
                }
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: {
                    pc = this.handleOneByteLocalVariableReference(buffer, pc);
                    break;
                }
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 91: 
                case 92: 
                case 93: 
                case 94: 
                case 95: 
                case 96: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: 
                case 123: 
                case 124: 
                case 125: 
                case 126: 
                case 127: 
                case 128: 
                case 129: 
                case 130: 
                case 131: {
                    break;
                }
                case 132: {
                    byte arg1 = this.fCode[pc++];
                    byte arg2 = this.fCode[pc++];
                    DGCode.appendArg(buffer, DGCode.unsignedByteToInt(arg1));
                    DGCode.appendArg(buffer, DGCode.signedByteToInt(arg2));
                    break;
                }
                case 133: 
                case 134: 
                case 135: 
                case 136: 
                case 137: 
                case 138: 
                case 139: 
                case 140: 
                case 141: 
                case 142: 
                case 143: 
                case 144: 
                case 145: 
                case 146: 
                case 147: 
                case 148: 
                case 149: 
                case 150: 
                case 151: 
                case 152: {
                    break;
                }
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: 
                case 167: 
                case 168: {
                    pc = DGCode.handleTwoByteOffset(buffer, this.fCode, base, pc);
                    break;
                }
                case 169: {
                    pc = this.handleOneByteLocalVariableReference(buffer, pc);
                    break;
                }
                case 170: {
                    DGCode.appendArg(buffer, "[NOT YET IMPLEMENTED - REST WILL BE MESSED UP]");
                    break;
                }
                case 171: {
                    pc = this.handleLookupSwitch(buffer, base, pc);
                    break;
                }
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 177: {
                    break;
                }
                case 178: {
                    pc = this.handleTwoByteConstantPoolReference(buffer, pc);
                    break;
                }
                case 179: {
                    pc = this.handleTwoByteConstantPoolReference(buffer, pc);
                    break;
                }
                case 180: {
                    pc = this.handleTwoByteConstantPoolReference(buffer, pc);
                    break;
                }
                case 181: {
                    pc = this.handleTwoByteConstantPoolReference(buffer, pc);
                    break;
                }
                case 182: {
                    pc = this.handleTwoByteConstantPoolReference(buffer, pc);
                    break;
                }
                case 183: {
                    pc = this.handleTwoByteConstantPoolReference(buffer, pc);
                    break;
                }
                case 184: {
                    pc = this.handleTwoByteConstantPoolReference(buffer, pc);
                    break;
                }
                case 185: {
                    pc = this.handleTwoByteConstantPoolReference(buffer, pc);
                    byte arg3 = this.fCode[pc++];
                    byte arg4 = this.fCode[pc++];
                    break;
                }
                case 186: {
                    pc = this.handleTwoByteConstantPoolReference(buffer, pc);
                    byte arg3 = this.fCode[pc++];
                    byte arg4 = this.fCode[pc++];
                    break;
                }
                case 187: {
                    pc = this.handleTwoByteConstantPoolReference(buffer, pc);
                    break;
                }
                case 188: {
                    byte arg1 = this.fCode[pc++];
                    DGCode.appendArg(buffer, this.debug_showAType(arg1));
                    break;
                }
                case 189: {
                    pc = this.handleTwoByteConstantPoolReference(buffer, pc);
                    break;
                }
                case 190: 
                case 191: {
                    break;
                }
                case 192: {
                    pc = this.handleTwoByteConstantPoolReference(buffer, pc);
                    break;
                }
                case 193: {
                    pc = this.handleTwoByteConstantPoolReference(buffer, pc);
                    break;
                }
                case 194: 
                case 195: {
                    break;
                }
                case 196: {
                    DGCode.appendArg(buffer, "[NOT YET IMPLEMENTED - REST WILL BE MESSED UP]");
                    break;
                }
                case 197: {
                    pc = this.handleTwoByteConstantPoolReference(buffer, pc);
                    byte arg3 = this.fCode[pc++];
                    DGCode.appendArg(buffer, DGCode.unsignedByteToInt(arg3));
                    break;
                }
                case 198: 
                case 199: {
                    pc = DGCode.handleTwoByteOffset(buffer, this.fCode, base, pc);
                    break;
                }
                case 200: {
                    pc = this.handleFourByteOffset(buffer, base, pc);
                    break;
                }
                case 201: {
                    pc = this.handleFourByteOffset(buffer, base, pc);
                    break;
                }
                default: {
                    DGCode.appendArg(buffer, "***** UNKNOWN OPCODE *****");
                }
            }
            output.println(buffer.toString());
        }
        if (this.fExceptions != null) {
            output.println();
            output.println("Number of Exceptions: " + this.fExceptions.length);
            for (int i = 0; i < this.fExceptions.length; ++i) {
                output.println("\t" + i + ". " + this.fExceptions[i].toString());
            }
        }
    }

    private int handleOneByteSignedConstant(StringBuffer buffer, int pc) {
        byte arg = this.fCode[pc];
        DGCode.appendArg(buffer, DGCode.signedByteToInt(arg));
        return pc + 1;
    }

    private int handleTwoByteSignedConstant(StringBuffer buffer, int pc) {
        byte arg1 = this.fCode[pc];
        byte arg2 = this.fCode[pc + 1];
        DGCode.appendArg(buffer, DGCode.signedShortToInt(arg1, arg2));
        return pc + 2;
    }

    private int handleOneByteLocalVariableReference(StringBuffer buffer, int pc) {
        byte arg = this.fCode[pc];
        DGCode.appendArg(buffer, DGCode.unsignedByteToInt(arg));
        return pc + 1;
    }

    private int handleTwoByteLocalVariableReference(StringBuffer buffer, int pc) {
        byte arg1 = this.fCode[pc];
        byte arg2 = this.fCode[pc + 1];
        DGCode.appendArg(buffer, this.unsignedShortToInt(arg1, arg2));
        return pc + 2;
    }

    private int handleOneByteConstantPoolReference(StringBuffer buffer, int pc) {
        byte arg = this.fCode[pc];
        DGCode.appendArg(buffer, arg);
        return pc + 1;
    }

    private int handleTwoByteConstantPoolReference(StringBuffer buffer, int pc) {
        byte arg1 = this.fCode[pc];
        byte arg2 = this.fCode[pc + 1];
        int cpi = arg1 * 256 + arg2;
        DGCode.appendArg(buffer, "[CPI:" + cpi + "]");
        return pc + 2;
    }

    public static int handleTwoByteOffset(StringBuffer buffer, byte[] byteCode, int base, int pc) {
        byte arg1 = byteCode[pc];
        byte arg2 = byteCode[pc + 1];
        DGCode.appendArg(buffer, base + DGCode.signedShortToInt(arg1, arg2));
        return pc + 2;
    }

    private int handleFourByteOffset(StringBuffer buffer, int base, int pc) {
        byte arg1 = this.fCode[pc];
        byte arg2 = this.fCode[pc + 1];
        byte arg3 = this.fCode[pc + 2];
        byte arg4 = this.fCode[pc + 3];
        DGCode.appendArg(buffer, base + DGCode.signedIntToInt(arg1, arg2, arg3, arg4));
        return pc + 4;
    }

    private int handleLookupSwitch(StringBuffer buffer, int base, int pc) {
        int numPairs;
        pc += pc % 4 == 0 ? 0 : 4 - pc % 4;
        byte arg1 = this.fCode[pc++];
        byte arg2 = this.fCode[pc++];
        byte arg3 = this.fCode[pc++];
        byte arg4 = this.fCode[pc++];
        int defaultTarget = base + DGCode.signedIntToInt(arg1, arg2, arg3, arg4);
        arg1 = this.fCode[pc++];
        arg2 = this.fCode[pc++];
        arg3 = this.fCode[pc++];
        if ((numPairs = DGCode.signedIntToInt(arg1, arg2, arg3, arg4 = this.fCode[pc++])) < 0) {
            DGCode.appendArg(buffer, "[INVALID BYTECODE - npairs value is negative");
            return pc;
        }
        DGCode.appendArg(buffer, "(" + numPairs + " pairs) default target = " + defaultTarget);
        for (int i = 0; i < numPairs; ++i) {
            arg1 = this.fCode[pc++];
            arg2 = this.fCode[pc++];
            arg3 = this.fCode[pc++];
            arg4 = this.fCode[pc++];
            int matchValue = DGCode.signedIntToInt(arg1, arg2, arg3, arg4);
            arg1 = this.fCode[pc++];
            arg2 = this.fCode[pc++];
            arg3 = this.fCode[pc++];
            arg4 = this.fCode[pc++];
            int target = base + DGCode.signedIntToInt(arg1, arg2, arg3, arg4);
            this.appendValueOnNewLine(buffer, this.rightAlign(12, matchValue + ":"));
            DGCode.appendArg(buffer, target);
        }
        return pc;
    }

    private String rightAlign(int totalLength, String value) {
        while (value.length() < totalLength) {
            value = " " + value;
        }
        return value;
    }

    private void appendValueOnNewLine(StringBuffer buffer, String value) {
        buffer.append("\n       ");
        buffer.append(value);
    }

    private static void appendArg(StringBuffer buffer, int arg) {
        DGCode.appendArg(buffer, String.valueOf(arg));
    }

    private static void appendArg(StringBuffer buffer, String arg) {
        buffer.append(" ");
        buffer.append(arg);
    }

    private static int unsignedByteToInt(byte value) {
        return value & 0xFF;
    }

    private static int signedByteToInt(byte value) {
        return value;
    }

    private int unsignedShortToInt(byte high, byte low) {
        return (DGCode.unsignedByteToInt(high) << 8) + DGCode.unsignedByteToInt(low);
    }

    public static int signedShortToInt(byte high, byte low) {
        return (DGCode.signedByteToInt(high) << 8) + DGCode.unsignedByteToInt(low);
    }

    public static int signedIntToInt(byte byte1, byte byte2, byte byte3, byte byte4) {
        return (DGCode.signedByteToInt(byte1) << 24) + (DGCode.unsignedByteToInt(byte2) << 16) + (DGCode.unsignedByteToInt(byte3) << 8) + DGCode.unsignedByteToInt(byte4);
    }

    byte[] debug_getCodeBytes() {
        return (byte[])this.fCode.clone();
    }

    DGExceptionEntry[] debug_getExceptionHandlers() {
        DGExceptionEntry[] copy = new DGExceptionEntry[this.fExceptions.length];
        for (int i = 0; i < copy.length; ++i) {
            copy[i] = (DGExceptionEntry)this.fExceptions[i].clone();
        }
        return copy;
    }

    private String debug_showAType(byte atype) {
        switch (atype) {
            case 4: {
                return "T_BOOLEAN";
            }
            case 5: {
                return "T_CHAR";
            }
            case 6: {
                return "T_FLOAT";
            }
            case 7: {
                return "T_DOUBLE";
            }
            case 8: {
                return "T_BYTE";
            }
            case 9: {
                return "T_SHORT";
            }
            case 10: {
                return "T_INT";
            }
            case 11: {
                return "T_LONG";
            }
        }
        return "***** UNKNOWN ARRAY TYPE *****";
    }

    private String debug_showOpcode(int opcode) {
        switch (opcode) {
            case 0: {
                return "nop";
            }
            case 1: {
                return "aconst_null";
            }
            case 2: {
                return "iconst_m1";
            }
            case 3: {
                return "iconst_0";
            }
            case 4: {
                return "iconst_1";
            }
            case 5: {
                return "iconst_2";
            }
            case 6: {
                return "iconst_3";
            }
            case 7: {
                return "iconst_4";
            }
            case 8: {
                return "iconst_5";
            }
            case 9: {
                return "lconst_0";
            }
            case 10: {
                return "lconst_1";
            }
            case 11: {
                return "fconst_0";
            }
            case 12: {
                return "fconst_1";
            }
            case 13: {
                return "fconst_2";
            }
            case 14: {
                return "dconst_0";
            }
            case 15: {
                return "dconst_1";
            }
            case 16: {
                return "bipush";
            }
            case 17: {
                return "sipush";
            }
            case 18: {
                return "ldc";
            }
            case 19: {
                return "ldc_w";
            }
            case 20: {
                return "ldc2_w";
            }
            case 21: {
                return "iload";
            }
            case 22: {
                return "lload";
            }
            case 23: {
                return "fload";
            }
            case 24: {
                return "dload";
            }
            case 25: {
                return "aload";
            }
            case 26: {
                return "iload_0";
            }
            case 27: {
                return "iload_1";
            }
            case 28: {
                return "iload_2";
            }
            case 29: {
                return "iload_3";
            }
            case 30: {
                return "lload_0";
            }
            case 31: {
                return "lload_1";
            }
            case 32: {
                return "lload_2";
            }
            case 33: {
                return "lload_3";
            }
            case 34: {
                return "fload_0";
            }
            case 35: {
                return "fload_1";
            }
            case 36: {
                return "fload_2";
            }
            case 37: {
                return "fload_3";
            }
            case 38: {
                return "dload_0";
            }
            case 39: {
                return "dload_1";
            }
            case 40: {
                return "dload_2";
            }
            case 41: {
                return "dload_3";
            }
            case 42: {
                return "aload_0";
            }
            case 43: {
                return "aload_1";
            }
            case 44: {
                return "aload_2";
            }
            case 45: {
                return "aload_3";
            }
            case 46: {
                return "iaload";
            }
            case 47: {
                return "laload";
            }
            case 48: {
                return "faload";
            }
            case 49: {
                return "daload";
            }
            case 50: {
                return "aaload";
            }
            case 51: {
                return "baload";
            }
            case 52: {
                return "caload";
            }
            case 53: {
                return "saload";
            }
            case 54: {
                return "istore";
            }
            case 55: {
                return "lstore";
            }
            case 56: {
                return "fstore";
            }
            case 57: {
                return "dstore";
            }
            case 58: {
                return "astore";
            }
            case 59: {
                return "istore_0";
            }
            case 60: {
                return "istore_1";
            }
            case 61: {
                return "istore_2";
            }
            case 62: {
                return "istore_3";
            }
            case 63: {
                return "lstore_0";
            }
            case 64: {
                return "lstore_1";
            }
            case 65: {
                return "lstore_2";
            }
            case 66: {
                return "lstore_3";
            }
            case 67: {
                return "fstore_0";
            }
            case 68: {
                return "fstore_1";
            }
            case 69: {
                return "fstore_2";
            }
            case 70: {
                return "fstore_3";
            }
            case 71: {
                return "dstore_0";
            }
            case 72: {
                return "dstore_1";
            }
            case 73: {
                return "dstore_2";
            }
            case 74: {
                return "dstore_3";
            }
            case 75: {
                return "astore_0";
            }
            case 76: {
                return "astore_1";
            }
            case 77: {
                return "astore_2";
            }
            case 78: {
                return "astore_3";
            }
            case 79: {
                return "iastore";
            }
            case 80: {
                return "lastore";
            }
            case 81: {
                return "fastore";
            }
            case 82: {
                return "dastore";
            }
            case 83: {
                return "aastore";
            }
            case 84: {
                return "bastore";
            }
            case 85: {
                return "castore";
            }
            case 86: {
                return "sastore";
            }
            case 87: {
                return "pop";
            }
            case 88: {
                return "pop2";
            }
            case 89: {
                return "dup";
            }
            case 90: {
                return "dup_x1";
            }
            case 91: {
                return "dup_x2";
            }
            case 92: {
                return "dup2";
            }
            case 93: {
                return "dup2_x1";
            }
            case 94: {
                return "dup2_x2";
            }
            case 95: {
                return "swap";
            }
            case 96: {
                return "iadd";
            }
            case 97: {
                return "ladd";
            }
            case 98: {
                return "fadd";
            }
            case 99: {
                return "dadd";
            }
            case 100: {
                return "isub";
            }
            case 101: {
                return "lsub";
            }
            case 102: {
                return "fsub";
            }
            case 103: {
                return "dsub";
            }
            case 104: {
                return "imul";
            }
            case 105: {
                return "lmul";
            }
            case 106: {
                return "fmul";
            }
            case 107: {
                return "dmul";
            }
            case 108: {
                return "idiv";
            }
            case 109: {
                return "ldiv";
            }
            case 110: {
                return "fdiv";
            }
            case 111: {
                return "ddiv";
            }
            case 112: {
                return "irem";
            }
            case 113: {
                return "lrem";
            }
            case 114: {
                return "frem";
            }
            case 115: {
                return "drem";
            }
            case 116: {
                return "ineg";
            }
            case 117: {
                return "lneg";
            }
            case 118: {
                return "fneg";
            }
            case 119: {
                return "dneg";
            }
            case 120: {
                return "ishl";
            }
            case 121: {
                return "lshl";
            }
            case 122: {
                return "ishr";
            }
            case 123: {
                return "lshr";
            }
            case 124: {
                return "iushr";
            }
            case 125: {
                return "lushr";
            }
            case 126: {
                return "iand";
            }
            case 127: {
                return "land";
            }
            case 128: {
                return "ior";
            }
            case 129: {
                return "lor";
            }
            case 130: {
                return "ixor";
            }
            case 131: {
                return "lxor";
            }
            case 132: {
                return "iinc";
            }
            case 133: {
                return "i2l";
            }
            case 134: {
                return "i2f";
            }
            case 135: {
                return "i2d";
            }
            case 136: {
                return "l2i";
            }
            case 137: {
                return "l2f";
            }
            case 138: {
                return "l2d";
            }
            case 139: {
                return "f2i";
            }
            case 140: {
                return "f2l";
            }
            case 141: {
                return "f2d";
            }
            case 142: {
                return "d2i";
            }
            case 143: {
                return "d2l";
            }
            case 144: {
                return "d2f";
            }
            case 145: {
                return "i2b";
            }
            case 146: {
                return "i2c";
            }
            case 147: {
                return "i2s";
            }
            case 148: {
                return "lcmp";
            }
            case 149: {
                return "fcmpl";
            }
            case 150: {
                return "fcmpg";
            }
            case 151: {
                return "dcmpl";
            }
            case 152: {
                return "dcmpg";
            }
            case 153: {
                return "ifeq";
            }
            case 154: {
                return "ifne";
            }
            case 155: {
                return "iflt";
            }
            case 156: {
                return "ifge";
            }
            case 157: {
                return "ifge";
            }
            case 158: {
                return "ifle";
            }
            case 159: {
                return "if_icmpeq";
            }
            case 160: {
                return "if_icmpne";
            }
            case 161: {
                return "if_icmplt";
            }
            case 162: {
                return "if_icmpge";
            }
            case 163: {
                return "if_icmpgt";
            }
            case 164: {
                return "if_icmple";
            }
            case 165: {
                return "if_acmpeq";
            }
            case 166: {
                return "if_acmpne";
            }
            case 167: {
                return "goto";
            }
            case 168: {
                return "jsr";
            }
            case 169: {
                return "ret";
            }
            case 170: {
                return "tableswitch";
            }
            case 171: {
                return "lookupswitch";
            }
            case 172: {
                return "ireturn";
            }
            case 173: {
                return "lreturn";
            }
            case 174: {
                return "freturn";
            }
            case 175: {
                return "dreturn";
            }
            case 176: {
                return "areturn";
            }
            case 177: {
                return "return";
            }
            case 178: {
                return "getstatic";
            }
            case 179: {
                return "putstatic";
            }
            case 180: {
                return "getfield";
            }
            case 181: {
                return "putfield";
            }
            case 182: {
                return "invokevirtual";
            }
            case 183: {
                return "invokespecial";
            }
            case 184: {
                return "invokestatic";
            }
            case 185: {
                return "invokeinterface";
            }
            case 186: {
                return "invokedynamic";
            }
            case 187: {
                return "new";
            }
            case 188: {
                return "newarray";
            }
            case 189: {
                return "anewarray";
            }
            case 190: {
                return "arraylength";
            }
            case 191: {
                return "athrow";
            }
            case 192: {
                return "checkcast";
            }
            case 193: {
                return "instanceof";
            }
            case 194: {
                return "monitorenter";
            }
            case 195: {
                return "monitorexit";
            }
            case 196: {
                return "wide";
            }
            case 197: {
                return "multinewarray";
            }
            case 198: {
                return "ifnull";
            }
            case 199: {
                return "ifnonnull";
            }
            case 200: {
                return "goto_w";
            }
            case 201: {
                return "jsr_w";
            }
        }
        return "Unknown opcode: " + opcode;
    }

    public boolean passesIntelligentInstrumentationCriterea() {
        return this.fInstrumentationDecider.passesInstrumentationCriterion(this);
    }

    public int getMethodScore() {
        return this.fInstrumentationDecider.getMethodScore(this);
    }

    public byte[] getCodeBytes() {
        return this.debug_getCodeBytes();
    }

    public DGExceptionEntry[] getExceptionTable() {
        return this.debug_getExceptionHandlers();
    }

    public int getStartingLineNumber() {
        if (this.fLineNumberTable != null) {
            return this.fLineNumberTable.findLineNumber(0);
        }
        return -1;
    }

    static {
        String removeLineNumbers = System.getProperty(kRemoveLineNumbersSystemPropertyKey);
        if (removeLineNumbers != null) {
            removeLineNumbers = removeLineNumbers.trim();
        }
        sRemoveLineNumbers = "true".equalsIgnoreCase(removeLineNumbers);
        sConstructorInstrumentation = true;
        sConstructorInstrumentationPartial = true;
    }

    public static class DGExceptionEntry
    implements Cloneable {
        private int fStartPC;
        private int fEndPC;
        private int fHandlerPC;
        private int fCPI_catchType;

        public DGExceptionEntry(DataInputStream in) throws IOException {
            this.fStartPC = in.readUnsignedShort();
            this.fEndPC = in.readUnsignedShort();
            this.fHandlerPC = in.readUnsignedShort();
            this.fCPI_catchType = in.readUnsignedShort();
        }

        public DGExceptionEntry(int tryPC, int catchPC) {
            this.fStartPC = tryPC;
            this.fEndPC = catchPC;
            this.fHandlerPC = catchPC;
            this.fCPI_catchType = 0;
        }

        public DGExceptionEntry(int tryPC, int endPC, int catchPC) {
            this.fStartPC = tryPC;
            this.fEndPC = endPC;
            this.fHandlerPC = catchPC;
            this.fCPI_catchType = 0;
        }

        public void write(DataOutputStream out) throws IOException {
            out.writeShort(this.fStartPC);
            out.writeShort(this.fEndPC);
            out.writeShort(this.fHandlerPC);
            out.writeShort(this.fCPI_catchType);
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException cnse) {
                Assertion.wilyFail();
                return null;
            }
        }

        public int getHandlerPC() {
            return this.fHandlerPC;
        }

        public void setHandlerPC(int handlerPC) {
            this.fHandlerPC = handlerPC;
        }

        public void adjustConstantPoolIndices(int base, int delta) {
            if (this.fCPI_catchType > base) {
                this.fCPI_catchType += delta;
            }
        }

        public void insertCode(int codePC, int codeLength, boolean includeInCatchStatement) {
            if (this.fStartPC >= codePC) {
                this.fStartPC += codeLength;
            }
            if (this.fEndPC > codePC || this.fEndPC == codePC && !includeInCatchStatement) {
                this.fEndPC += codeLength;
            }
            if (!(this.fHandlerPC == codePC && includeInCatchStatement || this.fHandlerPC < codePC)) {
                this.fHandlerPC += codeLength;
            }
        }

        public String toString() {
            return "Start=" + this.fStartPC + ", End=" + this.fEndPC + ", Handler=" + this.fHandlerPC + ",type=[CPI:" + this.fCPI_catchType + "]";
        }

        public int getStartPC() {
            return this.fStartPC;
        }

        public int getEndPC() {
            return this.fEndPC;
        }

        public int getCatchTypeCPI() {
            return this.fCPI_catchType;
        }
    }
}

