/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.personality.java.mutate;

import com.wily.diagnos.cmp.classfile.DGClassModificationException;
import com.wily.diagnos.cmp.directives.DGCompilerSettings;
import com.wily.diagnos.cmp.mutate.IClassMutator;
import com.wily.diagnos.cmp.transform.InjectFieldIntoClassTransformation;
import com.wily.diagnos.personality.java.classfile.DGClass;
import com.wily.diagnos.personality.java.mutate.AJavaClassMutation;
import com.wily.util.classfile.IModeledClass;
import java.io.IOException;

public class InjectFieldIntoClassClassMutation
extends AJavaClassMutation {
    private static final String kCannotInjectFieldException = "Cannot inject a field to interface.";
    private final InjectFieldIntoClassTransformation fTransform;

    public InjectFieldIntoClassClassMutation(DGCompilerSettings settings, IClassMutator mutator, InjectFieldIntoClassTransformation transform, IModeledClass targetClass) {
        super(settings, mutator, targetClass);
        this.fTransform = transform;
    }

    @Override
    protected void doMutate(DGClass targetClass) throws DGClassModificationException, IOException {
        String fieldName = this.fTransform.getFieldName();
        String fieldDesc = this.fTransform.getFieldDesc();
        int accessFlags = 130;
        if (targetClass.isInterface()) {
            return;
        }
        targetClass.addNewField(fieldName, fieldDesc, accessFlags);
        this.fTransform.markFieldAsInjected(targetClass.getClassName().getReflectionFriendlyQualifiedNameString());
    }
}

