/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.transformer.dynamic.OverheadAdministrator;
import com.wily.introscope.agent.transformer.dynamic.OverheadMode;
import java.io.IOException;
import java.net.AbstractPlainSocketImpl;
import java.net.AgentSocketInputStream;
import java.net.PlainSocketImpl;
import java.net.SocketInputStream;

public class ManagedSocketInputStreamHighPerformanceNew
extends SocketInputStream {
    private final AgentSocketInputStream managedSocketInputStream = new AgentSocketInputStream();

    ManagedSocketInputStreamHighPerformanceNew(PlainSocketImpl impl) throws IOException {
        super((AbstractPlainSocketImpl)impl);
        this.managedSocketInputStream.setCache(impl.socket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() throws IOException {
        int byteRead;
        String methodName = "read()";
        if (this.managedSocketInputStream.getCache() == null || this.checkWithOverheadMgr()) {
            return super.read();
        }
        Object tl = AgentShim.getAgentShimThreadLocal();
        if (AgentShim.isThreadInAgentCode(tl)) {
            return super.read();
        }
        boolean addedToConcurrentReaders = false;
        try {
            AgentShim.setThreadInAgentCode(tl);
            addedToConcurrentReaders = this.managedSocketInputStream.addToConcurrentReaders("read()");
            if (this.managedSocketInputStream.getCache().isClientConnection()) {
                this.managedSocketInputStream.annotateBlameStack(this);
                this.managedSocketInputStream.suggestStackTraceRecording();
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                AgentShim.handleError("Exception in preparing read() from High Performance socket input stream", t);
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable td2) {
                // empty catch block
            }
        }
        finally {
            AgentShim.clearThreadInAgentCode(tl);
        }
        try {
            byteRead = super.read();
            AgentShim.setThreadInAgentCode(tl);
            this.managedSocketInputStream.addToInputBandwidth(1);
        }
        catch (ThreadDeath td) {
            throw td;
        }
        finally {
            this.managedSocketInputStream.removeFromConcurrentReaders(addedToConcurrentReaders, "read()");
            AgentShim.clearThreadInAgentCode(tl);
        }
        return byteRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] b, int off, int length) throws IOException {
        int numberOfBytesRead;
        String methodName = "read(byte[],int,int)";
        if (this.managedSocketInputStream.getCache() == null || this.checkWithOverheadMgr()) {
            return super.read(b, off, length);
        }
        Object tl = AgentShim.getAgentShimThreadLocal();
        if (AgentShim.isThreadInAgentCode(tl)) {
            return super.read(b, off, length);
        }
        boolean addedToConcurrentReaders = false;
        try {
            AgentShim.setThreadInAgentCode(tl);
            addedToConcurrentReaders = this.managedSocketInputStream.addToConcurrentReaders("read(byte[],int,int)");
            if (this.managedSocketInputStream.getCache().isClientConnection()) {
                this.managedSocketInputStream.annotateBlameStack(this);
                this.managedSocketInputStream.suggestStackTraceRecording();
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                AgentShim.handleError("Exception in preparing read(byte[],int,int) from High Performance socket input stream", t);
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable td2) {
                // empty catch block
            }
        }
        finally {
            AgentShim.clearThreadInAgentCode(tl);
        }
        try {
            numberOfBytesRead = super.read(b, off, length);
            AgentShim.setThreadInAgentCode(tl);
            this.managedSocketInputStream.addToInputBandwidth(numberOfBytesRead);
        }
        catch (ThreadDeath td) {
            throw td;
        }
        finally {
            this.managedSocketInputStream.removeFromConcurrentReaders(addedToConcurrentReaders, "read(byte[],int,int)");
            AgentShim.clearThreadInAgentCode(tl);
        }
        return numberOfBytesRead;
    }

    private boolean checkWithOverheadMgr() {
        return OverheadMode.LOW_WITH_ONLY_FRONTEND_BACKEND == OverheadAdministrator.getOverheadMode() || OverheadMode.ABSOLUTE_LOW == OverheadAdministrator.getOverheadMode();
    }
}

