/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.agent.jmxclient.metrics;

import com.ca.apm.agent.jmxclient.Configuration;
import com.ca.apm.agent.jmxclient.api.JmxClamp;
import com.ca.apm.agent.jmxclient.metrics.MetricValueListener;
import com.wily.introscope.agent.stat.IDataAccumulator;
import com.wily.introscope.agent.stat.IStringEveryEventDataAccumulator;

public class BooleanMetric
implements MetricValueListener<Boolean> {
    final IStringEveryEventDataAccumulator acc;

    public BooleanMetric(String metricName) {
        JmxClamp clamp = JmxClamp.getInstance(Configuration.getAgent());
        if (!clamp.isClampHit()) {
            clamp.incrementMetricCounter();
            this.acc = Configuration.getAccumulatorFactory().safeGetStringEveryEventDataAccumulator(metricName);
        } else {
            clamp.printClampWarning();
            this.acc = null;
        }
    }

    @Override
    public void update(Boolean value) {
        if (this.acc != null) {
            this.acc.IStringEveryEventDataAccumulator_addString(String.valueOf(value));
        }
    }

    @Override
    public boolean validate(Object value) {
        return value != null ? value instanceof Boolean : true;
    }

    @Override
    public void close() {
        if (this.acc != null) {
            JmxClamp.getInstance(Configuration.getAgent()).decrementMetricCounter();
            Configuration.getAccumulatorFactory().removeDataAccumulator((IDataAccumulator)this.acc);
        }
    }

    public int hashCode() {
        return this.acc == null ? 0 : this.acc.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BooleanMetric other = (BooleanMetric)obj;
        return !(this.acc == null ? other.acc != null : !this.acc.equals(other.acc));
    }
}

