/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.agent.jmxclient.metrics;

import com.ca.apm.agent.jmxclient.metrics.MetricValueTransformer;
import java.util.Map;

public class ValueMultiplier<T extends Number>
implements MetricValueTransformer<T, Number> {
    private final Double factor;

    public ValueMultiplier(double value) {
        this.factor = value;
    }

    @Override
    public Number transform(T value, Map info) {
        if (value instanceof Double) {
            return (long)(((Number)value).doubleValue() * this.factor);
        }
        return (long)((double)((Number)value).longValue() * this.factor);
    }

    @Override
    public boolean validate(Object value) {
        return value instanceof Number;
    }

    public int hashCode() {
        return this.factor.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ValueMultiplier other = (ValueMultiplier)obj;
        return this.factor == other.factor;
    }
}

