/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.agent.jmxclient.springboot.actuator;

import com.ca.apm.agent.jmxclient.Configuration;
import com.ca.apm.agent.jmxclient.api.BeanConfigElement;
import com.ca.apm.agent.jmxclient.api.JmxCustomBeanConfig;
import com.ca.apm.agent.jmxclient.metrics.MetricType;
import com.wily.introscope.agent.trace.intelligent.Logger;
import com.wily.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;

public class WebsphereBeanConfig
implements JmxCustomBeanConfig {
    private static final String OP_LISTENDPOINTS = "listEndpoints";
    private static final String OP_IS_PAUSED = "isPaused";
    private static final String OPERATION_PARAMETER_KEY = "{operationParameter}";
    private static final Logger.ILoggingHandler LOGGER = Configuration.getLogger();
    private final MBeanServerConnection server;

    public WebsphereBeanConfig(MBeanServerConnection server) {
        this.server = server;
    }

    @Override
    public void getCustomConfig(ObjectName name, Map<String, Set<BeanConfigElement>> configMap, MBeanInfo beanInfo) {
        try {
            MBeanOperationInfo[] opInfos = beanInfo.getOperations();
            List endPoints = new ArrayList();
            for (MBeanOperationInfo opInfo : opInfos) {
                Object listNames;
                if (opInfo.getName().equalsIgnoreCase(OP_LISTENDPOINTS) && (listNames = this.server.invoke(name, opInfo.getName(), new Object[0], new String[0])) instanceof List) {
                    endPoints = (List)listNames;
                }
                if (opInfo == null || endPoints.size() <= 0) continue;
                HashSet<BeanConfigElement> dataElementSet = new HashSet<BeanConfigElement>();
                for (String endPoint : endPoints) {
                    BeanConfigElement element = new BeanConfigElement(name.getCanonicalName(), OP_IS_PAUSED, Collections.emptyList());
                    String metricName = Configuration.getDefaultWebsphereMetricPrefixFormat();
                    element.setMetricType(MetricType.BOOLEAN.name());
                    element.setSingleValueTransfomer(true);
                    element.setOperationParameters(Arrays.asList(endPoint));
                    dataElementSet.add(element);
                    int index = metricName.indexOf(OPERATION_PARAMETER_KEY);
                    if (index != -1) {
                        metricName = StringUtils.replace((String)metricName, (String)OPERATION_PARAMETER_KEY, (String)endPoint);
                    }
                    element.setMetricName(metricName);
                }
                configMap.put(OP_IS_PAUSED, dataElementSet);
            }
        }
        catch (Exception e) {
            LOGGER.logError("Error retrieveing data for Object - " + name.getCanonicalName());
            e.printStackTrace();
        }
    }
}

