/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.agent.jmxclient.thread;

import com.ca.apm.agent.jmxclient.Configuration;
import com.ca.apm.agent.jmxclient.thread.ThreadMonService;
import com.ca.apm.agent.jmxclient.thread.ThreadMonStatsModel;
import com.ca.apm.agent.jmxclient.thread.ThreadMonStatsSnapshotModel;
import com.wily.introscope.agent.stat.DataAccumulatorFactory;
import com.wily.introscope.agent.stat.IIntegerAverageDataAccumulator;
import com.wily.introscope.agent.stat.IIntegerFluctuatingCounterDataAccumulator;
import com.wily.introscope.agent.stat.ILongIntervalCounterDataAccumulator;
import com.wily.introscope.agent.trace.intelligent.Logger;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ThreadMonMetricsProcess {
    private static final Logger.ILoggingHandler LOGGER = Configuration.getLogger();
    private static final String TOTAL_DEADLOCK_THREADS = ":Total Deadlock Threads";
    private static final String TOTAL_THREADS = ":Total Threads";
    private static final String TOTAL_BLOCKED_THREADS = ":Total Blocked Threads";
    private static final String TOTAL_WAIT_THREADS = ":Total Wait Threads";
    private static final String TOTAL_TIMEDWAIT_THREADS = ":Total TimedWait Threads";
    private static final String TOTAL_RUNNING_THREADS = ":Total Running Threads";
    private static final String THREAD_CPU_TIME = ":CPU Time (ms)";
    private static final String THREAD_USER_TIME = ":User Time (ms)";
    private static final String THREAD_BLOCKED_TIME = ":Blocked Time (ms)";
    private static final String THREAD_BLOCKED_COUNT = ":Blocked Count";
    private static final String THREAD_WAIT_TIME = ":Wait Time (ms)";
    private static final String THREAD_WAIT_COUNT = ":Wait Count";
    private static final String THREAD_STATUS = ":Thread Status";
    private static final String THREAD_POOL_SIZE = ":Thread Pool Size";
    private String metricPrefix;
    private HashMap<Long, ThreadMonStatsSnapshotModel> threadStatsSnapshotMap = new HashMap();
    private Set<String> previousRunThreadNames = new HashSet<String>();
    private int totalRunningCount;
    private int totalTimedWaitCount;
    private int totalWaitCount;
    private int totalBlockedCount;
    private int totalDeadlockCount;
    private int totalThreadCount;
    private ThreadMonService threadMonService;

    public ThreadMonMetricsProcess(ThreadMonService threadMonService) {
        this.threadMonService = threadMonService;
        this.metricPrefix = threadMonService.metricPrefix;
    }

    public void fetchAndProcessThreads() {
        try {
            if (!this.threadMonService.isThreadMonitoringEnabled()) {
                if (!this.previousRunThreadNames.isEmpty()) {
                    this.threadStatsSnapshotMap.clear();
                    this.deleteAllThreadMetrics();
                    this.previousRunThreadNames.clear();
                }
                return;
            }
            long startTime = System.currentTimeMillis();
            ThreadMXBean threadMXBean = ManagementFactory.newPlatformMXBeanProxy(this.threadMonService.mbeanServer, "java.lang:type=Threading", ThreadMXBean.class);
            if (!threadMXBean.isThreadCpuTimeSupported()) {
                LOGGER.logDebugMessage("JMX Thread CPU Time isn't supported on this JVM. Thread monitoring will be disabled.");
                return;
            }
            ThreadMonStatsModel[] threadStatsModelList = this.populateThreadStats(threadMXBean);
            this.processThreadMetrics(threadStatsModelList);
            long processingTime = System.currentTimeMillis() - startTime;
            LOGGER.logDebugMessage("Thread Monitoring Metrics Processing Time (ms):" + processingTime);
            IIntegerAverageDataAccumulator accumulator3 = Configuration.getAccumulatorFactory().safeGetIntegerAverageDataAccumulator("Agent Stats|Sustainability|Extensions|ThreadMonitor:Avg Metrics Processing Time (ms)");
            accumulator3.IIntegerAggregatingDataAccumulator_recordDataPoint((int)processingTime);
        }
        catch (Exception e) {
            LOGGER.logDebugMessage("Error processing thread performance metrics...", (Throwable)e);
        }
    }

    public ThreadMonStatsModel[] populateThreadStats(ThreadMXBean threadMXBean) {
        HashMap<ThreadInfo, ThreadMonStatsModel> result = new HashMap<ThreadInfo, ThreadMonStatsModel>();
        HashSet<Long> deadThreads = new HashSet<Long>(this.threadStatsSnapshotMap.keySet());
        long[] ids = threadMXBean.getAllThreadIds();
        ThreadInfo[] infos = threadMXBean.getThreadInfo(ids);
        List<Long> deadLockedIds = this.findDeadlockedThreads(threadMXBean);
        this.clearRolledUpMetrics();
        for (int i = 0; i < ids.length; ++i) {
            if (infos[i] == null) continue;
            this.incrementRolledUpMetrics(infos[i]);
            String normalizedThreadName = this.threadMonService.getNormalizedThreadName(infos[i].getThreadName());
            if (this.threadMonService.excludeThread(normalizedThreadName) || !this.threadMonService.includeThread(normalizedThreadName)) continue;
            Long threadID = ids[i];
            deadThreads.remove(threadID);
            long cpuTime = threadMXBean.getThreadCpuTime(ids[i]) / 1000000L;
            long userTime = threadMXBean.getThreadUserTime(ids[i]) / 1000000L;
            ThreadMonStatsSnapshotModel oldStats = this.threadStatsSnapshotMap.get(threadID);
            if (oldStats == null) {
                oldStats = new ThreadMonStatsSnapshotModel(infos[i], cpuTime, userTime);
            }
            ThreadMonStatsModel perfStats = ThreadMonStatsModel.create(oldStats.cpuTimeMs, cpuTime, oldStats.userTimeMs, userTime, 1L, oldStats.threadInfo, infos[i]);
            if (deadLockedIds.contains(ids[i])) {
                perfStats.threadState = ThreadMonStatsModel.APMThreadState.DEADLOCK;
            }
            result.put(infos[i], perfStats);
            this.threadStatsSnapshotMap.put(threadID, new ThreadMonStatsSnapshotModel(infos[i], cpuTime, userTime));
        }
        this.totalDeadlockCount = deadLockedIds.size();
        for (Long deadKey : deadThreads) {
            this.threadStatsSnapshotMap.remove(deadKey);
        }
        return result.values().toArray(new ThreadMonStatsModel[result.size()]);
    }

    public void processThreadMetrics(ThreadMonStatsModel[] threadStatsModelList) {
        HashMap<String, ThreadMonStatsModel> threadMap = new HashMap<String, ThreadMonStatsModel>();
        for (ThreadMonStatsModel stat : threadStatsModelList) {
            String threadNameNormalized = this.threadMonService.getNormalizedThreadName(stat.threadName);
            if (threadMap.get(threadNameNormalized) != null) {
                ThreadMonStatsModel.APMThreadState maxThreadState;
                ThreadMonStatsModel aggregatedStats = (ThreadMonStatsModel)threadMap.get(threadNameNormalized);
                aggregatedStats.cpuTimeMs += stat.cpuTimeMs;
                aggregatedStats.threadId = Math.min(aggregatedStats.threadId, stat.threadId);
                aggregatedStats.userTimeMs += stat.userTimeMs;
                aggregatedStats.blockedTimeMs += stat.blockedTimeMs;
                aggregatedStats.blockedCount += stat.blockedCount;
                aggregatedStats.waitedTimeMs += stat.waitedTimeMs;
                aggregatedStats.waitedCount += stat.waitedCount;
                aggregatedStats.threadPoolSize += stat.threadPoolSize;
                int threadStateMaxValue = Math.max(aggregatedStats.threadState.ordinal(), stat.threadState.ordinal());
                aggregatedStats.threadState = maxThreadState = aggregatedStats.convertThreadStateToEnum(threadStateMaxValue);
                continue;
            }
            threadMap.put(threadNameNormalized, stat);
        }
        ArrayList threadList = new ArrayList(threadMap.entrySet());
        if (this.threadMonService.getNumOfThreadsToMonitor() > 0) {
            Collections.sort(threadList, new Comparator<Map.Entry<String, ThreadMonStatsModel>>(){

                @Override
                public int compare(Map.Entry<String, ThreadMonStatsModel> e1, Map.Entry<String, ThreadMonStatsModel> e2) {
                    return Long.compare(e1.getValue().threadId, e2.getValue().threadId);
                }
            });
        }
        HashSet<String> currentRunThreadNames = new HashSet<String>();
        for (int i = 0; i < threadList.size(); ++i) {
            Map.Entry entry = (Map.Entry)threadList.get(i);
            String metricName = this.metricPrefix + "|" + (String)entry.getKey();
            ThreadMonStatsModel threadStatsModel = (ThreadMonStatsModel)entry.getValue();
            ILongIntervalCounterDataAccumulator accumulator = Configuration.getAccumulatorFactory().safeGetLongIntervalCounterDataAccumulator(metricName + THREAD_CPU_TIME);
            accumulator.ILongAggregatingDataAccumulator_recordDataPoint(threadStatsModel.cpuTimeMs);
            accumulator = Configuration.getAccumulatorFactory().safeGetLongIntervalCounterDataAccumulator(metricName + THREAD_USER_TIME);
            accumulator.ILongAggregatingDataAccumulator_recordDataPoint(threadStatsModel.userTimeMs);
            accumulator = Configuration.getAccumulatorFactory().safeGetLongIntervalCounterDataAccumulator(metricName + THREAD_BLOCKED_TIME);
            accumulator.ILongAggregatingDataAccumulator_recordDataPoint(threadStatsModel.blockedTimeMs);
            accumulator = Configuration.getAccumulatorFactory().safeGetLongIntervalCounterDataAccumulator(metricName + THREAD_BLOCKED_COUNT);
            accumulator.ILongAggregatingDataAccumulator_recordDataPoint(threadStatsModel.blockedCount);
            accumulator = Configuration.getAccumulatorFactory().safeGetLongIntervalCounterDataAccumulator(metricName + THREAD_WAIT_TIME);
            accumulator.ILongAggregatingDataAccumulator_recordDataPoint(threadStatsModel.waitedTimeMs);
            accumulator = Configuration.getAccumulatorFactory().safeGetLongIntervalCounterDataAccumulator(metricName + THREAD_WAIT_COUNT);
            accumulator.ILongAggregatingDataAccumulator_recordDataPoint(threadStatsModel.waitedCount);
            IIntegerFluctuatingCounterDataAccumulator accumulator2 = Configuration.getAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator(metricName + THREAD_STATUS);
            accumulator2.IIntegerCounterDataAccumulator_setValue(threadStatsModel.threadState.ordinal());
            accumulator2 = Configuration.getAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator(metricName + THREAD_POOL_SIZE);
            accumulator2.IIntegerCounterDataAccumulator_setValue((int)threadStatsModel.threadPoolSize);
            currentRunThreadNames.add((String)entry.getKey());
            if (i + 1 < this.threadMonService.getNumOfThreadsToMonitor()) continue;
            LOGGER.logDebugMessage("JMX Thread clamp hit!!! Increase thread clamp to monitor more threads: introscope.agent.remotejmx.threadMonitor.numOfThreadsToMonitor");
            break;
        }
        this.sendRolledUpMetrics(threadStatsModelList);
        this.previousRunThreadNames.removeAll(currentRunThreadNames);
        this.clearStaleThreadMetrics(this.previousRunThreadNames);
        this.previousRunThreadNames = currentRunThreadNames;
    }

    public List<Long> findDeadlockedThreads(ThreadMXBean threadMXBean) {
        long[] tids;
        ArrayList<Long> ids = new ArrayList<Long>();
        if (threadMXBean.isSynchronizerUsageSupported() && (tids = threadMXBean.findDeadlockedThreads()) != null) {
            for (long id : tids) {
                ids.add(id);
            }
        }
        return ids;
    }

    private void incrementRolledUpMetrics(ThreadInfo threadInfo) {
        ThreadMonStatsModel.APMThreadState state = ThreadMonStatsModel.getAPMThreadState(threadInfo);
        if (state == ThreadMonStatsModel.APMThreadState.DEADLOCK) {
            ++this.totalDeadlockCount;
        } else if (state == ThreadMonStatsModel.APMThreadState.BLOCKED) {
            ++this.totalBlockedCount;
        } else if (state == ThreadMonStatsModel.APMThreadState.WAITING) {
            ++this.totalWaitCount;
        } else if (state == ThreadMonStatsModel.APMThreadState.TIMED_WAITING) {
            ++this.totalTimedWaitCount;
        } else {
            ++this.totalRunningCount;
        }
        ++this.totalThreadCount;
    }

    private void clearRolledUpMetrics() {
        this.totalRunningCount = 0;
        this.totalTimedWaitCount = 0;
        this.totalWaitCount = 0;
        this.totalBlockedCount = 0;
        this.totalDeadlockCount = 0;
        this.totalThreadCount = 0;
    }

    private void sendRolledUpMetrics(ThreadMonStatsModel[] threadStatsModelList) {
        IIntegerFluctuatingCounterDataAccumulator accumulator = Configuration.getAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator(this.metricPrefix + TOTAL_DEADLOCK_THREADS);
        accumulator.IIntegerCounterDataAccumulator_setValue(this.totalDeadlockCount);
        if (threadStatsModelList != null) {
            accumulator = Configuration.getAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator(this.metricPrefix + TOTAL_THREADS);
            accumulator.IIntegerCounterDataAccumulator_setValue(this.totalThreadCount);
        }
        accumulator = Configuration.getAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator(this.metricPrefix + TOTAL_BLOCKED_THREADS);
        accumulator.IIntegerCounterDataAccumulator_setValue(this.totalBlockedCount);
        accumulator = Configuration.getAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator(this.metricPrefix + TOTAL_WAIT_THREADS);
        accumulator.IIntegerCounterDataAccumulator_setValue(this.totalWaitCount);
        accumulator = Configuration.getAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator(this.metricPrefix + TOTAL_TIMEDWAIT_THREADS);
        accumulator.IIntegerCounterDataAccumulator_setValue(this.totalTimedWaitCount);
        accumulator = Configuration.getAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator(this.metricPrefix + TOTAL_RUNNING_THREADS);
        accumulator.IIntegerCounterDataAccumulator_setValue(this.totalRunningCount);
    }

    private void clearStaleThreadMetrics(Set<String> threadNames) {
        if (threadNames.isEmpty()) {
            return;
        }
        DataAccumulatorFactory dataAccumulatorFactory = this.threadMonService.agent.IAgent_getDataAccumulatorFactory();
        for (String threadName : threadNames) {
            try {
                dataAccumulatorFactory.removeMetric(this.metricPrefix + "|" + threadName + THREAD_CPU_TIME);
                dataAccumulatorFactory.removeMetric(this.metricPrefix + "|" + threadName + THREAD_USER_TIME);
                dataAccumulatorFactory.removeMetric(this.metricPrefix + "|" + threadName + THREAD_BLOCKED_TIME);
                dataAccumulatorFactory.removeMetric(this.metricPrefix + "|" + threadName + THREAD_BLOCKED_COUNT);
                dataAccumulatorFactory.removeMetric(this.metricPrefix + "|" + threadName + THREAD_WAIT_TIME);
                dataAccumulatorFactory.removeMetric(this.metricPrefix + "|" + threadName + THREAD_WAIT_COUNT);
                dataAccumulatorFactory.removeMetric(this.metricPrefix + "|" + threadName + THREAD_STATUS);
                dataAccumulatorFactory.removeMetric(this.metricPrefix + "|" + threadName + THREAD_POOL_SIZE);
            }
            catch (Exception exe) {
                LOGGER.logDebugMessage("State thread metric removal error:", (Throwable)exe);
            }
        }
        LOGGER.logDebugMessage("Removed stale metrics for thread count:" + threadNames.size());
    }

    private void deleteAllThreadMetrics() {
        LOGGER.logInfoMessage("Thread monitoring disabled!!! Removing all thread metrics.");
        try {
            DataAccumulatorFactory dataAccumulatorFactory = this.threadMonService.agent.IAgent_getDataAccumulatorFactory();
            dataAccumulatorFactory.removeMetric(this.metricPrefix + TOTAL_DEADLOCK_THREADS);
            dataAccumulatorFactory.removeMetric(this.metricPrefix + TOTAL_THREADS);
            dataAccumulatorFactory.removeMetric(this.metricPrefix + TOTAL_BLOCKED_THREADS);
            dataAccumulatorFactory.removeMetric(this.metricPrefix + TOTAL_WAIT_THREADS);
            dataAccumulatorFactory.removeMetric(this.metricPrefix + TOTAL_TIMEDWAIT_THREADS);
            dataAccumulatorFactory.removeMetric(this.metricPrefix + TOTAL_RUNNING_THREADS);
            this.clearStaleThreadMetrics(this.previousRunThreadNames);
            LOGGER.logInfoMessage("Thread Stale Metric Removed");
        }
        catch (Exception e) {
            LOGGER.logDebugMessage("Exception occurred while removing thread stale metrics:", (Throwable)e);
        }
    }
}

