/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.agent.jmxclient.thread;

import com.ca.apm.agent.jmxclient.Configuration;
import com.ca.apm.agent.jmxclient.api.JmxNodeInfo;
import com.ca.apm.agent.jmxclient.thread.ThreadMonService;
import com.ca.apm.agent.jmxclient.thread.ThreadMonStackTraceModel;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.correlation.CrossProcessCorrelationAdmin;
import com.wily.introscope.agent.stat.IIntegerAverageDataAccumulator;
import com.wily.introscope.agent.trace.intelligent.Logger;
import com.wily.introscope.agent.transactiontrace.SharedCrossProcessData;
import com.wily.introscope.spec.server.transactiontrace.TransactionComponentData;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.HashMap;
import java.util.Map;
import java.util.TimerTask;
import javax.management.MBeanServerConnection;

public class ThreadMonProfiler
extends TimerTask {
    private static final Logger.ILoggingHandler LOGGER = Configuration.getLogger();
    private static final String kCrossProcessDataKey = "CorCrossProcessData";
    private static final String kTxnTraceId = "TxnTraceId";
    private static final String kComponentId = "Component ID";
    private static final String kCallerComponentId = "Caller Component ID";
    private static final String metricPrefix = "Threads";
    private JmxNodeInfo jmxNode;
    private MBeanServerConnection mbeanServer;
    private static long lastThreadPublishTime;
    private static final int THREAD_PROFILE_PUBLISH_INTERVAL = 360000;
    private Map<String, ThreadMonStackTraceModel> threadStackModelMap = new HashMap<String, ThreadMonStackTraceModel>();
    private Map<String, Long> threadPrevCpuTimes = new HashMap<String, Long>();
    ThreadMonService threadMonService;

    public ThreadMonProfiler(ThreadMonService threadMonService) {
        this.threadMonService = threadMonService;
        this.mbeanServer = threadMonService.mbeanServer;
        this.jmxNode = threadMonService.jmxNode;
        this.initializeCpuTimeMap();
    }

    @Override
    public void run() {
        try {
            long startTime = System.currentTimeMillis();
            int maxStackDepth = this.jmxNode.getMetricInfo().getMaxStackDepth();
            ThreadMXBean threadMXBean = ManagementFactory.newPlatformMXBeanProxy(this.mbeanServer, "java.lang:type=Threading", ThreadMXBean.class);
            long[] ids = threadMXBean.getAllThreadIds();
            ThreadInfo[] infos = threadMXBean.getThreadInfo(ids, maxStackDepth);
            this.processStacks(threadMXBean, infos);
            this.publishThreadTraces();
            long processingTime = System.currentTimeMillis() - startTime;
            LOGGER.logDebugMessage("Thread Profiling Processing Time (ms):" + processingTime);
            IIntegerAverageDataAccumulator accumulator3 = Configuration.getAccumulatorFactory().safeGetIntegerAverageDataAccumulator("Agent Stats|Sustainability|Extensions|ThreadMonitor:Avg Profile Processing Time (ms)");
            accumulator3.IIntegerAggregatingDataAccumulator_recordDataPoint((int)processingTime);
        }
        catch (Exception e) {
            LOGGER.logDebugMessage("Error profiling threads...", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void publishThreadTraces() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - lastThreadPublishTime > 360000L) {
            lastThreadPublishTime = currentTime;
            try {
                for (String threadNameNormalized : this.threadStackModelMap.keySet()) {
                    ThreadMonStackTraceModel threadStackTraceModel = this.threadStackModelMap.get(threadNameNormalized);
                    if (threadStackTraceModel.children.isEmpty()) continue;
                    SharedCrossProcessData scpd = null;
                    scpd = CrossProcessCorrelationAdmin.getCrossProcessCorrelationCache();
                    HashMap<String, String> params = new HashMap<String, String>();
                    params.put(kCrossProcessDataKey, scpd.getCorrelationID());
                    params.put(kTxnTraceId, scpd.getStringParamIn(kTxnTraceId));
                    params.put(kComponentId, scpd.getStringParamIn(kCallerComponentId));
                    HashMap<String, String> paramsMonitor = new HashMap<String, String>();
                    paramsMonitor.put("Trace Type", "Normal");
                    paramsMonitor.put(kCrossProcessDataKey, scpd.getCorrelationID());
                    long threadTotalCpuTimeMs = this.totalThreadCPUTime(threadStackTraceModel);
                    long threadTotalSampling = this.totalSamplingCount(threadStackTraceModel);
                    paramsMonitor.put("Sampling Count", "" + threadTotalSampling);
                    TransactionComponentData trace = TransactionComponentData.createMilliSecTransactionComponentData((String)("Threads|" + threadNameNormalized), (long)System.currentTimeMillis(), (long)threadTotalCpuTimeMs, paramsMonitor);
                    this.generateTraceFromThreadStack(threadStackTraceModel, trace);
                    AgentShim.getAgent().IAgent_queueEvent(trace);
                }
            }
            catch (Exception e) {
                LOGGER.logDebugMessage("Error while sending thread traces", (Throwable)e);
            }
            finally {
                this.threadStackModelMap.clear();
                this.initializeCpuTimeMap();
            }
        }
    }

    private long totalSamplingCount(ThreadMonStackTraceModel threadStackTraceModel) {
        long count = 0L;
        for (ThreadMonStackTraceModel stack : threadStackTraceModel.children.values()) {
            count += (long)stack.count;
        }
        return count;
    }

    private long totalThreadCPUTime(ThreadMonStackTraceModel threadStackTraceModel) {
        long threadCpuTime = 0L;
        for (ThreadMonStackTraceModel stack : threadStackTraceModel.children.values()) {
            threadCpuTime += stack.cpuTime;
        }
        return threadCpuTime /= 1000000L;
    }

    private void generateTraceFromThreadStack(ThreadMonStackTraceModel threadStackTraceModel, TransactionComponentData traceModel) {
        for (Map.Entry<String, ThreadMonStackTraceModel> childEntry : threadStackTraceModel.children.entrySet()) {
            ThreadMonStackTraceModel childThreadModel = childEntry.getValue();
            TransactionComponentData childTrace = TransactionComponentData.createMilliSecTransactionComponentData((String)childThreadModel.method, (long)System.currentTimeMillis(), (long)(childThreadModel.cpuTime / 1000000L));
            this.generateTraceFromThreadStack(childThreadModel, childTrace);
            traceModel.addSubNode(childTrace);
        }
    }

    private void initializeCpuTimeMap() {
        try {
            ThreadInfo[] infos;
            this.threadPrevCpuTimes.clear();
            int maxStackDepth = this.jmxNode.getMetricInfo().getMaxStackDepth();
            ThreadMXBean threadMXBean = ManagementFactory.newPlatformMXBeanProxy(this.mbeanServer, "java.lang:type=Threading", ThreadMXBean.class);
            long[] ids = threadMXBean.getAllThreadIds();
            for (ThreadInfo threadInfo : infos = threadMXBean.getThreadInfo(ids, maxStackDepth)) {
                long cpuTime = threadMXBean.getThreadCpuTime(threadInfo.getThreadId());
                String normalizedThreadName = this.threadMonService.getNormalizedThreadName(threadInfo.getThreadName());
                if (this.threadPrevCpuTimes.get(normalizedThreadName) == null) {
                    this.threadPrevCpuTimes.put(normalizedThreadName, cpuTime);
                    continue;
                }
                long totalCpuTime = this.threadPrevCpuTimes.get(normalizedThreadName);
                this.threadPrevCpuTimes.put(normalizedThreadName, totalCpuTime + cpuTime);
            }
        }
        catch (Exception exe) {
            LOGGER.logDebugMessage("Error intializing profiler cpu map", (Throwable)exe);
        }
    }

    public void processStacks(ThreadMXBean threadMXBean, ThreadInfo[] infos) {
        for (ThreadInfo threadInfo : infos) {
            String normalizedThreadName = this.threadMonService.getNormalizedThreadName(threadInfo.getThreadName());
            if (this.threadMonService.excludeThread(normalizedThreadName) || !this.threadMonService.includeThread(normalizedThreadName)) continue;
            long currentCpuTime = threadMXBean.getThreadCpuTime(threadInfo.getThreadId());
            long prevCpuTime = 0L;
            if (this.threadPrevCpuTimes.get(normalizedThreadName) != null) {
                prevCpuTime = this.threadPrevCpuTimes.get(normalizedThreadName);
            }
            this.threadPrevCpuTimes.put(normalizedThreadName, currentCpuTime);
            long cpuTime = currentCpuTime - prevCpuTime;
            ThreadMonStackTraceModel threadStackTraceModel = this.threadStackModelMap.get(normalizedThreadName);
            if (threadStackTraceModel == null) {
                if (this.threadStackModelMap.size() >= this.threadMonService.getNumOfThreadsToMonitor()) continue;
                ThreadMonStackTraceModel rootNode = new ThreadMonStackTraceModel("root");
                this.updateStackTree(rootNode, threadInfo.getStackTrace(), cpuTime, threadInfo.getStackTrace().length - 1);
                this.threadStackModelMap.put(normalizedThreadName, rootNode);
                continue;
            }
            this.updateStackTree(threadStackTraceModel, threadInfo.getStackTrace(), cpuTime, threadInfo.getStackTrace().length - 1);
        }
    }

    private void updateStackTree(ThreadMonStackTraceModel node, StackTraceElement[] stackTrace, long cpuTime, int index) {
        if (index < 0) {
            return;
        }
        String method = stackTrace[index].getClassName() + "." + stackTrace[index].getMethodName();
        ThreadMonStackTraceModel childNode = node.children.get(method);
        if (childNode == null) {
            childNode = new ThreadMonStackTraceModel(method);
            node.children.put(method, childNode);
        }
        ++childNode.count;
        childNode.cpuTime += cpuTime;
        this.updateStackTree(childNode, stackTrace, cpuTime, index - 1);
    }
}

