/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.agent.jmxclient.thread;

import java.lang.management.ThreadInfo;

public class ThreadMonStatsModel {
    public final String threadName;
    public long threadId;
    public long cpuTimeMs;
    public long userTimeMs;
    public long blockedTimeMs;
    public long blockedCount;
    public long waitedTimeMs;
    public long waitedCount;
    public long threadPoolSize;
    public APMThreadState threadState;

    public ThreadMonStatsModel(String threadName, long threadId, long cpuTimeMs, long userTimeMs, long blockedTimeMs, long blockedCount, long waitedTimeMs, long waitedCount, long threadPoolSize, APMThreadState threadState) {
        this.threadName = threadName;
        this.threadId = threadId;
        this.cpuTimeMs = cpuTimeMs;
        this.userTimeMs = userTimeMs;
        this.blockedTimeMs = blockedTimeMs;
        this.blockedCount = blockedCount;
        this.waitedTimeMs = waitedTimeMs;
        this.waitedCount = waitedCount;
        this.threadState = threadState;
        this.threadPoolSize = threadPoolSize;
    }

    public static ThreadMonStatsModel create(long oldCPUTime, long newCPUTime, long oldUserTime, long newUserTime, long threadPoolSize, ThreadInfo oldStats, ThreadInfo newStats) {
        APMThreadState state = ThreadMonStatsModel.getAPMThreadState(newStats);
        return new ThreadMonStatsModel(newStats.getThreadName(), newStats.getThreadId(), newCPUTime - oldCPUTime, newUserTime - oldUserTime, newStats.getBlockedTime() - oldStats.getBlockedTime(), newStats.getBlockedCount() - oldStats.getBlockedCount(), newStats.getWaitedTime() - oldStats.getWaitedTime(), newStats.getWaitedCount() - oldStats.getWaitedCount(), threadPoolSize, state);
    }

    public static APMThreadState getAPMThreadState(ThreadInfo threadInfo) {
        APMThreadState state = threadInfo.getThreadState() == Thread.State.WAITING ? APMThreadState.WAITING : (threadInfo.getThreadState() == Thread.State.TIMED_WAITING ? APMThreadState.TIMED_WAITING : (threadInfo.getThreadState() == Thread.State.BLOCKED ? APMThreadState.BLOCKED : APMThreadState.RUNNING));
        return state;
    }

    public APMThreadState convertThreadStateToEnum(int threadStateInt) {
        APMThreadState state = threadStateInt == Thread.State.WAITING.ordinal() ? APMThreadState.WAITING : (threadStateInt == Thread.State.BLOCKED.ordinal() ? APMThreadState.BLOCKED : APMThreadState.RUNNING);
        return state;
    }

    public static enum APMThreadState {
        RUNNING,
        TIMED_WAITING,
        WAITING,
        BLOCKED,
        DEADLOCK;

    }
}

