/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.cmp.tracer;

import com.wily.diagnos.cmp.classfile.DGClassModificationException;
import com.wily.diagnos.cmp.log.ICompilerLog;
import com.wily.diagnos.cmp.mutate.IMethodMutator;
import com.wily.diagnos.cmp.mutate.IMutation;
import com.wily.diagnos.cmp.tracer.DGAggregateMethodTracer;
import com.wily.diagnos.cmp.tracer.MethodTracer;
import com.wily.diagnos.personality.java.classfile.DGMethod;
import com.wily.diagnos.personality.java.tracer.DGIntelligentInstrumentationStreamConstructorMethodTracerInstance;
import com.wily.diagnos.personality.java.tracer.DGIntelligentInstrumentationStreamMethodTracerInstance;
import com.wily.util.classfile.IClassName;
import com.wily.util.classfile.IModeledMethod;
import com.wily.util.classfile.InvalidClassNameException;
import com.wily.util.classfile.java.ClassName;
import java.util.concurrent.atomic.AtomicBoolean;

public class DGIntelligentInstrumentationStreamTracer
extends DGAggregateMethodTracer {
    private AtomicBoolean fAddedOnce;
    private ICompilerLog fLog;

    public DGIntelligentInstrumentationStreamTracer(ICompilerLog log) {
        this.fLog = log;
        this.fAddedOnce = new AtomicBoolean(false);
    }

    protected IClassName getTracerLoadingClass() {
        try {
            return ClassName.getClassName((String)"com.wily.agent.main.IntelligentInstrumentationShim");
        }
        catch (InvalidClassNameException e) {
            return null;
        }
    }

    public IMutation newMutation(IMethodMutator mutator, IModeledMethod method) throws DGClassModificationException {
        if (method.isInstanceConstructor()) {
            return mutator.newCustomConstructorMethodTracerMutation(method, (DGAggregateMethodTracer)this, this.getTracerLoadingClass());
        }
        return mutator.newCustomMethodTracerMutation(method, (DGAggregateMethodTracer)this, this.getTracerLoadingClass());
    }

    public IMutation getConstructorMethodTracerMutationInstance(DGAggregateMethodTracer dgTracer, DGMethod method, ClassName tracerLoadingClass) {
        try {
            return new DGIntelligentInstrumentationStreamConstructorMethodTracerInstance(dgTracer, method, tracerLoadingClass);
        }
        catch (DGClassModificationException e) {
            this.fLog.ICompilerLog_logException((Throwable)e);
            return null;
        }
    }

    public IMutation getMethodTracerMutationInstance(DGAggregateMethodTracer dgTracer, DGMethod method, ClassName tracerLoadingClass) {
        try {
            return new DGIntelligentInstrumentationStreamMethodTracerInstance(dgTracer, method, tracerLoadingClass);
        }
        catch (DGClassModificationException e) {
            this.fLog.ICompilerLog_logException((Throwable)e);
            return null;
        }
    }

    public void addTracer(MethodTracer tracer) {
        boolean added = this.fAddedOnce.get();
        if (!added) {
            if (!this.fAddedOnce.compareAndSet(added, true)) {
                this.addTracer(tracer);
            } else {
                super.addTracer(tracer);
            }
        }
    }
}

