/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.probebuilder.intelligent.analysis;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.probebuilder.intelligent.analysis.AutoInstrumentationWorker;
import com.wily.util.feedback.Module;
import com.wily.util.heartbeat.ITimestampedRunnable;
import com.wily.util.thread.IThreadFactory;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class VisibilityGapProcessor
implements ITimestampedRunnable {
    private IAgent fAgent;
    Module fModule;
    private ScheduledExecutorService executor;
    private Runnable fAutoInstrumentationWorker;

    public VisibilityGapProcessor(IAgent agent, Module kmodule) {
        this.fAgent = agent;
        this.fModule = kmodule;
    }

    public void ITimestampedRunnable_execute(long nowInMillis) {
        this.fAgent.IAgent_getModuleFeedback().debug(this.fModule, "Intelligent Instrumentation Visibility Gap Processor activated");
        if (this.fAutoInstrumentationWorker == null) {
            this.startExecutor();
        }
        this.scheduleExecutor();
    }

    public void startExecutor() {
        this.executor = Executors.newSingleThreadScheduledExecutor(new VisibilityGapThreadFactory(this.fAgent));
        this.fAutoInstrumentationWorker = new AutoInstrumentationWorker(this.fAgent, this.fModule, this.executor, AutoInstrumentationWorker.WorkerType.VISIBILITYGAP);
    }

    public void scheduleExecutor() {
        this.executor.schedule(this.fAutoInstrumentationWorker, 0L, TimeUnit.SECONDS);
    }

    static class VisibilityGapThreadFactory
    implements ThreadFactory {
        final IThreadFactory agentFactory;
        final AtomicInteger threadNumber = new AtomicInteger(1);

        VisibilityGapThreadFactory(IAgent agent) {
            this.agentFactory = agent.IAgent_getAgentThreadFactory();
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = this.agentFactory.IThreadFactory_createNewThread("Visibility Gap Processor " + this.threadNumber.getAndIncrement(), r);
            return t;
        }
    }
}

