/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.launch.core;

import com.wily.introscope.agent.launch.core.IFileLocker;
import com.wily.introscope.agent.launch.util.BootstrapAgentUtil;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;

public class FileLocker
implements IFileLocker {
    private final FileChannel channel;
    private final RandomAccessFile lockFile;

    public FileLocker(String lockFilePath) throws IOException {
        File file = new File(lockFilePath);
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        if (!file.exists()) {
            file.createNewFile();
            BootstrapAgentUtil.fixGroupPermissionsForSharedAccess(file);
        }
        this.lockFile = new RandomAccessFile(file, "rw");
        this.channel = this.lockFile.getChannel();
    }

    @Override
    public FileLock acquireLock() {
        if (this.channel != null) {
            try {
                return this.channel.lock();
            }
            catch (IOException e) {
                System.err.println("IOException occured while invoking FileLocker.acquireLock() ");
            }
        }
        return null;
    }

    @Override
    public FileLock tryAcquire() {
        if (this.channel != null) {
            try {
                return this.channel.tryLock();
            }
            catch (IOException e) {
                System.err.println("IOException occured while invoking FileLocker.tryAcquire() ");
            }
        }
        return null;
    }

    @Override
    public FileLock tryAcquire(long timeOut) {
        return this.tryUntilAcquiredOrMaxRetries(timeOut, 1);
    }

    private void sleepBeforeRetry(long timeOut) {
        try {
            Thread.sleep(timeOut);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public FileLock tryUntilAcquiredOrMaxRetries(long sleep, int retries) {
        FileLock lock = this.tryAcquire();
        if (lock != null) {
            return lock;
        }
        this.sleepBeforeRetry(sleep);
        for (int i = 0; i < retries; ++i) {
            lock = this.tryAcquire();
            if (lock != null) {
                return lock;
            }
            this.sleepBeforeRetry(sleep);
        }
        return null;
    }

    @Override
    public void releaseLock(FileLock lock) {
        if (lock != null) {
            try {
                lock.release();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

