/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.launch.util;

import com.wily.introscope.agent.launch.core.BootstrapAgentLogger;
import com.wily.introscope.agent.launch.core.Logger;
import com.wily.introscope.agent.launch.util.BootstrapAgentConstants;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;

public class PolicyFileReader
implements BootstrapAgentConstants {
    private static final Logger LOGGER = BootstrapAgentLogger.getLogger();

    public static void getArgsFromPropertyFile(Map<String, String> params) throws IOException {
        String version;
        String policyFileLocation = params.get("agent.policy.file.location");
        Properties p = PolicyFileReader.getProperties(policyFileLocation);
        boolean versionFound = false;
        Enumeration<Object> i = p.keys();
        while (i.hasMoreElements()) {
            String key = (String)i.nextElement();
            if ("introscope.agent.release.version".equals(key.toLowerCase())) {
                versionFound = true;
                String version2 = System.getProperty("introscope.agent.release.version");
                if (version2 != null) {
                    LOGGER.fine("release version from the System property: " + version2);
                } else {
                    version2 = p.getProperty(key);
                    LOGGER.fine("release version from policy file: " + version2);
                }
                if (version2 == null) continue;
                LOGGER.info("introscope.agent.release.version is set to '" + version2 + "'");
                params.put(key.toLowerCase(), version2);
                continue;
            }
            params.put(key.toLowerCase(), p.getProperty(key));
        }
        if (!versionFound && (version = System.getProperty("introscope.agent.release.version")) != null) {
            LOGGER.fine("release version from the System property: " + version);
            params.put("introscope.agent.release.version".toLowerCase(), version);
        }
    }

    public static Properties getPropertiesForBSA(String bsaInstallDir) {
        return PolicyFileReader.getProperties(bsaInstallDir + FILE_SEPARATOR + "agent.policy");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getProperties(String policyFilePath) {
        Properties p = new Properties();
        FileInputStream is = null;
        try {
            is = new FileInputStream(policyFilePath);
            p.load(is);
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException e) {
                    LOGGER.log(Level.SEVERE, e.getMessage(), e);
                }
            }
        }
        return p;
    }
}

