/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.blame;

import com.wily.introscope.agent.blame.IBlameStack;
import com.wily.introscope.agent.blame.IBoundaryBlameStack;
import com.wily.introscope.agent.blame.IComponentParameterCallback;
import com.wily.introscope.agent.blame.IStackType;
import com.wily.introscope.stat.blame.BlameStackSnapshot;
import com.wily.wilyassert.Assertion;
import java.util.HashMap;

public final class DuplicateHandlingBlameStack
implements IBoundaryBlameStack,
IBlameStack {
    private DuplicateHandlingStackElement[] fComponentStack;
    private final IBlameStack fDelegate;
    private int fComponentStackSize = 0;

    public DuplicateHandlingBlameStack(IBlameStack delegate) {
        Assertion.wilyAssert(false);
        this.fComponentStack = new DuplicateHandlingStackElement[50];
        this.fDelegate = delegate;
    }

    private IBlameStack getDelegate() {
        return this.fDelegate;
    }

    @Override
    public void IBlameStack_addComponent(String component) {
        if (this.push(component)) {
            this.getDelegate().IBlameStack_addComponent(component);
        }
    }

    @Override
    public void IBlameStack_addComponent(String component, String paramName, String paramValue) {
        if (this.push(component)) {
            this.getDelegate().IBlameStack_addComponent(component, paramName, paramValue);
        }
    }

    @Override
    public void IBlameStack_addComponent(String component, IComponentParameterCallback callback) {
        if (this.push(component)) {
            this.getDelegate().IBlameStack_addComponent(component, callback);
        }
    }

    @Override
    public void IBlameStack_addExtraParameter(String paramName, String paramValue) {
        this.getDelegate().IBlameStack_addExtraParameter(paramName, paramValue);
    }

    @Override
    public void IBlameStack_removeComponent(String component) {
        Assertion.wilyAssert(false);
        if (this.componentStackIsNotEmpty()) {
            Assertion.wilyAssert(false);
            if (!this.fComponentStack[this.fComponentStackSize - 1].checkRemoveDuplicate()) {
                Assertion.wilyAssert(false);
                --this.fComponentStackSize;
                this.getDelegate().IBlameStack_removeComponent(component);
            }
        }
    }

    private boolean componentStackIsNotEmpty() {
        return this.fComponentStackSize != 0;
    }

    @Override
    public BlameStackSnapshot IBlameStack_getSnapshot(String component) {
        return this.getDelegate().IBlameStack_getSnapshot(component);
    }

    @Override
    public boolean IBlameStack_isEmpty() {
        return this.getDelegate().IBlameStack_isEmpty();
    }

    @Override
    public void IBlameStack_tearDown() {
        this.getDelegate().IBlameStack_tearDown();
        this.fComponentStackSize = 0;
    }

    @Override
    public void setEndBoundary(String component) {
        this.fDelegate.setEndBoundary(component);
    }

    @Override
    public void setFrontBoundary(String component) {
        this.fDelegate.setFrontBoundary(component);
    }

    @Override
    public boolean hasFrontBoundary() {
        return this.fDelegate.hasFrontBoundary();
    }

    @Override
    public boolean noteBoundaryError() {
        return this.fDelegate.noteBoundaryError();
    }

    private boolean push(String component) {
        boolean handledDuplicate = false;
        if (this.componentStackIsNotEmpty()) {
            DuplicateHandlingStackElement stackElement = this.fComponentStack[this.fComponentStackSize - 1];
            handledDuplicate = stackElement.checkDuplicate(component);
        }
        if (!handledDuplicate) {
            if (this.fComponentStackSize == this.fComponentStack.length) {
                this.fComponentStack = this.resize(this.fComponentStack);
            }
            this.fComponentStack[this.fComponentStackSize] = new DuplicateHandlingStackElement(component);
            ++this.fComponentStackSize;
        }
        return !handledDuplicate;
    }

    private DuplicateHandlingStackElement[] resize(DuplicateHandlingStackElement[] componentStack) {
        int newSize = this.fComponentStack.length * 2;
        DuplicateHandlingStackElement[] newStack = new DuplicateHandlingStackElement[newSize];
        System.arraycopy(this.fComponentStack, 0, newStack, 0, this.fComponentStack.length);
        return newStack;
    }

    public String toString() {
        return "[DuplicateHandlingBlameStack: delgate=" + this.fDelegate + "]";
    }

    public IBlameStack debug_getDelegate() {
        return this.getDelegate();
    }

    @Override
    public String[] getDefaultBackendData() {
        return this.fDelegate.getDefaultBackendData();
    }

    @Override
    public void setDefaultBackendComponent(String componentToReplace, String backendComponent) {
        this.fDelegate.setDefaultBackendComponent(componentToReplace, backendComponent);
    }

    @Override
    public BlameStackSnapshot getDefaultBackendSnapshot() {
        return this.fDelegate.getDefaultBackendSnapshot();
    }

    @Override
    public void addRootParameter(String key, String value) {
        this.fDelegate.addRootParameter(key, value);
    }

    @Override
    public void endBoundaryPopped(String component) {
        this.fDelegate.endBoundaryPopped(component);
    }

    @Override
    public void frontBoundaryPopped(String component) {
        this.fDelegate.frontBoundaryPopped(component);
    }

    @Override
    public void addMapComponent(IStackType type, String component) {
        this.fDelegate.addMapComponent(type, component);
    }

    @Override
    public void removeMapComponent(IStackType type, String component) {
        this.fDelegate.removeMapComponent(type, component);
    }

    @Override
    public boolean getHeadFilteringStatus() {
        return this.fDelegate.getHeadFilteringStatus();
    }

    @Override
    public boolean shouldCurrentTraceBePropagated() {
        return this.fDelegate.shouldCurrentTraceBePropagated();
    }

    @Override
    public void addMapComponent(IStackType type, String component, String paramName, String paramVal) {
        this.fDelegate.addMapComponent(type, component, paramName, paramVal);
    }

    @Override
    public void addMapComponent(IStackType type, String component, HashMap<String, String> params) {
        this.fDelegate.addMapComponent(type, component, params);
    }

    @Override
    public void setComponentMetricPropagateFlag(String component, int flag) {
        if (this.fDelegate instanceof IBoundaryBlameStack) {
            ((IBoundaryBlameStack)((Object)this.fDelegate)).setComponentMetricPropagateFlag(component, flag);
        }
    }

    @Override
    public void popMapComponent(IStackType stackType, String component) {
    }

    private static final class DuplicateHandlingStackElement {
        public String fComponent;
        public int fCount;

        public DuplicateHandlingStackElement(String component) {
            this.setNewComponent(component);
        }

        final boolean checkDuplicate(String component) {
            if (this.getComponent().equals(component)) {
                ++this.fCount;
                return true;
            }
            return false;
        }

        final boolean checkRemoveDuplicate() {
            return --this.fCount > 0;
        }

        final void setNewComponent(String component) {
            this.fComponent = component;
            this.fCount = 1;
        }

        final String getComponent() {
            return this.fComponent;
        }

        final boolean hasDuplicate() {
            return this.fCount > 1;
        }
    }
}

