/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.connection;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.ConcurrentAgentMetricPool;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.connection.IAgentMetricCalculatorService;
import com.wily.introscope.agent.connection.NamedAgentBridgeInfo;
import com.wily.introscope.agent.stalemetric.StaleMetricService;
import com.wily.introscope.spec.metric.AgentMetric;
import com.wily.introscope.spec.metric.AgentMetricData;
import com.wily.introscope.spec.metric.BadlyFormedNameException;
import com.wily.introscope.stat.blame.BlameStackSnapshot;
import com.wily.introscope.stat.blame.BlameStackToCalledMetricConverter;
import com.wily.introscope.stat.timeslice.ATimeslicedValue;
import com.wily.introscope.stat.timeslice.IntegerTimeslicedValue;
import com.wily.util.ArrayUtilities;
import com.wily.util.adt.ConcurrentStripLockByKey;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.wilyassert.Assertion;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class ServerConnectionManager {
    private final AtomicBoolean isAgentBridgeInitialized = new AtomicBoolean(false);
    private static final Map sNamedAgentBridgeMetricCache = new ConcurrentHashMap();
    private static int sMetricClampSize = 10000;
    private final ConcurrentHashMap<String, NamedAgentBridgeInfo> fNamedAgentBridges = new ConcurrentHashMap();
    public static final String kBridgeRoutingPrefix = "!BRIDGE!";
    private static StaleMetricService fStaleMetricsService = null;
    private final IModuleFeedbackChannel fFeedbackChannel;
    private final BlameStackToCalledMetricConverter fMetricConverter;
    private IAgent fAgent;
    private final ConcurrentStripLockByKey lockByKey = new ConcurrentStripLockByKey();

    public ServerConnectionManager(IModuleFeedbackChannel feedback) {
        this.fFeedbackChannel = feedback;
        this.fMetricConverter = BlameStackToCalledMetricConverter.getInstance();
    }

    protected IAgent getAgent() {
        try {
            if (this.fAgent == null) {
                this.fAgent = AgentShim.getAgent();
            }
        }
        catch (AgentNotAvailableException agentNotAvailableException) {
            // empty catch block
        }
        return this.fAgent;
    }

    protected boolean isSpecialCaseTimeslice(ATimeslicedValue val) {
        return val.getType() == 385;
    }

    protected AgentMetricData[] getAllBindings(AgentMetricData[] timeslicedBindings, AgentMetricData[] calledBindings) {
        HashMap<AgentMetric, CachedTimesliceInfo> metricToTimeslices = null;
        AgentMetricData[] result = null;
        int nAggregatedAway = 0;
        for (int i = 0; i < timeslicedBindings.length; ++i) {
            AgentMetric metric;
            CachedTimesliceInfo info;
            ATimeslicedValue val = timeslicedBindings[i].getTimeslicedValue();
            if (!this.isSpecialCaseTimeslice(val)) continue;
            if (metricToTimeslices == null) {
                metricToTimeslices = new HashMap<AgentMetric, CachedTimesliceInfo>(2);
            }
            if ((info = (CachedTimesliceInfo)metricToTimeslices.get(metric = timeslicedBindings[i].getAgentMetric())) == null) {
                info = new CachedTimesliceInfo(i, timeslicedBindings[i], val.getClass());
                metricToTimeslices.put(metric, info);
            } else {
                ++nAggregatedAway;
                timeslicedBindings[i] = null;
            }
            info.timeslices.add(val);
        }
        if (nAggregatedAway == 0) {
            result = (AgentMetricData[])ArrayUtilities.append(timeslicedBindings, calledBindings, AgentMetricData.class);
        } else {
            for (CachedTimesliceInfo info : metricToTimeslices.values()) {
                AgentMetricData newData;
                ATimeslicedValue newVal = info.aggregate();
                timeslicedBindings[info.position] = newData = new AgentMetricData(info.metric.getAgentMetric(), info.metric.getFrequency(), newVal);
            }
            int timesliceLength = timeslicedBindings.length - nAggregatedAway;
            int newSize = timesliceLength + calledBindings.length;
            result = new AgentMetricData[newSize];
            int destIndex = 0;
            for (int i = 0; i < timeslicedBindings.length; ++i) {
                if (timeslicedBindings[i] == null) continue;
                result[destIndex++] = timeslicedBindings[i];
            }
            System.arraycopy(calledBindings, 0, result, destIndex, calledBindings.length);
        }
        return result;
    }

    protected void reportTimeslice(AgentMetricData[] timeslicedBindings, AgentMetric[] deadMetrics, int timesliceType) {
        ArrayList<AgentMetric> deadMetricsList = new ArrayList<AgentMetric>();
        this.getFeedbackChannel().trace(this.getModule(), "reportTimeslice, timeslice type =" + timesliceType);
        Object[] calledMetricBindings = this.fMetricConverter.generateBlamedMetricBindingsNonSync(this.getFeedbackChannel(), timeslicedBindings);
        if (deadMetrics != null && deadMetrics.length > 0) {
            deadMetricsList.addAll(Arrays.asList(deadMetrics));
        }
        AgentMetricData[] allbindings = null;
        try {
            allbindings = this.getAllBindings(timeslicedBindings, (AgentMetricData[])calledMetricBindings);
        }
        catch (Exception e) {
            this.fFeedbackChannel.error("An error occurred while filtering metrics");
            this.fFeedbackChannel.verbose(e);
            allbindings = (AgentMetricData[])ArrayUtilities.append(timeslicedBindings, calledMetricBindings, AgentMetricData.class);
        }
        if (timesliceType != 0) {
            if (this.getIsAgentBridgeInitialized().get()) {
                this.reportTimeslicesForNamedAgentBridges(allbindings, deadMetrics, timesliceType);
            } else {
                allbindings = this.getAgentMetricData(allbindings, deadMetricsList);
                if (fStaleMetricsService != null) {
                    try {
                        fStaleMetricsService.removeStaleMetrics(allbindings);
                    }
                    catch (Exception exp) {
                        this.fFeedbackChannel.warn("Failed to remove stale metrics: " + exp.toString());
                    }
                }
                this.addToReportingQueue(null, timesliceType, deadMetricsList, allbindings, null);
            }
        }
    }

    static Map separateMetricBindingArrays(AgentMetricData[] bindings, List regularBindings) throws BadlyFormedNameException {
        HashMap bindingsMap = new HashMap();
        for (int i = 0; i < bindings.length; ++i) {
            AgentMetricData b = bindings[i];
            if (b.getAgentMetricPrefix().getSegmentCount() > 0) {
                String firstSegment = b.getAgentMetricPrefix().getSegment(0);
                if (firstSegment.startsWith(kBridgeRoutingPrefix)) {
                    String name = firstSegment.substring(kBridgeRoutingPrefix.length());
                    ArrayList<AgentMetricData> l = (ArrayList<AgentMetricData>)bindingsMap.get(name);
                    if (l == null) {
                        l = new ArrayList<AgentMetricData>(100);
                        bindingsMap.put(name, l);
                    }
                    AgentMetric nm = ServerConnectionManager.getAgentBridgeMetric(b.getAgentMetric().getAttributeURL().substring(firstSegment.length() + 1), b.getAttributeType());
                    AgentMetricData nb = new AgentMetricData(nm, b.getFrequency(), b.getDataValue());
                    l.add(nb);
                    continue;
                }
                regularBindings.add(b);
                continue;
            }
            regularBindings.add(b);
        }
        return bindingsMap;
    }

    static Map separateMetricArrays(AgentMetric[] metrics, List regularMetrics) throws BadlyFormedNameException {
        HashMap metricsMap = new HashMap();
        for (int i = 0; i < metrics.length; ++i) {
            AgentMetric m = metrics[i];
            if (m.getAgentMetricPrefix().getSegmentCount() > 0) {
                String firstSegment = m.getAgentMetricPrefix().getSegment(0);
                if (firstSegment.startsWith(kBridgeRoutingPrefix)) {
                    String name = firstSegment.substring(kBridgeRoutingPrefix.length());
                    ArrayList<AgentMetric> l = (ArrayList<AgentMetric>)metricsMap.get(name);
                    if (l == null) {
                        l = new ArrayList<AgentMetric>();
                        metricsMap.put(name, l);
                    }
                    AgentMetric nm = ServerConnectionManager.getAgentBridgeMetric(m.getAttributeURL().substring(firstSegment.length() + 1), m.getAttributeType());
                    l.add(nm);
                    continue;
                }
                regularMetrics.add(m);
                continue;
            }
            regularMetrics.add(m);
        }
        return metricsMap;
    }

    private static AgentMetric getAgentBridgeMetric(String name, int metricType) throws BadlyFormedNameException {
        AgentMetric m = AgentMetric.kNullAgentMetric;
        if (sNamedAgentBridgeMetricCache != null) {
            m = (AgentMetric)sNamedAgentBridgeMetricCache.get(name);
            if (m == null) {
                if (sNamedAgentBridgeMetricCache.size() > sMetricClampSize) {
                    sNamedAgentBridgeMetricCache.clear();
                    sMetricClampSize = ServerConnectionManager.getMetricClampSize();
                }
                m = new AgentMetric(name, metricType);
                sNamedAgentBridgeMetricCache.put(name, m);
            }
            return m;
        }
        m = new AgentMetric(name, metricType);
        return m;
    }

    private void reportTimeslicesForNamedAgentBridges(AgentMetricData[] allbindings, AgentMetric[] deadMetrics, int timesliceType) {
        try {
            ArrayList regularArray = new ArrayList(100);
            AgentMetric[] emptyArray = new AgentMetric[]{};
            Map bindingsMap = ServerConnectionManager.separateMetricBindingArrays(allbindings, regularArray);
            Map deadMetricsMap = null;
            ArrayList<AgentMetric> regularDeadMetricArray = new ArrayList<AgentMetric>();
            if (deadMetrics != null && deadMetrics.length > 0) {
                deadMetricsMap = ServerConnectionManager.separateMetricArrays(deadMetrics, regularDeadMetricArray);
            }
            if (!regularArray.isEmpty()) {
                AgentMetricData[] array = regularArray.toArray(new AgentMetricData[0]);
                array = this.getAgentMetricData(array, regularDeadMetricArray);
                this.addToReportingQueue(null, timesliceType, regularDeadMetricArray, array, null);
            }
            for (Map.Entry bridgeEntry : bindingsMap.entrySet()) {
                String name = (String)bridgeEntry.getKey();
                List bindings = (List)bridgeEntry.getValue();
                NamedAgentBridgeInfo entry = this.getfNamedAgentBridges().get(name);
                this.reportNamedAgentMetrics(timesliceType, deadMetricsMap, name, bindings, entry);
            }
        }
        catch (BadlyFormedNameException e) {
            this.getFeedbackChannel().debug(this.getModule(), "Failed to build metric name: " + e.getMessage());
            this.getFeedbackChannel().debug(e);
        }
    }

    protected void reportQualifiedAgentMetrics(int timesliceType, Map deadMetricsMap, String name, List bindings, String qualifiedAgent) {
        AgentMetricData[] array = bindings.toArray(new AgentMetricData[0]);
        ArrayList<AgentMetric> deadList = deadMetricsMap != null ? (List)deadMetricsMap.get(name) : new ArrayList();
        array = this.getAgentMetricData(array, deadList);
        this.addToReportingQueue(name, timesliceType, deadList, array, qualifiedAgent);
    }

    private AgentMetricData[] getAgentMetricData(AgentMetricData[] array, List deadList) {
        IAgentMetricCalculatorService calcService = this.getAgent().IAgent_getAgentCalculatorService();
        if (calcService != null) {
            array = calcService.processTimeslice(array);
            AgentMetric[] deadCalculatedMetrics = calcService.computeDeadMetrics();
            if (deadCalculatedMetrics != null && deadCalculatedMetrics.length > 0) {
                deadList.addAll(Arrays.asList(deadCalculatedMetrics));
            }
        }
        return array;
    }

    public boolean shouldSendData() {
        return true;
    }

    private static int getMetricClampSize() {
        int value;
        AgentMetric.IAgentMetricPool pool = AgentMetric.getAgentMetricPool();
        int clamp = 50000;
        if (pool instanceof ConcurrentAgentMetricPool && (value = ((ConcurrentAgentMetricPool)pool).getMetricClamp()) > 0) {
            clamp = value;
        }
        return clamp;
    }

    protected abstract void connectNamedAgentBridge(NamedAgentBridgeInfo var1);

    protected abstract void reportNamedAgentMetrics(int var1, Map var2, String var3, List var4, NamedAgentBridgeInfo var5);

    protected abstract boolean addToReportingQueue(String var1, int var2, List<AgentMetric> var3, AgentMetricData[] var4, String var5);

    protected abstract Module getModule();

    IModuleFeedbackChannel getFeedbackChannel() {
        return this.fFeedbackChannel;
    }

    public static StaleMetricService getStaleMetricsService() {
        return fStaleMetricsService;
    }

    public static void setStaleMetricsService(StaleMetricService service) {
        fStaleMetricsService = service;
    }

    public AtomicBoolean getIsAgentBridgeInitialized() {
        return this.isAgentBridgeInitialized;
    }

    public ConcurrentHashMap<String, NamedAgentBridgeInfo> getfNamedAgentBridges() {
        return this.fNamedAgentBridges;
    }

    public ConcurrentStripLockByKey getLockByKey() {
        return this.lockByKey;
    }

    private static class CachedTimesliceInfo {
        List timeslices = new ArrayList(2);
        int position;
        AgentMetricData metric;
        Class specificType;

        CachedTimesliceInfo(int position, AgentMetricData metric, Class specificType) {
            this.position = position;
            this.metric = metric;
            this.specificType = specificType;
        }

        ATimeslicedValue aggregate() {
            Assertion.wilyAssert(this.specificType.equals(IntegerTimeslicedValue.class), "Illegal type: can't aggregate");
            return this.aggregateIntVals();
        }

        IntegerTimeslicedValue aggregateIntVals() {
            long startTime = 0L;
            long endTime = 0L;
            long dataPointCount = 0L;
            boolean dataIsAbsent = true;
            int val = 0;
            int min = Integer.MAX_VALUE;
            int max = Integer.MIN_VALUE;
            ATimeslicedValue example = null;
            for (Object obj : this.timeslices) {
                if (!(obj instanceof IntegerTimeslicedValue)) continue;
                IntegerTimeslicedValue iVal = (IntegerTimeslicedValue)obj;
                example = iVal;
                if (iVal.getStartTimestampInMillis() > startTime) {
                    startTime = iVal.getStartTimestampInMillis();
                }
                if (iVal.getStopTimestampInMillis() > endTime) {
                    endTime = iVal.getStopTimestampInMillis();
                }
                dataPointCount += iVal.getDataPointCount();
                dataIsAbsent &= iVal.dataIsAbsent();
                val += iVal.getValue();
                min = Math.min(min, iVal.getMinimum());
                max = Math.max(max, iVal.getMaximum());
            }
            return new IntegerTimeslicedValue(example.getType(), startTime, endTime, BlameStackSnapshot.kEmptyBlameStackSnapshot, dataPointCount, dataIsAbsent, val, min, max);
        }
    }
}

