/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.environment;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.connection.IServerConnectionNotification;
import com.wily.introscope.agent.connection.IsengardServerConnectionManager;
import com.wily.introscope.agent.connection.NamedAgentBridgeInfo;
import com.wily.introscope.agent.enterprise.IServerConnectionObserver;
import com.wily.introscope.agent.environment.AgentInformationReporter;
import com.wily.introscope.agent.environment.CallbackAlreadySetException;
import com.wily.introscope.agent.environment.CallbackFailedPermanentlyException;
import com.wily.introscope.agent.environment.CallbackFailedTemporarilyException;
import com.wily.introscope.agent.environment.IAppserverEnvironmentInfoCallback;
import com.wily.introscope.agent.environment.NetworkInterfaceDescriptor;
import com.wily.introscope.agent.environment.NetworkInterfaceDescriptorFactory;
import com.wily.introscope.agent.environment.NetworkInterfaceSpecifier;
import com.wily.introscope.agent.environment.SubNetworks;
import com.wily.introscope.spec.metric.AgentMetric;
import com.wily.introscope.spec.server.transactiontrace.ITransactionTraceFilter;
import com.wily.util.INameChangeListener;
import com.wily.util.StringUtils;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.heartbeat.WaitAndExecuteBehavior;
import com.wily.util.properties.hot.BooleanConfigurationProperty;
import com.wily.util.properties.hot.ConfigurationManager;
import com.wily.util.properties.hot.ConfigurationProperty;
import com.wily.util.properties.hot.IntegerConfigurationProperty;
import com.wily.util.resource.IResource;
import com.wily.util.text.IStringLocalizer;
import com.wily.util.text.SimpleLocalizableMessage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class EnvironmentAdministrator {
    private static final String APMENV_INTROSCOPE_AGENT_POD_CONTAINER_NAME = "apmenv_introscope_agent_pod_container_name";
    private static final String APMENV_INTROSCOPE_AGENT_POD_IPADDRESS = "apmenv_introscope_agent_pod_ipaddress";
    private static final String APMENV_INTROSCOPE_AGENT_POD_NAME = "apmenv_introscope_agent_pod_name";
    private static final String APMENV_INTROSCOPE_AGENT_POD_NAMESPACE = "apmenv_introscope_agent_pod_namespace";
    private static final String APMENV_INTROSCOPE_AGENT_MODE = "apmenv_introscope_agent_mode";
    private static final String APMENV_INTROSCOPE_AGENT_CONTAINER_ID = "apmenv_introscope_agent_container_id";
    private static final String UNKNOWN_HOST = "Unknown Host";
    private static final String UNKNOWN_IP_ADDRESS = "Unknown IP Address";
    private final Module module;
    private final IModuleFeedbackChannel feedback;
    private final String fHostname;
    private final String fFullyQualifiedHostName;
    private final String fIPAddress;
    private ContainerInfo containerInfo;
    private IAppserverEnvironmentInfoCallback fAppserverEnvironmentInfo;
    private final Object fAppserverEnvironmentInfoLock;
    private final boolean lookupCanonicalHostname;
    private NetworkInterfaceSpecifier networkInterfaceSpecifier;
    private final NetworkInterfaceDescriptorFactory nidFactory;
    private final List fEnvironmentChangeListeners;
    private final int ipFamilyOrder;
    private final String subNetworksPath;
    private final String fallbackDomainName;
    private final IAgent fAgent;
    private volatile boolean fShouldSendEnvironmentVariables;
    private final AgentInformationReporter reporter;
    private static int sSendEnvironmentCycleTime = 30000;

    public EnvironmentAdministrator(IAgent agent) {
        InputStream subNetworksStream;
        IStringLocalizer localizer;
        block11: {
            this.fAppserverEnvironmentInfo = null;
            this.fAppserverEnvironmentInfoLock = new Object();
            this.networkInterfaceSpecifier = null;
            this.fEnvironmentChangeListeners = new ArrayList();
            this.fShouldSendEnvironmentVariables = false;
            this.fAgent = agent;
            this.module = this.fAgent.IAgent_getModule();
            this.feedback = this.fAgent.IAgent_getModuleFeedback();
            localizer = this.fAgent.IAgent_getStringLocalizer();
            ConfigurationManager configManager = this.fAgent.IAgent_getConfigurationManager();
            IResource profileResource = this.fAgent.IAgent_getConfigurationResource();
            this.containerInfo = this.retrieveContainerInfo();
            this.feedback.info(this.module, "container info: " + this.containerInfo);
            IntegerConfigurationProperty sendCycleTimeProperty = new IntegerConfigurationProperty("introscope.agent.report.agent.vertex.interval", 30000, null, null, false, true, this.feedback, this.module, localizer);
            configManager.add(sendCycleTimeProperty);
            sSendEnvironmentCycleTime = (Integer)sendCycleTimeProperty.getValue();
            BooleanConfigurationProperty lookupCanonicalHostnameParam = this.createLookupCanonicalHostname(this.module, this.feedback, localizer);
            configManager.add(lookupCanonicalHostnameParam);
            this.lookupCanonicalHostname = (Boolean)lookupCanonicalHostnameParam.getValue();
            ConfigurationProperty fallbackDomainNameParam = this.createFallbackDomainNameConfigProperty(this.module, this.feedback, localizer);
            configManager.add(fallbackDomainNameParam);
            this.fallbackDomainName = (String)fallbackDomainNameParam.getValue();
            this.feedback.debug(this.module, "EnvironmentAdministrator:-fallbackDomainName=" + this.fallbackDomainName);
            String fqdn = this.calculateSystemFullyQualifiedDomainName();
            this.feedback.debug(this.module, "EnvironmentAdministrator:-fqdn=" + fqdn);
            if (fqdn.indexOf(46) < 0 && !StringUtils.isEmpty(this.fallbackDomainName)) {
                fqdn = fqdn + "." + this.fallbackDomainName;
            }
            this.fFullyQualifiedHostName = fqdn;
            this.feedback.debug(this.module, "EnvironmentAdministrator:-fFullyQualifiedHostName=" + this.fFullyQualifiedHostName);
            ConfigurationProperty hostNameProperty = new ConfigurationProperty("introscope.agent.hostName", null, null, null, false, true, this.feedback, this.module, localizer);
            configManager.add(hostNameProperty);
            String overridenHostName = (String)hostNameProperty.getValue();
            this.feedback.debug(this.module, "EnvironmentAdministrator:-overridenHostName=" + overridenHostName);
            this.fHostname = overridenHostName != null && overridenHostName.length() > 0 ? overridenHostName : this.calculateHostname();
            this.feedback.debug(this.module, "EnvironmentAdministrator:-fHostname=" + this.fHostname);
            this.fIPAddress = this.calculateIPAddress(localizer);
            this.feedback.debug(this.module, "EnvironmentAdministrator:-fIPAddress=" + this.fIPAddress);
            ConfigurationProperty netInterfaceNameProperty = new ConfigurationProperty("introscope.agent.primary.net.interface.name", null, null, null, true, true, this.feedback, this.module, localizer){

                @Override
                public Object convert(String s) {
                    return new NetworkInterfaceSpecifier(s);
                }

                @Override
                public void set(Object v) {
                    EnvironmentAdministrator.this.setNetworkInterfaceSpecifier((NetworkInterfaceSpecifier)v);
                    EnvironmentAdministrator.this.notifyEnvironmentChangeListeners();
                }
            };
            configManager.add(netInterfaceNameProperty);
            IntegerConfigurationProperty ipFamilyOrderParam = this.createIPFamilyOrderConfigProperty(this.module, this.feedback, localizer);
            configManager.add(ipFamilyOrderParam);
            this.ipFamilyOrder = (Integer)ipFamilyOrderParam.getValue();
            ConfigurationProperty subNetworksPathParam = this.createSubNetworksPathConfigProperty(this.module, this.feedback, localizer);
            configManager.add(subNetworksPathParam);
            this.subNetworksPath = (String)subNetworksPathParam.getValue();
            subNetworksStream = null;
            if (this.subNetworksPath == null) {
                subNetworksStream = SubNetworks.class.getResourceAsStream("SubNetworks.txt");
            } else {
                File snFile = new File(this.subNetworksPath);
                if (!snFile.isAbsolute()) {
                    snFile = new File(new File(profileResource.IResource_getLocation()).getParent() + File.separator + this.subNetworksPath);
                }
                if (profileResource.IResource_isFileResource()) {
                    try {
                        subNetworksStream = new FileInputStream(snFile);
                    }
                    catch (FileNotFoundException e) {
                        if (!this.feedback.isDebugEnabled(this.module)) break block11;
                        this.feedback.debug(this.module, localizer.IStringLocalizer_getFormattedLocalizedString("Agent_SubNetworks_File_Not_Found", snFile.getName()));
                    }
                }
            }
        }
        if (subNetworksStream == null && this.feedback.isDebugEnabled(this.module)) {
            this.feedback.debug(this.module, "Sub networks definitions not found");
        }
        this.nidFactory = new NetworkInterfaceDescriptorFactory(this.module, this.feedback, localizer, subNetworksStream);
        if (subNetworksStream != null) {
            try {
                subNetworksStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.reporter = new AgentInformationReporter(this, agent);
        this.initializeEnvironmentPropertiesListenersAndBehavior();
    }

    String calculateSystemFullyQualifiedDomainName() {
        try {
            InetAddress local = InetAddress.getLocalHost();
            return local.getCanonicalHostName();
        }
        catch (Exception e) {
            return UNKNOWN_HOST;
        }
    }

    String calculateSystemSimpleHostName() {
        try {
            InetAddress local = InetAddress.getLocalHost();
            this.feedback.debug(this.module, "EnvironmentAdministrator:-calculateHostname.local=" + local.toString() + " hostname=" + local.getHostName());
            return EnvironmentAdministrator.trimDomain(local.getHostName());
        }
        catch (Exception e) {
            return UNKNOWN_HOST;
        }
    }

    private String calculateHostname() {
        try {
            String hostName = this.calculateSystemSimpleHostName();
            if (this.containerInfo != null && this.fAgent.IAgent_getIndexedProperties().getBooleanProperty("introscope.agent.container.hostname.override", true)) {
                if (ContainerOrchestrationSystem.K8s == this.containerInfo.getOrchestrator()) {
                    boolean useReplicaSet = !this.fAgent.IAgent_getIndexedProperties().getBooleanProperty("introscope.agent.k8s.hostname.override.workload", true);
                    K8sHostNameResolver resolver = new K8sHostNameResolver(useReplicaSet);
                    return resolver.resolve(hostName);
                }
                return this.fAgent.IAgent_getIndexedProperties().getProperty("introscope.agent.container.hostname.default", "ContainerHost");
            }
            return this.lookupCanonicalHostname ? this.fFullyQualifiedHostName : hostName;
        }
        catch (Exception e) {
            return UNKNOWN_HOST;
        }
    }

    private String calculateIPAddress(IStringLocalizer localizer) {
        try {
            InetAddress local = InetAddress.getLocalHost();
            return local.getHostAddress();
        }
        catch (Exception e) {
            ConfigurationProperty defaultIP = new ConfigurationProperty("introscope.agent.defaultIP", null, null, null, false, true, this.feedback, this.module, localizer);
            String ip = (String)defaultIP.getValue();
            if (ip == null || "".equals(ip)) {
                this.feedback.warn("Unable to calculate IP Address. Set the default IP to the property introscope.agent.defaultIP");
                return UNKNOWN_IP_ADDRESS;
            }
            this.feedback.info("DefaultIP =" + defaultIP);
            return (String)defaultIP.getValue();
        }
    }

    private BooleanConfigurationProperty createLookupCanonicalHostname(Module module, IModuleFeedbackChannel feedback, IStringLocalizer localizer) {
        return new BooleanConfigurationProperty("introscope.agent.display.hostName.as.fqdn", Boolean.FALSE, "Agent_HostName_As_FQDN", false, false, feedback, module, localizer){};
    }

    private IntegerConfigurationProperty createIPFamilyOrderConfigProperty(Module module, IModuleFeedbackChannel feedback, IStringLocalizer localizer) {
        return new IntegerConfigurationProperty("introscope.agent.ip.family.order", 1, null, null, false, false, feedback, module, localizer){};
    }

    private ConfigurationProperty createSubNetworksPathConfigProperty(Module module, IModuleFeedbackChannel feedback, IStringLocalizer localizer) {
        return new ConfigurationProperty("introscope.agent.subnetworks.path", null, null, null, false, true, feedback, module, localizer){};
    }

    private ConfigurationProperty createFallbackDomainNameConfigProperty(Module module, IModuleFeedbackChannel feedback, IStringLocalizer localizer) {
        return new ConfigurationProperty("introscope.agent.fallback.domain.name", null, null, null, false, true, feedback, module, localizer){};
    }

    public static String trimDomain(String hostname) {
        int dotIndex = hostname.indexOf(46);
        if (dotIndex > 0) {
            hostname = hostname.substring(0, dotIndex);
        }
        return hostname;
    }

    public ContainerInfo getContainerInfo() {
        return this.containerInfo;
    }

    public String getContainerId() {
        String containerId = this.getPodMetadataProperty(APMENV_INTROSCOPE_AGENT_CONTAINER_ID);
        if (containerId != null) {
            return containerId;
        }
        if (this.containerInfo != null) {
            return this.containerInfo.getContainerId();
        }
        return null;
    }

    public String getPodNameSpace() {
        return this.getPodMetadataProperty(APMENV_INTROSCOPE_AGENT_POD_NAMESPACE);
    }

    public String getPodName() {
        return this.getPodMetadataProperty(APMENV_INTROSCOPE_AGENT_POD_NAME);
    }

    public String getAgentMode() {
        return this.getPodMetadataProperty(APMENV_INTROSCOPE_AGENT_MODE);
    }

    public String getPodIpAddr() {
        return this.getPodMetadataProperty(APMENV_INTROSCOPE_AGENT_POD_IPADDRESS);
    }

    public String getPodContainerName() {
        return this.getPodMetadataProperty(APMENV_INTROSCOPE_AGENT_POD_CONTAINER_NAME);
    }

    public String getPodMetadataProperty(String property) {
        String value = System.getenv(property);
        if (value != null && !value.trim().isEmpty()) {
            return value.trim();
        }
        value = System.getProperty(property);
        if (value != null && !value.trim().isEmpty()) {
            return value.trim();
        }
        return null;
    }

    public String getHostname() {
        return this.fHostname;
    }

    public String getFullyQualifiedHostname() {
        return this.fFullyQualifiedHostName;
    }

    public String getIPAddress() {
        return this.fIPAddress;
    }

    public boolean shouldLookupCanonicalHostname() {
        return this.lookupCanonicalHostname;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAppserverEnvironmentInfoCallback(IAppserverEnvironmentInfoCallback appInfo) throws CallbackAlreadySetException {
        Object object = this.fAppserverEnvironmentInfoLock;
        synchronized (object) {
            if (this.fAppserverEnvironmentInfo != null) {
                throw new CallbackAlreadySetException();
            }
            this.feedback.info(this.module, "App server info callback has been set.");
            this.fAppserverEnvironmentInfo = appInfo;
        }
    }

    public String getAppserverGeneratedAgentName() throws CallbackFailedTemporarilyException, CallbackFailedPermanentlyException {
        Object object = this.fAppserverEnvironmentInfoLock;
        synchronized (object) {
            if (this.fAppserverEnvironmentInfo == null) {
                throw new CallbackFailedTemporarilyException(new SimpleLocalizableMessage("Agent_Appserver_Agent_Naming_Callback_Not_Set_Message"));
            }
            try {
                this.feedback.debug(this.module, "Attempting to get agent name.");
                return this.fAppserverEnvironmentInfo.IAppserverEnvironmentInfoCallback_getAgentName();
            }
            catch (CallbackFailedTemporarilyException cfte) {
                throw cfte;
            }
            catch (CallbackFailedPermanentlyException cfpe) {
                throw cfpe;
            }
        }
    }

    public Map calculateNetInterfaceProperties() {
        NetworkInterfaceSpecifier requiredInterface = this.getNetworkInterfaceSpecifier();
        NetworkInterfaceDescriptor netInterface = null;
        if (requiredInterface == null) {
            NetworkInterfaceDescriptor[] nids = this.nidFactory.getAllNetworkInterfaces(this.ipFamilyOrder);
            if (nids != null) {
                netInterface = nids[0];
            }
        } else {
            netInterface = this.nidFactory.findNetworkInterface(requiredInterface);
        }
        HashMap<String, String> result = new HashMap<String, String>();
        if (netInterface != null) {
            String domainName;
            if (netInterface.getIpAddressFamily() != null && netInterface.getIpAddressAsString() != null) {
                result.put(netInterface.getIpAddressFamily(), netInterface.getIpAddressAsString());
            }
            if (netInterface.getMacAddress() != null) {
                result.put("MacAddress", netInterface.getMacAddress());
            }
            if (netInterface.getHostName() != null) {
                result.put("HostName", netInterface.getHostName());
            }
            if (StringUtils.isEmpty(domainName = netInterface.getDomainName())) {
                domainName = this.fallbackDomainName;
            }
            if (domainName != null) {
                result.put("DomainName", domainName);
            }
        } else {
            this.feedback.warn(this.module, "No network interfaces found, no primary network interface will be configured");
        }
        if (this.feedback.isDebugEnabled()) {
            if (result.size() == 0) {
                this.feedback.debug(this.module, "Environment empty");
            } else {
                Set keys = result.keySet();
                for (String key : keys) {
                    String value = (String)result.get(key);
                    this.feedback.debug(this.module, "Environment: '" + key + "'='" + value + "'");
                }
            }
        }
        return result;
    }

    public synchronized void setNetworkInterfaceSpecifier(NetworkInterfaceSpecifier netInterfaceName) {
        this.networkInterfaceSpecifier = netInterfaceName;
    }

    public synchronized NetworkInterfaceSpecifier getNetworkInterfaceSpecifier() {
        return this.networkInterfaceSpecifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEnvironmentChangeListener(IEnvironmentChangeListener listener) {
        List list = this.fEnvironmentChangeListeners;
        synchronized (list) {
            this.fEnvironmentChangeListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyEnvironmentChangeListeners() {
        List list = this.fEnvironmentChangeListeners;
        synchronized (list) {
            for (IEnvironmentChangeListener listener : this.fEnvironmentChangeListeners) {
                listener.environmentChanged();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEnvironmentChangeListener(IEnvironmentChangeListener listener) {
        List list = this.fEnvironmentChangeListeners;
        synchronized (list) {
            this.fEnvironmentChangeListeners.remove(listener);
        }
    }

    private void initializeEnvironmentPropertiesListenersAndBehavior() {
        if (sSendEnvironmentCycleTime == 0) {
            return;
        }
        final INameChangeListener listener1 = new INameChangeListener(){

            @Override
            public void INameChangeListener_nameChanged(String newName) {
                EnvironmentAdministrator.this.fShouldSendEnvironmentVariables = true;
            }
        };
        final IEnvironmentChangeListener listener2 = new IEnvironmentChangeListener(){

            @Override
            public void environmentChanged() {
                EnvironmentAdministrator.this.fShouldSendEnvironmentVariables = true;
            }
        };
        final IServerConnectionObserver observer = new IServerConnectionObserver(){

            @Override
            public void serverConnected() {
                EnvironmentAdministrator.this.fShouldSendEnvironmentVariables = true;
            }

            @Override
            public void serverDisconnected() {
                EnvironmentAdministrator.this.fShouldSendEnvironmentVariables = false;
            }

            @Override
            public void serverConnectionCycleFailed(int cycleCount) {
                EnvironmentAdministrator.this.fShouldSendEnvironmentVariables = false;
            }

            @Override
            public void agentControlSetReportingState(boolean report) {
            }

            @Override
            public void agentControlStopReportingMetric(AgentMetric metric) {
            }

            @Override
            public void agentControlStartReportingMetric(AgentMetric metric) {
            }

            @Override
            public void agentControlAddTTFilter(ITransactionTraceFilter filter) {
            }

            @Override
            public void agentControlRemoveTTFilter(ITransactionTraceFilter filter) {
            }
        };
        final IServerConnectionNotification notification = new IServerConnectionNotification(){

            @Override
            public void connectionUp() {
                EnvironmentAdministrator.this.fShouldSendEnvironmentVariables = true;
            }

            @Override
            public void connectionDown() {
                EnvironmentAdministrator.this.fShouldSendEnvironmentVariables = false;
            }
        };
        new WaitAndExecuteBehavior(this.fAgent.IAgent_getCommonHeartbeat(), sSendEnvironmentCycleTime, "Check Connection for Send Environment App Map Edge"){

            @Override
            protected boolean execute() {
                IsengardServerConnectionManager m = EnvironmentAdministrator.this.fAgent.IAgent_getIsengardServerConnection();
                if (m != null && m.getConnectedServer() != null && m.getConnectedServer().isConnected()) {
                    EnvironmentAdministrator.this.fAgent.IAgent_addNameChangeListener(listener1);
                    EnvironmentAdministrator.this.fAgent.IAgent_addNegotiatedNameChangeListener(listener1);
                    EnvironmentAdministrator.this.fAgent.IAgent_getEnvironmentAdministrator().addEnvironmentChangeListener(listener2);
                    EnvironmentAdministrator.this.fAgent.IAgent_getIsengardServerConnection().addConnectionObserver(observer);
                    EnvironmentAdministrator.this.fAgent.IAgent_getIsengardServerConnection().addConnectionObserver(notification);
                    EnvironmentAdministrator.this.fShouldSendEnvironmentVariables = true;
                    return true;
                }
                return false;
            }
        };
        new WaitAndExecuteBehavior(this.fAgent.IAgent_getCommonHeartbeat(), sSendEnvironmentCycleTime, "Send Environment App Map Edge"){

            @Override
            protected boolean execute() {
                if (EnvironmentAdministrator.this.fShouldSendEnvironmentVariables) {
                    EnvironmentAdministrator.this.reporter.reportEnvironmentInformation();
                    EnvironmentAdministrator.this.reporter.reportAllNamedAgentBridgeInformation();
                }
                return false;
            }
        };
    }

    public void reportNamedAgentBridgeInformation(NamedAgentBridgeInfo info) {
        this.reporter.reportNamedAgentBridgeInformation(info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ContainerInfo retrieveContainerInfo() {
        String containerId = this.getContainerId();
        String podNamespace = this.getPodNameSpace();
        String podName = this.getPodName();
        String podContainerName = this.getPodContainerName();
        String podIpAddr = this.getPodIpAddr();
        if (containerId != null) {
            if (podNamespace == null) {
                return new ContainerInfo(containerId, ContainerOrchestrationSystem.DOCKER);
            }
            return new ContainerInfo(containerId, ContainerOrchestrationSystem.K8s);
        }
        if (podNamespace != null && podName != null && podContainerName != null && podIpAddr != null) {
            return null;
        }
        Object[] kCommand = new String[]{"bash", "-c", "stat -fc %T /sys/fs/cgroup/"};
        ContainerInfo ctInfo = null;
        BufferedReader buffer = null;
        String cGroup = null;
        try {
            String line;
            ProcessBuilder processBuilder = new ProcessBuilder((String[])kCommand);
            Process p = processBuilder.start();
            this.feedback.info(this.module, " Execution of command " + Arrays.toString(kCommand));
            buffer = new BufferedReader(new InputStreamReader(p.getInputStream(), "UTF-8"));
            StringBuilder outputBuilder = new StringBuilder();
            while ((line = buffer.readLine()) != null) {
                outputBuilder.append(line);
                this.feedback.debug(this.module, " Got the Line" + line);
            }
            cGroup = outputBuilder.toString();
            int exitCode = p.waitFor();
            this.feedback.info(this.module, "Command exited with code: " + exitCode);
            if (exitCode != 0) {
                ContainerInfo containerInfo = null;
                return containerInfo;
            }
            if (cGroup.equalsIgnoreCase("tmpfs")) {
                ctInfo = this.createContainerInfoInstance();
                if (ctInfo == null) {
                    ctInfo = this.createContainerInfoInstanceV2();
                }
            } else if (cGroup.equalsIgnoreCase("cgroup2fs")) {
                ctInfo = this.createContainerInfoInstanceV2();
                if (ctInfo == null) {
                    ctInfo = this.createContainerInfoInstance();
                }
            } else {
                this.feedback.warn(this.module, "Defaulting to cgroupV2 to retrieve ContainerID");
                ctInfo = this.createContainerInfoInstanceV2();
            }
            ContainerInfo containerInfo = ctInfo;
            return containerInfo;
        }
        catch (Throwable e) {
            this.feedback.debug(this.module, e.getMessage());
            this.feedback.trace(this.module, e.getMessage(), e);
        }
        finally {
            if (buffer != null) {
                try {
                    buffer.close();
                }
                catch (IOException e) {
                    this.feedback.debug(this.module, e.getMessage());
                    this.feedback.trace(this.module, e.getMessage(), e);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ContainerInfo createContainerInfoInstanceV2() {
        ArrayList<String> lines = new ArrayList<String>();
        Pattern CONTAINER_ID_RE = Pattern.compile("^[0-9a-f]{64}$");
        Object[] kCommand = new String[]{"cat", "/proc/self/mountinfo"};
        BufferedReader buffer = null;
        try {
            String fContainerId;
            String linec;
            ProcessBuilder processBuilder = new ProcessBuilder((String[])kCommand);
            Process p = processBuilder.start();
            this.feedback.info(this.module, " Execution of command " + Arrays.toString(kCommand));
            buffer = new BufferedReader(new InputStreamReader(p.getInputStream(), "UTF-8"));
            while ((linec = buffer.readLine()) != null) {
                lines.add(linec);
                this.feedback.debug(this.module, "Got the line V2 :" + linec);
            }
            int exitCode = p.waitFor();
            this.feedback.info(this.module, "Command exited with code: " + exitCode);
            if (exitCode != 0) {
                ContainerInfo containerInfo = null;
                return containerInfo;
            }
            boolean seen = false;
            Matcher acc = null;
            for (String line : lines) {
                if (!line.contains("/containers/")) continue;
                this.feedback.debug(this.module, " Got the line V2 :" + line);
                for (String s : line.split("/")) {
                    Matcher matchered = CONTAINER_ID_RE.matcher(s);
                    if (!matchered.matches()) continue;
                    if (!seen) {
                        seen = true;
                        acc = matchered;
                        continue;
                    }
                    acc = matchered;
                }
            }
            String string = fContainerId = seen ? acc.group(0) : null;
            if (fContainerId != null) {
                this.feedback.info(this.module, " Got the containerId V2 " + fContainerId);
                ContainerInfo containerInfo = new ContainerInfo(fContainerId, seen ? ContainerOrchestrationSystem.K8s : ContainerOrchestrationSystem.DOCKER);
                return containerInfo;
            }
        }
        catch (Throwable e) {
            this.feedback.debug(this.module, e.getMessage());
            this.feedback.trace(this.module, e.getMessage(), e);
        }
        finally {
            if (buffer != null) {
                try {
                    buffer.close();
                }
                catch (IOException e) {
                    this.feedback.debug(this.module, e.getMessage());
                    this.feedback.trace(this.module, e.getMessage(), e);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ContainerInfo createContainerInfoInstance() {
        Object[] kCommand = new String[]{"cat", "/proc/self/cgroup"};
        String kDocker = "docker-";
        String kScope = ".scope";
        String kCrio = "crio-";
        String kK8sCRIContainerd = "cri-containerd";
        String kK8sCRIContainerdV1 = "cri-containerd-";
        BufferedReader buffer = null;
        try {
            ProcessBuilder processBuilder = new ProcessBuilder((String[])kCommand);
            Process p = processBuilder.start();
            this.feedback.debug(this.module, " Execution of command " + Arrays.toString(kCommand));
            buffer = new BufferedReader(new InputStreamReader(p.getInputStream(), "UTF-8"));
            String line = null;
            while ((line = buffer.readLine()) != null) {
                this.feedback.debug(this.module, " Got the line " + line);
                if (line.isEmpty()) continue;
                String delimeter = "/";
                if (line.contains("cri-containerd:")) {
                    delimeter = ":";
                }
                int index = line.lastIndexOf(delimeter) + 1;
                int length = line.length();
                if (index == -1 || index == length) continue;
                String fContainerId = line.substring(index, length);
                if ((fContainerId = fContainerId.replaceAll("docker-", "").replaceAll(".scope", "").replaceAll("crio-", "").replaceAll("cri-containerd-", "").replaceAll("cri-containerd", "")).length() != 64) continue;
                this.feedback.info(this.module, " Got the containerId V1" + fContainerId);
                ContainerInfo containerInfo = new ContainerInfo(fContainerId, line.contains("kube") ? ContainerOrchestrationSystem.K8s : ContainerOrchestrationSystem.DOCKER);
                return containerInfo;
            }
            int exitCode = p.waitFor();
            this.feedback.info(this.module, "Command exited with code: " + exitCode);
            if (exitCode != 0) {
                ContainerInfo containerInfo = null;
                return containerInfo;
            }
        }
        catch (Throwable e) {
            this.feedback.debug(this.module, e.getMessage());
            this.feedback.trace(this.module, e.getMessage(), e);
        }
        finally {
            if (buffer != null) {
                try {
                    buffer.close();
                }
                catch (IOException e) {
                    this.feedback.debug(this.module, e.getMessage());
                    this.feedback.trace(this.module, e.getMessage(), e);
                }
            }
        }
        return null;
    }

    static class K8sHostNameResolver {
        private static final String DEPLOYMENT_REGEX = "((.*)-([0-9a-f]{9,10}))-([0-9a-z]{5})";
        private static final String DAEMONSET__REGEX = "(.*)-([0-9a-z]{5})";
        private final Pattern deploymentPattern = Pattern.compile("((.*)-([0-9a-f]{9,10}))-([0-9a-z]{5})");
        private final Pattern daemonsetPattern = Pattern.compile("(.*)-([0-9a-z]{5})");
        private final String deploymentValue;
        private final String daemonsetValue;

        public K8sHostNameResolver(String deploymentSelector, String daemonSelector) {
            this.deploymentValue = deploymentSelector;
            this.daemonsetValue = daemonSelector;
        }

        public K8sHostNameResolver(boolean shouldSelectReplicaSet) {
            this(shouldSelectReplicaSet ? "{1}" : "{2}", "{1}");
        }

        public K8sHostNameResolver() {
            this(false);
        }

        public String resolve(String podName) {
            Matcher m = this.deploymentPattern.matcher(podName);
            if (m.matches()) {
                return this.resolveValue(this.deploymentValue, m);
            }
            m = this.daemonsetPattern.matcher(podName);
            if (m.matches()) {
                return this.resolveValue(this.daemonsetValue, m);
            }
            return podName;
        }

        private String resolveValue(String value, Matcher matcher) {
            String result = value;
            for (int i = 0; i < matcher.groupCount(); ++i) {
                result = result.replaceAll("\\{" + i + "\\}", matcher.group(i));
            }
            return result;
        }
    }

    private class ContainerInfo {
        private final String containerId;
        private final ContainerOrchestrationSystem orchestrator;

        public ContainerInfo(String containerId, ContainerOrchestrationSystem orchestrator) {
            this.containerId = containerId;
            this.orchestrator = orchestrator;
        }

        public String getContainerId() {
            return this.containerId;
        }

        public ContainerOrchestrationSystem getOrchestrator() {
            return this.orchestrator;
        }

        public String toString() {
            return "ContainerInfo [containerId=" + this.containerId + ", orchestrator=" + (Object)((Object)this.orchestrator) + "]";
        }
    }

    private static enum ContainerOrchestrationSystem {
        K8s,
        DOCKER;

    }

    public static interface IEnvironmentChangeListener {
        public void environmentChanged();
    }
}

