/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.event;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.event.EventNoticerLoader;
import com.wily.introscope.agent.event.IEventNoticer;
import com.wily.introscope.agent.extension.DuplicateDynamicClassException;
import com.wily.introscope.agent.extension.InvalidDynamicClassException;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.text.IStringLocalizer;
import java.util.HashMap;
import java.util.Map;

public final class EventAdministrator {
    private final IAgent fAgent;
    private final Map fEventNoticers;
    private final EventNoticerLoader fEventNoticerLoader;

    public EventAdministrator(IAgent agent) {
        this.fAgent = agent;
        this.fEventNoticers = new HashMap();
        this.fEventNoticerLoader = new EventNoticerLoader(agent);
    }

    private IAgent getAgent() {
        return this.fAgent;
    }

    private IModuleFeedbackChannel getModuleFeedback() {
        return this.getAgent().IAgent_getModuleFeedback();
    }

    private IStringLocalizer getStringLocalizer() {
        return this.getAgent().IAgent_getStringLocalizer();
    }

    public final void registerEventNoticer(String eventNoticerName, Class eventNoticerClass, IStringLocalizer eventNoticerLocalizer) throws DuplicateDynamicClassException, InvalidDynamicClassException {
        this.fEventNoticerLoader.register(null, eventNoticerName, eventNoticerClass, eventNoticerLocalizer);
    }

    public final void noticeEvent(String probeClassName, String probeMethodName, String probeMethodDescriptor, String eventNoticingClass, String eventType, Object eventSpecificReference, String eventSpecificData, String eventSpecificData2) {
        try {
            IEventNoticer noticer = this.loadEventNoticer(eventNoticingClass);
            if (noticer != null) {
                noticer.IEventNoticer_noticeEvent(probeClassName, probeMethodName, probeMethodDescriptor, eventType, eventSpecificReference, eventSpecificData, eventSpecificData2);
            }
        }
        catch (Exception e) {
            this.getModuleFeedback().error(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Event_Noticer_Running_Error_Message", eventNoticingClass));
            this.getModuleFeedback().verbose(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IEventNoticer loadEventNoticer(String eventNoticingClass) throws Exception {
        IEventNoticer noticer = (IEventNoticer)this.fEventNoticers.get(eventNoticingClass);
        if (noticer == null) {
            Map map = this.fEventNoticers;
            synchronized (map) {
                noticer = (IEventNoticer)this.fEventNoticers.get(eventNoticingClass);
                if (noticer == null && (noticer = this.fEventNoticerLoader.loadEventNoticer(eventNoticingClass)) != null) {
                    this.fEventNoticers.put(eventNoticingClass, noticer);
                }
            }
        }
        return noticer;
    }
}

