/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.probe.net;

import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.probe.net.ManagedStreamCreationException;
import com.wily.introscope.agent.probe.net.SocketMonitor;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ManagedSocketInputStream
extends FilterInputStream {
    private final SocketMonitor fMonitor;

    public ManagedSocketInputStream(InputStream in, SocketMonitor monitor) throws IOException, ManagedStreamCreationException {
        super(in);
        if (monitor == null) {
            throw new ManagedStreamCreationException();
        }
        this.fMonitor = monitor;
    }

    @Override
    public int read() throws IOException {
        int byteRead;
        int addedComponentInfo = 0;
        try {
            addedComponentInfo = this.fMonitor.eventStartRead();
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                AgentShim.handleError("Exception eventStartRead in read() from socket input stream", t);
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable td2) {
                // empty catch block
            }
        }
        try {
            byteRead = super.read();
        }
        catch (IOException ioe) {
            try {
                this.fMonitor.eventStopReadWithException(addedComponentInfo);
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                try {
                    AgentShim.handleError("Exception eventStopReadWithException in read() from socket input stream", t);
                }
                catch (ThreadDeath td2) {
                    throw td2;
                }
                catch (Throwable td2) {
                    // empty catch block
                }
            }
            throw ioe;
        }
        catch (RuntimeException rte) {
            try {
                this.fMonitor.eventStopReadWithException(addedComponentInfo);
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                try {
                    AgentShim.handleError("Exception eventStopReadWithException in read() from socket input stream", t);
                }
                catch (ThreadDeath td2) {
                    throw td2;
                }
                catch (Throwable td2) {
                    // empty catch block
                }
            }
            throw rte;
        }
        catch (Error e) {
            try {
                this.fMonitor.eventStopReadWithException(addedComponentInfo);
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                try {
                    AgentShim.handleError("Exception eventStopReadWithException in read() from socket input stream", t);
                }
                catch (ThreadDeath td2) {
                    throw td2;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            throw e;
        }
        try {
            this.fMonitor.eventStopRead(addedComponentInfo, 1);
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                AgentShim.handleError("Exception eventStopRead in read() from socket input stream", t);
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return byteRead;
    }

    @Override
    public int read(byte[] b, int off, int length) throws IOException {
        int numberOfBytesRead;
        int addedComponentInfo = 0;
        try {
            addedComponentInfo = this.fMonitor.eventStartRead();
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                AgentShim.handleError("Exception eventStartRead in read(byte[],int,int) from socket input stream", t);
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable td2) {
                // empty catch block
            }
        }
        try {
            numberOfBytesRead = super.read(b, off, length);
        }
        catch (IOException ioe) {
            try {
                this.fMonitor.eventStopReadWithException(addedComponentInfo);
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                try {
                    AgentShim.handleError("Exception eventStopReadWithException in read(byte[],int,int) from socket input stream", t);
                }
                catch (ThreadDeath td2) {
                    throw td2;
                }
                catch (Throwable td2) {
                    // empty catch block
                }
            }
            throw ioe;
        }
        catch (RuntimeException rte) {
            try {
                this.fMonitor.eventStopReadWithException(addedComponentInfo);
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                try {
                    AgentShim.handleError("Exception eventStopReadWithException in read(byte[],int,int) from socket input stream", t);
                }
                catch (ThreadDeath td2) {
                    throw td2;
                }
                catch (Throwable td2) {
                    // empty catch block
                }
            }
            throw rte;
        }
        catch (Error e) {
            try {
                this.fMonitor.eventStopReadWithException(addedComponentInfo);
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                try {
                    AgentShim.handleError("Exception eventStopReadWithException in read(byte[],int,int) from socket input stream", t);
                }
                catch (ThreadDeath td2) {
                    throw td2;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            throw e;
        }
        try {
            this.fMonitor.eventStopRead(addedComponentInfo, numberOfBytesRead);
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                AgentShim.handleError("Exception eventStopRead in read(byte[],int,int) from socket input stream", t);
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return numberOfBytesRead;
    }
}

