/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.remote;

import com.wily.introscope.agent.AgentAdapter;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.remote.IRemoteAgent;
import com.wily.introscope.agent.remote.RemoteMethodTracer;
import com.wily.introscope.agent.remote.arf.ArfCommandConnection;
import com.wily.introscope.agent.remote.arf.ArfDataConnection;
import com.wily.introscope.agent.remote.arf.TCPArfTransport;
import com.wily.introscope.agent.trace.EmptyMethodTracer;
import com.wily.introscope.agent.trace.IMethodTracer;
import com.wily.introscope.agent.trace.IParameterizedMethodTracer;
import com.wily.util.adt.IAtomicNumber;
import com.wily.util.feedback.IModuleFeedbackChannel;

public class RemoteAgent
extends AgentAdapter
implements IRemoteAgent {
    private final IModuleFeedbackChannel fFeedback;
    private final ArfCommandConnection fCmdConn;
    private final ArfDataConnection fDataConn;
    private final IAtomicNumber fArfSequence;
    private final IAtomicNumber fThreadSequence;
    private final ThreadLocal fThreadId = new ThreadLocal();
    private static final IParameterizedMethodTracer sNoOpTracer = new EmptyMethodTracer();

    public RemoteAgent(IAgent delegate, String args) {
        super(delegate);
        this.fFeedback = delegate.IAgent_getModuleFeedback();
        TCPArfTransport transport = new TCPArfTransport(delegate);
        String[] agentInfo = delegate.IAgent_getHostProcessAgentTriplet();
        String instanceId = System.getProperty("introscope.agent.agentName", agentInfo[2]);
        this.fCmdConn = transport.getCommandConnection(args, agentInfo[1], "java", "123", instanceId);
        this.fDataConn = transport.getDataConnection(args, agentInfo[1], "java", "123", instanceId);
        this.fArfSequence = delegate.IAgent_getAtomicNumberFactory().getInstance(0L);
        this.fThreadSequence = delegate.IAgent_getAtomicNumberFactory().getInstance(0L);
    }

    @Override
    public IMethodTracer IAgent_loadTracer(int probeHashCode, String probeClassName, String probeMethodName, String probeMethodDescriptor, Object tracedObject, String tracerEncoding) {
        if (tracerEncoding.indexOf("BlamePointTracer") > 0) {
            RemoteMethodTracer tracer = new RemoteMethodTracer(probeHashCode, probeClassName, probeMethodName, probeMethodDescriptor, tracedObject, tracerEncoding, this);
            tracer.IMethodTracer_startTrace();
            return tracer;
        }
        return sNoOpTracer;
    }

    @Override
    public IParameterizedMethodTracer IAgent_loadParameterizedTracer(int probeHashCode, String probeClassName, String probeMethodName, String probeMethodDescriptor, Object tracedObject, String tracerEncoding) {
        if (tracerEncoding.indexOf("BlamePointTracer") > 0) {
            return new RemoteMethodTracer(probeHashCode, probeClassName, probeMethodName, probeMethodDescriptor, tracedObject, tracerEncoding, this);
        }
        return sNoOpTracer;
    }

    @Override
    public void IAgent_noticeEvent(String probeClassName, String probeMethodName, String probeMethodDescriptor, String eventNoticingClass, String eventType, Object eventSpecificReference, String eventSpecificData, String eventSpecificData2) {
        super.IAgent_noticeEvent(probeClassName, probeMethodName, probeMethodDescriptor, eventNoticingClass, eventType, eventSpecificReference, eventSpecificData, eventSpecificData2);
    }

    @Override
    public long getNextSequence() {
        return this.fArfSequence.incrementLongAndGet();
    }

    @Override
    public String getThreadId() {
        Integer id = (Integer)this.fThreadId.get();
        if (id == null) {
            id = this.fThreadSequence.incrementIntAndGet();
            this.fThreadId.set(id);
        }
        return id.toString();
    }

    @Override
    public void sendEventMessage(String msg) {
        if (this.fDataConn != null) {
            this.fDataConn.send(msg);
        }
    }
}

