/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.runtime.java.enterprise;

import com.wily.introscope.agent.IHarvester;
import com.wily.introscope.agent.connection.PlatformServerConnectionManager;
import com.wily.introscope.agent.connection.ServerConnectionManager;
import com.wily.introscope.agent.enterprise.EnterpriseAgent;
import com.wily.introscope.agent.extension.IExtensionLocatorPolicy;
import com.wily.introscope.agent.runtime.java.enterprise.Java15AgentInitializationCallBackFactory;
import com.wily.introscope.agent.runtime.java.enterprise.Java2PostConstructionInitializationCallBack;
import com.wily.introscope.agent.runtime.java.enterprise.Java2PostConstructionInitializationHelper;
import com.wily.introscope.agent.runtime.java.environment.EnvironmentStatisticsHandler;
import com.wily.introscope.agent.trace.HttpServletTracer;
import com.wily.introscope.agent.trace.servlet.LoaderContext;
import com.wily.introscope.agent.transactiontrace.CrossProcessDataHelper;
import com.wily.introscope.agent.transactiontrace.IPlatformCrossProcessDataHelper;
import com.wily.introscope.agent.transformer.IInstrumentationAcceptor;
import com.wily.introscope.agent.transformer.dynamic.AInstrumentationHelper;
import com.wily.introscope.spec.metric.AgentMetric;
import com.wily.introscope.spec.metric.AgentMetricData;
import com.wily.introscope.spec.metric.BadlyFormedNameException;
import com.wily.util.extension.IExtensionLocator;
import com.wily.util.extension.ShallowJarExtensionLocator;
import com.wily.util.feedback.AApplicationFeedbackChannel;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.io.ExtendedFile;
import com.wily.util.text.IStringLocalizer;
import java.security.ProtectionDomain;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public final class Java2EnterpriseAgent
extends EnterpriseAgent {
    private static final AgentMetric[] kEmptyInitialMetrics = new AgentMetric[0];
    private static final String[] INVALID_CLASSNAMES_COMPILED_JAVA5 = new String[]{"package-info"};
    private List<ClassLoaderListenerEntry> fClassLoaderListeners = new CopyOnWriteArrayList<ClassLoaderListenerEntry>();
    private volatile boolean fClassLoaderListenersSet = false;

    public Java2EnterpriseAgent(AApplicationFeedbackChannel feedback, String mainClassName) throws BadlyFormedNameException {
        super(feedback, mainClassName, new ShallowJarPolicy());
    }

    @Override
    protected void doPostConstructionInitialize() {
        if (AInstrumentationHelper.isValidate()) {
            return;
        }
        LoaderContext.initializeContext(this);
        Java2PostConstructionInitializationHelper.onPostConstructionInitialize(this);
        AInstrumentationHelper.applyInstrumentation((IInstrumentationAcceptor)((Object)this.getTransformerAdministrator().getDynamicInstrumentationTransformer()));
        if (!AInstrumentationHelper.isAgentStartedFromPremain()) {
            Java2PostConstructionInitializationCallBack agentInitialiazationCallbackForStaticInstrumentation = Java15AgentInitializationCallBackFactory.createObject();
            agentInitialiazationCallbackForStaticInstrumentation.onPostConstructionInitialize(this);
        }
        super.doPostConstructionInitialize();
        HttpServletTracer.initializeParameterLoader(this);
        EnvironmentStatisticsHandler service = new EnvironmentStatisticsHandler();
        service.registerAsync(this, this.getServiceAdministrator());
        this.notifyOnPostConstructInitializationComplete();
    }

    @Override
    public void addCrossProcessDataHelper(IPlatformCrossProcessDataHelper helper) {
        CrossProcessDataHelper.getInstance().register(helper);
    }

    public void addClassLoaderListener(String prefix, IClassLoaderListener listener) {
        this.fClassLoaderListeners.add(new ClassLoaderListenerEntry(prefix, listener));
        this.fClassLoaderListenersSet = true;
    }

    public void removeClassLoaderListener(IClassLoaderListener listener) {
        Iterator<ClassLoaderListenerEntry> it = this.fClassLoaderListeners.iterator();
        while (it.hasNext()) {
            ClassLoaderListenerEntry entry = it.next();
            if (entry.listener != listener) continue;
            it.remove();
        }
        if (this.fClassLoaderListeners.isEmpty()) {
            this.fClassLoaderListenersSet = false;
        }
    }

    private void notifyClassLoaderListeners(String className, ClassLoader loader) {
        if (this.fClassLoaderListenersSet) {
            for (ClassLoaderListenerEntry entry : this.fClassLoaderListeners) {
                if (entry.prefix != null && (className == null || !className.startsWith(entry.prefix))) continue;
                entry.listener.noticeClassLoader(className, loader);
            }
        }
    }

    @Override
    public byte[] IAgent_transformClass(boolean classLoaderIsAvailable, ClassLoader loader, String className, Class classBeingRedefined, ProtectionDomain protectionDomain, byte[] classBytes) {
        this.notifyClassLoaderListeners(className, loader);
        if (this.checkCompiledInvalidClassNames(className)) {
            this.getApplicationFeedback().verbose("Skipping invalid class name:" + className);
            return null;
        }
        return super.IAgent_transformClass(classLoaderIsAvailable, loader, className, classBeingRedefined, protectionDomain, classBytes);
    }

    private boolean checkCompiledInvalidClassNames(String className) {
        for (int i = 0; i < INVALID_CLASSNAMES_COMPILED_JAVA5.length; ++i) {
            if (className == null || !className.endsWith(INVALID_CLASSNAMES_COMPILED_JAVA5[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void doReportTimeslice(AgentMetric[] newMetrics, AgentMetricData[] timeslicedBindings, AgentMetric[] deadMetrics, int timesliceType) {
        ServerConnectionManager connection;
        PlatformServerConnectionManager nassConnection = this.IAgent_getPlatformServerConnection();
        ServerConnectionManager serverConnectionManager = connection = nassConnection != null ? nassConnection : this.IAgent_getIsengardServerConnection();
        if (connection != null) {
            connection.reportTimeslice(newMetrics, timeslicedBindings, deadMetrics, timesliceType);
            for (IHarvester harvester : kAdditionalHarvesters) {
                AgentMetricData[] harvested = harvester.harvest();
                AgentMetric[] newHarvestedMetrics = kEmptyInitialMetrics;
                if (timesliceType == 1) {
                    newHarvestedMetrics = new AgentMetric[harvested.length];
                    for (int j = 0; j < harvested.length; ++j) {
                        AgentMetric metric;
                        newHarvestedMetrics[j] = metric = harvested[j].getAgentMetric();
                    }
                }
                connection.reportTimeslice(newHarvestedMetrics, harvested, new AgentMetric[0], timesliceType);
            }
        }
    }

    private static class ClassLoaderListenerEntry {
        public final String prefix;
        public final IClassLoaderListener listener;

        public ClassLoaderListenerEntry(String prefix, IClassLoaderListener listener) {
            this.prefix = prefix;
            this.listener = listener;
        }
    }

    public static interface IClassLoaderListener {
        public void noticeClassLoader(String var1, ClassLoader var2);
    }

    private static class ShallowJarPolicy
    implements IExtensionLocatorPolicy {
        private ShallowJarPolicy() {
        }

        @Override
        public IExtensionLocator createExtensionLocator(IModuleFeedbackChannel feedback, IStringLocalizer localizer, ExtendedFile extensionDirectory) {
            ShallowJarExtensionLocator locator = null;
            locator = AInstrumentationHelper.isValidate() ? new ShallowJarExtensionLocator(feedback, localizer, extensionDirectory, true, AInstrumentationHelper.getValidationFeedbackChannel()) : new ShallowJarExtensionLocator(feedback, localizer, extensionDirectory, true);
            return locator;
        }
    }
}

