/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.cas;

import com.wily.introscope.agent.trace.cas.IMetricHolder;
import com.wily.introscope.agent.trace.cas.IRepository;
import com.wily.introscope.spec.metric.AgentMetric;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

public class ABlameMetricHolder
implements IMetricHolder {
    private final AtomicReference metrics = new AtomicReference();

    public ABlameMetricHolder() {
    }

    public ABlameMetricHolder(Map map) {
        ArrayList<MyEntry> metricList = new ArrayList<MyEntry>(5);
        if (map != null) {
            for (Map.Entry e : map.entrySet()) {
                metricList.add(new MyEntry(e.getKey(), e.getValue()));
            }
        }
        metricList.trimToSize();
        this.metrics.set(metricList);
    }

    @Override
    public void addMetric(AgentMetric addedMetric, IRepository structure) {
        ArrayList<MyEntry> newList;
        List originalList;
        if (this.metrics.get() == null) {
            return;
        }
        do {
            originalList = (List)this.metrics.get();
            newList = new ArrayList<MyEntry>();
            newList.addAll(originalList);
            boolean found = false;
            Iterator i = newList.iterator();
            while (i.hasNext()) {
                MyEntry e = (MyEntry)i.next();
                IRepository key = (IRepository)e.getKey();
                if (key == null || !key.equals(structure)) continue;
                AgentMetric[] existingConcurrentMetric = (AgentMetric[])e.getValue();
                AgentMetric[] newMetric = new AgentMetric[1 + existingConcurrentMetric.length];
                newMetric[0] = addedMetric;
                for (int j = 1; j < 1 + existingConcurrentMetric.length; ++j) {
                    newMetric[j] = existingConcurrentMetric[j - 1];
                }
                MyEntry newEntry = new MyEntry(e.getKey(), newMetric);
                i.remove();
                newList.add(newEntry);
                found = true;
                break;
            }
            if (found) continue;
            MyEntry newEntry = new MyEntry(structure, new AgentMetric[]{addedMetric});
            newList.add(newEntry);
        } while (!this.metrics.compareAndSet(originalList, newList));
        newList.trimToSize();
    }

    @Override
    public void addMetric(AgentMetric[] addedMetric, IRepository structure) {
        ArrayList<MyEntry> newList;
        List originalList;
        if (this.metrics.get() == null) {
            return;
        }
        do {
            originalList = (List)this.metrics.get();
            newList = new ArrayList<MyEntry>();
            newList.addAll(originalList);
            boolean found = false;
            Iterator k = newList.iterator();
            while (k.hasNext()) {
                MyEntry e = (MyEntry)k.next();
                IRepository key = (IRepository)e.getKey();
                if (key == null || !key.equals(structure)) continue;
                AgentMetric[] existingConcurrentMetric = (AgentMetric[])e.getValue();
                AgentMetric[] newMetric = new AgentMetric[addedMetric.length + existingConcurrentMetric.length];
                for (int i = 0; i < addedMetric.length; ++i) {
                    newMetric[i] = addedMetric[i];
                }
                for (int j = addedMetric.length; j < addedMetric.length + existingConcurrentMetric.length; ++j) {
                    newMetric[j] = existingConcurrentMetric[j - addedMetric.length];
                }
                MyEntry newEntry = new MyEntry(e.getKey(), newMetric);
                k.remove();
                newList.add(newEntry);
                found = true;
                break;
            }
            if (found) continue;
            MyEntry newEntry = new MyEntry(structure, addedMetric);
            newList.add(newEntry);
        } while (!this.metrics.compareAndSet(originalList, newList));
        newList.trimToSize();
    }

    @Override
    public Iterator getMetrics() {
        List metricsList = (List)this.metrics.get();
        if (metricsList == null || metricsList.isEmpty()) {
            return null;
        }
        return metricsList.iterator();
    }

    public IRepository getPerIntervalRepository() {
        if (this.metrics.get() == null) {
            return null;
        }
        for (Map.Entry entry : (List)this.metrics.get()) {
            AgentMetric[] metricsArray = (AgentMetric[])entry.getValue();
            for (int index = 0; index < metricsArray.length; ++index) {
                if (!metricsArray[index].getAttributeName().endsWith("Responses Per Interval")) continue;
                return (IRepository)entry.getKey();
            }
        }
        return null;
    }

    public IRepository getTimerRepository() {
        if (this.metrics.get() == null) {
            return null;
        }
        for (Map.Entry entry : (List)this.metrics.get()) {
            AgentMetric[] metricsArray = (AgentMetric[])entry.getValue();
            for (int index = 0; index < metricsArray.length; ++index) {
                if (!metricsArray[index].getAttributeName().endsWith("Average Response Time (ms)")) continue;
                return (IRepository)entry.getKey();
            }
        }
        return null;
    }

    public static class MyEntry
    implements Map.Entry {
        public final Object fKey;
        public final Object fValue;

        public MyEntry(Object key, Object value) {
            this.fKey = key;
            this.fValue = value;
        }

        public Object getKey() {
            return this.fKey;
        }

        public Object getValue() {
            return this.fValue;
        }

        public Object setValue(Object value) {
            return this.fValue;
        }
    }
}

