/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.cas;

import com.wily.introscope.agent.trace.cas.ABlameMetricHolder;
import com.wily.introscope.agent.trace.cas.AMixedTransactionElement;
import com.wily.introscope.agent.trace.cas.IBlameTransactionElement;
import com.wily.introscope.agent.trace.cas.IMetricHolder;
import com.wily.introscope.agent.trace.cas.IRepository;
import com.wily.introscope.agent.trace.cas.ITransactionElement;
import com.wily.introscope.agent.trace.hc2.WilyTransactionStructure;
import com.wily.introscope.spec.agent.beans.autotracing.AgentMetricThresholdTrigger;
import com.wily.introscope.spec.metric.AgentMetric;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import java.util.Iterator;
import java.util.Map;

public class BlameTransactionElement
extends AMixedTransactionElement
implements IBlameTransactionElement,
IMetricHolder {
    public static final int kFrontend = 1;
    public static final int kBackend = 2;
    public static final int kAutomaticEntryPoint = 3;
    public static final int kNone = 0;
    private final int fBlameStatus;
    private final int fPosition;
    private final IBlameTransactionElement fStartTrace;
    private final IBlameTransactionElement fPrevious;
    private final IMetricHolder metricHolder;
    protected final String fComponentName;
    private long fElapsedTimeAutoTraceThreshold = 0L;

    public BlameTransactionElement(String componentName, boolean isStartTrace, int blameStatus, ITransactionElement parent) {
        super(parent, isStartTrace);
        this.fBlameStatus = blameStatus;
        this.fStartTrace = null;
        this.fPrevious = null;
        this.metricHolder = new ABlameMetricHolder();
        this.fComponentName = componentName;
        this.fPosition = componentName == null ? 0 : componentName.lastIndexOf(":");
    }

    public BlameTransactionElement(String componentName, boolean isStartTrace, int blameStatus, ITransactionElement parent, IBlameTransactionElement previous, IBlameTransactionElement startTrace, Map agentMetrics) {
        super(parent, isStartTrace);
        this.fBlameStatus = blameStatus;
        this.fPrevious = previous;
        this.fStartTrace = startTrace;
        this.metricHolder = new ABlameMetricHolder(agentMetrics);
        this.fComponentName = componentName;
        this.fPosition = componentName == null ? 0 : componentName.lastIndexOf(":");
    }

    public BlameTransactionElement(String componentName, boolean isStartTrace, int blameStatus, ITransactionElement parent, IBlameTransactionElement previous, IBlameTransactionElement startTrace, IMetricHolder holder) {
        super(parent, isStartTrace);
        this.fBlameStatus = blameStatus;
        this.fPrevious = previous;
        this.fStartTrace = startTrace;
        this.metricHolder = holder;
        this.fComponentName = componentName;
        this.fPosition = componentName == null ? 0 : componentName.lastIndexOf(":");
    }

    @Override
    public IBlameTransactionElement getStartTraceBlamePoint() {
        if (this.fStartTrace != null) {
            return this.fStartTrace;
        }
        return this;
    }

    @Override
    public IBlameTransactionElement getPreviousBlamePoint() {
        return this.fPrevious;
    }

    @Override
    public boolean isBackend() {
        return this.getBlameStatus() == 2;
    }

    @Override
    public boolean isFrontend() {
        return this.getBlameStatus() == 1;
    }

    @Override
    public boolean isAutomaticEntryPoint() {
        return this.getBlameStatus() == 3;
    }

    protected int getBlameStatus() {
        return this.fBlameStatus;
    }

    public String toString() {
        return this.getParent() + "-->(BTE);" + (this.isBackend() ? "[B]" : (this.isFrontend() ? "[F]" : "[N]"));
    }

    @Override
    public void addMetric(AgentMetric[] addedMetric, IRepository structure) {
        this.getMetricHolder().addMetric(addedMetric, structure);
    }

    @Override
    public void addMetric(AgentMetric addedMetric, IRepository structure) {
        this.getMetricHolder().addMetric(addedMetric, structure);
    }

    @Override
    public Iterator getMetrics() {
        return this.getMetricHolder().getMetrics();
    }

    @Override
    public ITransactionElement getNextOnEndTransaction() {
        return this.getStartTraceBlamePoint().getParent();
    }

    @Override
    public boolean hasBackendInStack() {
        if (this.isBackend()) {
            return true;
        }
        return this.fPrevious == null ? false : this.fPrevious.hasBackendInStack();
    }

    public IMetricHolder getMetricHolder() {
        return this.metricHolder;
    }

    @Override
    public String getComponentName() {
        return this.fComponentName;
    }

    @Override
    public String getResourceName() {
        return this.fComponentName == null || this.fPosition <= 0 ? this.fComponentName : this.fComponentName.substring(0, this.fPosition);
    }

    public long getElapsedTimeAutoTraceThreshold() {
        return this.fElapsedTimeAutoTraceThreshold;
    }

    public void setElapsedTimeAutoTraceThreshold(long threshold) {
        this.fElapsedTimeAutoTraceThreshold = threshold;
    }

    public boolean setElapsedTimeAutoTraceThreshold(Map<AgentMetric.AgentMetricKey, AgentMetricThresholdTrigger> thresholds, IModuleFeedbackChannel feedback, Module module) {
        if (feedback != null) {
            feedback.trace(module, "Auto trace threshold set : checking " + this.toString());
        }
        Iterator it = this.getMetrics();
        while (it != null && it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            AgentMetric[] elementMetrics = (AgentMetric[])entry.getValue();
            AgentMetricThresholdTrigger threshold = WilyTransactionStructure.findArtMetricInArrayForThresholdTrigger(elementMetrics, thresholds, feedback, module);
            if (threshold == null) continue;
            this.fElapsedTimeAutoTraceThreshold = threshold.getElapsedTimeThreshold();
            return true;
        }
        return false;
    }

    public boolean clearElapsedTimeAutoTraceThreshold(Map<AgentMetric.AgentMetricKey, AgentMetricThresholdTrigger> thresholds, IModuleFeedbackChannel feedback, Module module) {
        if (feedback != null) {
            feedback.trace(module, "Auto trace threshold clear: checking " + this.toString());
        }
        Iterator it = this.getMetrics();
        while (it != null && it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            AgentMetric[] elementMetrics = (AgentMetric[])entry.getValue();
            AgentMetricThresholdTrigger threshold = WilyTransactionStructure.findArtMetricInArrayForThresholdTrigger(elementMetrics, thresholds, feedback, module);
            if (threshold == null) continue;
            this.fElapsedTimeAutoTraceThreshold = 0L;
            return true;
        }
        return false;
    }

    public boolean clearElapsedTimeAutoTraceThreshold() {
        this.fElapsedTimeAutoTraceThreshold = 0L;
        return true;
    }
}

